/*
 * Decompiled with CFR 0.152.
 */
package io.activej.record;

import io.activej.codegen.ClassBuilder;
import io.activej.codegen.ClassKey;
import io.activej.codegen.DefiningClassLoader;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Expressions;
import io.activej.record.Record;
import io.activej.record.RecordScheme;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RecordProjection
implements UnaryOperator<Record>,
BiConsumer<Record, Record> {
    private final RecordScheme schemeFrom;
    private final RecordScheme schemeTo;

    protected RecordProjection(RecordScheme from, RecordScheme to) {
        this.schemeFrom = from;
        this.schemeTo = to;
    }

    public static RecordProjection projection(RecordScheme schemeFrom, String ... fields) {
        return RecordProjection.projection(schemeFrom, Arrays.asList(fields));
    }

    public static RecordProjection projection(RecordScheme schemeFrom, Collection<String> fields) {
        return RecordProjection.projection(DefiningClassLoader.create(schemeFrom.getClassLoader()), schemeFrom, fields);
    }

    public static RecordProjection projection(DefiningClassLoader classLoader, RecordScheme schemeFrom, String ... fields) {
        return RecordProjection.projection(classLoader, schemeFrom, Arrays.asList(fields));
    }

    public static RecordProjection projection(DefiningClassLoader classLoader, RecordScheme schemeFrom, Collection<String> fields) {
        if (!RecordProjection.isParentChild(schemeFrom.getClassLoader(), classLoader)) {
            throw new IllegalArgumentException("Unrelated ClassLoaders");
        }
        RecordScheme schemeTo = RecordScheme.create(classLoader);
        HashMap<String, UnaryOperator<Expression>> mapping = new HashMap<String, UnaryOperator<Expression>>();
        for (String field : schemeFrom.getFields()) {
            Type fieldType = schemeFrom.getFieldType(field);
            if (!fields.contains(field)) continue;
            schemeTo.withField(field, fieldType);
            mapping.put(field, recordFrom -> schemeFrom.property((Expression)recordFrom, field));
        }
        return RecordProjection.projection(classLoader, Arrays.asList(schemeFrom, fields), schemeFrom, schemeTo, mapping);
    }

    public static RecordProjection projection(RecordScheme schemeFrom, RecordScheme schemeTo, Map<String, UnaryOperator<Expression>> mapping) {
        DefiningClassLoader classLoaderChild = RecordProjection.getClassLoaderChild(schemeFrom.getClassLoader(), schemeTo.getClassLoader());
        return RecordProjection.projection(DefiningClassLoader.create(classLoaderChild), null, schemeFrom, schemeTo, mapping);
    }

    @NotNull
    public static RecordProjection projection(DefiningClassLoader classLoader, @Nullable Object classKey, RecordScheme schemeFrom, RecordScheme schemeTo, Map<String, UnaryOperator<Expression>> mapping) {
        schemeFrom.build();
        schemeTo.build();
        return classLoader.ensureClassAndCreateInstance(ClassKey.of(RecordProjection.class, classKey), () -> ClassBuilder.create(RecordProjection.class, new Class[0]).withConstructor(Arrays.asList(RecordScheme.class, RecordScheme.class), Expressions.superConstructor(Expressions.arg(0), Expressions.arg(1))).withMethod("accept", Void.TYPE, Arrays.asList(Record.class, Record.class), Expressions.sequence(seq -> {
            for (Map.Entry entry : mapping.entrySet()) {
                seq.add(Expressions.set(schemeTo.property(Expressions.cast(Expressions.arg(1), schemeTo.getRecordClass()), (String)entry.getKey()), (Expression)((UnaryOperator)entry.getValue()).apply(Expressions.cast(Expressions.arg(0), schemeFrom.getRecordClass()))));
            }
        })), schemeFrom, schemeTo);
    }

    private static DefiningClassLoader getClassLoaderChild(DefiningClassLoader classLoader1, DefiningClassLoader classLoader2) {
        if (RecordProjection.isParentChild(classLoader1, classLoader2)) {
            return classLoader2;
        }
        if (RecordProjection.isParentChild(classLoader2, classLoader1)) {
            return classLoader1;
        }
        throw new IllegalArgumentException("Unrelated ClassLoaders");
    }

    private static boolean isParentChild(DefiningClassLoader maybeParent, DefiningClassLoader maybeChild) {
        for (ClassLoader cl = maybeChild; cl != null; cl = cl.getParent()) {
            if (cl != maybeParent) continue;
            return true;
        }
        return false;
    }

    public final RecordScheme getSchemeFrom() {
        return this.schemeFrom;
    }

    public final RecordScheme getSchemeTo() {
        return this.schemeTo;
    }

    @Override
    public Record apply(Record recordFrom) {
        Record recordTo = this.schemeTo.record();
        this.accept(recordFrom, recordTo);
        return recordTo;
    }

    @Override
    public abstract void accept(Record var1, Record var2);
}

