/*
 * Decompiled with CFR 0.152.
 */
package io.activej.record;

import io.activej.record.RecordScheme;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class Record {
    private final RecordScheme scheme;

    protected Record(RecordScheme scheme) {
        this.scheme = scheme;
    }

    public final RecordScheme getScheme() {
        return this.scheme;
    }

    public <T> T get(String field) {
        return this.scheme.get(this, field);
    }

    public <T> T get(int field) {
        return this.scheme.get(this, field);
    }

    public int getInt(String field) {
        return this.scheme.getInt(this, field);
    }

    public int getInt(int field) {
        return this.scheme.getInt(this, field);
    }

    public long getLong(String field) {
        return this.scheme.getLong(this, field);
    }

    public long getLong(int field) {
        return this.scheme.getLong(this, field);
    }

    public float getFloat(String field) {
        return this.scheme.getFloat(this, field);
    }

    public float getFloat(int field) {
        return this.scheme.getFloat(this, field);
    }

    public double getDouble(String field) {
        return this.scheme.getDouble(this, field);
    }

    public double getDouble(int field) {
        return this.scheme.getDouble(this, field);
    }

    public <T> void set(String field, T value) {
        this.scheme.set(this, field, value);
    }

    public <T> void set(int field, T value) {
        this.scheme.set(this, field, value);
    }

    public void setInt(String field, int value) {
        this.scheme.setInt(this, field, value);
    }

    public void setInt(int field, int value) {
        this.scheme.setInt(this, field, value);
    }

    public void setLong(String field, long value) {
        this.scheme.setLong(this, field, value);
    }

    public void setLong(int field, long value) {
        this.scheme.setLong(this, field, value);
    }

    public void setFloat(String field, float value) {
        this.scheme.setFloat(this, field, value);
    }

    public void setFloat(int field, float value) {
        this.scheme.setFloat(this, field, value);
    }

    public void setDouble(String field, double value) {
        this.scheme.setDouble(this, field, value);
    }

    public void setDouble(int field, double value) {
        this.scheme.setDouble(this, field, value);
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(this.scheme.size() * 2);
        this.toMap(result);
        return result;
    }

    public Object[] toArray() {
        Object[] result = new Object[this.scheme.size()];
        this.toArray(result);
        return result;
    }

    public Map<String, Object> toMap(Map<String, Object> result) {
        for (int i = 0; i < this.scheme.size(); ++i) {
            result.put(this.scheme.fields[i], this.get(i));
        }
        return result;
    }

    public Object[] toArray(Object[] result) {
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.get(i);
        }
        return result;
    }

    public void setMap(Map<String, Object> values) {
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    public void setArray(Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.set(i, values[i]);
        }
    }

    public String toString() {
        return this.toMap().toString();
    }
}

