/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen.expression;

import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.ExpressionArithmeticOp;
import io.activej.codegen.expression.ExpressionArrayGet;
import io.activej.codegen.expression.ExpressionArrayNew;
import io.activej.codegen.expression.ExpressionArraySet;
import io.activej.codegen.expression.ExpressionBooleanAnd;
import io.activej.codegen.expression.ExpressionBooleanNot;
import io.activej.codegen.expression.ExpressionBooleanOr;
import io.activej.codegen.expression.ExpressionCall;
import io.activej.codegen.expression.ExpressionCallSuper;
import io.activej.codegen.expression.ExpressionCast;
import io.activej.codegen.expression.ExpressionCmp;
import io.activej.codegen.expression.ExpressionComparator;
import io.activej.codegen.expression.ExpressionConcat;
import io.activej.codegen.expression.ExpressionConstant;
import io.activej.codegen.expression.ExpressionConstructor;
import io.activej.codegen.expression.ExpressionHash;
import io.activej.codegen.expression.ExpressionIf;
import io.activej.codegen.expression.ExpressionIsNotNull;
import io.activej.codegen.expression.ExpressionIsNull;
import io.activej.codegen.expression.ExpressionIterate;
import io.activej.codegen.expression.ExpressionLength;
import io.activej.codegen.expression.ExpressionLet;
import io.activej.codegen.expression.ExpressionLoop;
import io.activej.codegen.expression.ExpressionNeg;
import io.activej.codegen.expression.ExpressionNull;
import io.activej.codegen.expression.ExpressionSequence;
import io.activej.codegen.expression.ExpressionSet;
import io.activej.codegen.expression.ExpressionStaticCall;
import io.activej.codegen.expression.ExpressionStaticCallSelf;
import io.activej.codegen.expression.ExpressionStaticField;
import io.activej.codegen.expression.ExpressionSuperConstructor;
import io.activej.codegen.expression.ExpressionSwitch;
import io.activej.codegen.expression.ExpressionThrow;
import io.activej.codegen.expression.ExpressionToString;
import io.activej.codegen.expression.ExpressionVoid;
import io.activej.codegen.expression.Property;
import io.activej.codegen.expression.StoreDef;
import io.activej.codegen.expression.VarArg;
import io.activej.codegen.expression.VarThis;
import io.activej.codegen.expression.Variable;
import io.activej.codegen.operation.ArithmeticOperation;
import io.activej.codegen.operation.CompareOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.objectweb.asm.Type;

public class Expressions {
    public static Expression value(Object value) {
        return new ExpressionConstant(value);
    }

    public static Expression value(Object value, Class<?> type) {
        return new ExpressionConstant(value, type);
    }

    public static Expression sequence(Expression ... parts) {
        return new ExpressionSequence(Arrays.asList(parts));
    }

    public static Expression sequence(List<Expression> parts) {
        ArrayList<Expression> list = new ArrayList<Expression>(parts.size());
        for (Expression part : parts) {
            if (part instanceof ExpressionSequence) {
                list.addAll(((ExpressionSequence)part).expressions);
                continue;
            }
            list.add(part);
        }
        return new ExpressionSequence(list);
    }

    public static Expression sequence(Consumer<List<Expression>> consumer) {
        ArrayList<Expression> seq = new ArrayList<Expression>();
        consumer.accept(seq);
        return new ExpressionSequence(seq);
    }

    public static Expression sequence(Function<List<Expression>, Expression> fn) {
        ArrayList<Expression> seq = new ArrayList<Expression>();
        Expression result = fn.apply(seq);
        seq.add(result);
        return new ExpressionSequence(seq);
    }

    public static Expression let(Expression expression, Function<Variable, Expression> fn) {
        ExpressionLet variable = new ExpressionLet(expression);
        return Expressions.sequence(variable, fn.apply(variable));
    }

    public static Expression let(List<Expression> expressions, Function<List<Variable>, Expression> fn) {
        List variables = expressions.stream().map(ExpressionLet::new).collect(Collectors.toList());
        ArrayList<Expression> sequence = new ArrayList<Expression>(expressions.size() + 1);
        sequence.addAll(variables);
        sequence.add(fn.apply(variables));
        return Expressions.sequence(sequence);
    }

    public static Expression let(Expression[] expressions, Function<Variable[], Expression> fn) {
        return Expressions.let(Arrays.asList(expressions), (List<Variable> variables) -> (Expression)fn.apply(variables.toArray(new Variable[0])));
    }

    public static Expression set(StoreDef to, Expression from) {
        return new ExpressionSet(to, from);
    }

    public static Expression cast(Expression expression, Class<?> type) {
        return new ExpressionCast(expression, Type.getType(type));
    }

    public static Expression castIntoSelf(Expression expression) {
        return new ExpressionCast(expression, ExpressionCast.SELF_TYPE);
    }

    public static Variable property(Expression owner, String property) {
        return new Property(owner, property);
    }

    public static Variable staticField(Class<?> owner, String field) {
        return new ExpressionStaticField(owner, field);
    }

    public static Variable staticField(String field) {
        return new ExpressionStaticField(null, field);
    }

    public static Expression self() {
        return new VarThis();
    }

    public static Variable arg(int argument) {
        return new VarArg(argument);
    }

    public static Expression alwaysFalse() {
        return Expressions.value(false);
    }

    public static Expression alwaysTrue() {
        return Expressions.value(true);
    }

    public static Expression not(Expression expression) {
        return new ExpressionBooleanNot(expression);
    }

    public static Expression cmp(CompareOperation eq, Expression left, Expression right) {
        return new ExpressionCmp(eq, left, right);
    }

    public static Expression cmpEq(Expression left, Expression right) {
        return Expressions.cmp(CompareOperation.EQ, left, right);
    }

    public static Expression cmpGe(Expression left, Expression right) {
        return Expressions.cmp(CompareOperation.GE, left, right);
    }

    public static Expression cmpLe(Expression left, Expression right) {
        return Expressions.cmp(CompareOperation.LE, left, right);
    }

    public static Expression cmpLt(Expression left, Expression right) {
        return Expressions.cmp(CompareOperation.LT, left, right);
    }

    public static Expression cmpGt(Expression left, Expression right) {
        return Expressions.cmp(CompareOperation.GT, left, right);
    }

    public static Expression cmpNe(Expression left, Expression right) {
        return Expressions.cmp(CompareOperation.NE, left, right);
    }

    public static Expression and(List<Expression> predicates) {
        return new ExpressionBooleanAnd(predicates);
    }

    public static Expression and(Stream<Expression> predicates) {
        return Expressions.and(predicates.collect(Collectors.toList()));
    }

    public static Expression and(Expression ... predicates) {
        return Expressions.and(Arrays.asList(predicates));
    }

    public static Expression and(Expression predicate1, Expression predicate2) {
        return Expressions.and(Arrays.asList(predicate1, predicate2));
    }

    public static ExpressionBooleanOr or(List<Expression> predicates) {
        return new ExpressionBooleanOr(predicates);
    }

    public static ExpressionBooleanOr or(Stream<Expression> predicates) {
        return Expressions.or(predicates.collect(Collectors.toList()));
    }

    public static ExpressionBooleanOr or(Expression ... predicates) {
        return Expressions.or(Arrays.asList(predicates));
    }

    public static ExpressionBooleanOr or(Expression predicate1, Expression predicate2) {
        return Expressions.or(Arrays.asList(predicate1, predicate2));
    }

    public static Expression equalsImpl(List<String> properties) {
        return Expressions.and(properties.stream().map(property -> Expressions.cmpEq(Expressions.property(Expressions.self(), property), Expressions.property(Expressions.castIntoSelf(Expressions.arg(0)), property))));
    }

    public static Expression equalsImpl(String ... properties) {
        return Expressions.equalsImpl(Arrays.asList(properties));
    }

    public static Expression toStringImpl(List<String> properties) {
        ExpressionToString toString = ExpressionToString.create();
        for (String property : properties) {
            toString.with(property + "=", Expressions.property(Expressions.self(), property));
        }
        return toString;
    }

    public static Expression toStringImpl(String ... properties) {
        return Expressions.toStringImpl(Arrays.asList(properties));
    }

    public static Expression concat(List<Expression> arguments) {
        if (arguments.isEmpty()) {
            return Expressions.value("");
        }
        return ExpressionConcat.create(arguments);
    }

    public static Expression concat(Expression ... arguments) {
        return Expressions.concat(Arrays.asList(arguments));
    }

    public static Expression compare(Class<?> type, List<String> properties) {
        ExpressionComparator comparator = ExpressionComparator.create();
        for (String property : properties) {
            comparator.with(ExpressionComparator.leftProperty(type, property), ExpressionComparator.rightProperty(type, property), true);
        }
        return comparator;
    }

    public static Expression compare(Class<?> type, String ... properties) {
        return Expressions.compare(type, Arrays.asList(properties));
    }

    public static Expression compareToImpl(List<String> properties) {
        ExpressionComparator comparator = ExpressionComparator.create();
        for (String property : properties) {
            comparator.with(ExpressionComparator.thisProperty(property), ExpressionComparator.thatProperty(property), true);
        }
        return comparator;
    }

    public static Expression compareToImpl(String ... properties) {
        return Expressions.compareToImpl(Arrays.asList(properties));
    }

    public static Expression hash(List<Expression> properties) {
        return new ExpressionHash(properties);
    }

    public static Expression hash(Expression ... properties) {
        return Expressions.hash(Arrays.asList(properties));
    }

    public static Expression hashCodeImpl(String ... properties) {
        return Expressions.hashCodeImpl(Arrays.asList(properties));
    }

    public static Expression hashCodeImpl(List<String> properties) {
        return new ExpressionHash(properties.stream().map(property -> Expressions.property(Expressions.self(), property)).collect(Collectors.toList()));
    }

    public static Class<?> unifyArithmeticTypes(Class<?> ... types) {
        return ExpressionArithmeticOp.unifyArithmeticTypes(types);
    }

    public static Class<?> unifyArithmeticTypes(List<Class<?>> types) {
        return ExpressionArithmeticOp.unifyArithmeticTypes(types.toArray(new Class[0]));
    }

    public static Expression arithmeticOp(ArithmeticOperation op, Expression left, Expression right) {
        return new ExpressionArithmeticOp(op, left, right);
    }

    public static Expression arithmeticOp(String op, Expression left, Expression right) {
        return new ExpressionArithmeticOp(ArithmeticOperation.operation(op), left, right);
    }

    public static Expression add(Expression left, Expression right) {
        return new ExpressionArithmeticOp(ArithmeticOperation.ADD, left, right);
    }

    public static Expression inc(Expression value) {
        return Expressions.add(value, Expressions.value(1));
    }

    public static Expression sub(Expression left, Expression right) {
        return new ExpressionArithmeticOp(ArithmeticOperation.SUB, left, right);
    }

    public static Expression dec(Expression value) {
        return Expressions.sub(value, Expressions.value(1));
    }

    public static Expression mul(Expression left, Expression right) {
        return new ExpressionArithmeticOp(ArithmeticOperation.MUL, left, right);
    }

    public static Expression div(Expression left, Expression right) {
        return new ExpressionArithmeticOp(ArithmeticOperation.DIV, left, right);
    }

    public static Expression rem(Expression left, Expression right) {
        return new ExpressionArithmeticOp(ArithmeticOperation.REM, left, right);
    }

    public static Expression neg(Expression arg) {
        return new ExpressionNeg(arg);
    }

    public static Expression bitAnd(Expression left, Expression right) {
        return new ExpressionArithmeticOp(ArithmeticOperation.AND, left, right);
    }

    public static Expression bitOr(Expression left, Expression right) {
        return new ExpressionArithmeticOp(ArithmeticOperation.OR, left, right);
    }

    public static Expression bitXor(Expression left, Expression right) {
        return new ExpressionArithmeticOp(ArithmeticOperation.XOR, left, right);
    }

    public static Expression shl(Expression left, Expression right) {
        return new ExpressionArithmeticOp(ArithmeticOperation.SHL, left, right);
    }

    public static Expression shr(Expression left, Expression right) {
        return new ExpressionArithmeticOp(ArithmeticOperation.SHR, left, right);
    }

    public static Expression ushr(Expression left, Expression right) {
        return new ExpressionArithmeticOp(ArithmeticOperation.USHR, left, right);
    }

    public static Expression constructor(Class<?> type, Expression ... fields) {
        return new ExpressionConstructor(type, Arrays.asList(fields));
    }

    public static Expression superConstructor(Expression ... fields) {
        return new ExpressionSuperConstructor(Arrays.asList(fields));
    }

    public static Expression callSuper(String methodName, Expression ... arguments) {
        return new ExpressionCallSuper(methodName, arguments);
    }

    public static Expression call(Expression owner, String methodName, Expression ... arguments) {
        return new ExpressionCall(owner, methodName, arguments);
    }

    public static Expression ifThenElse(Expression condition, Expression left, Expression right) {
        return new ExpressionIf(condition, left, right);
    }

    public static Expression length(Expression field) {
        return new ExpressionLength(field);
    }

    public static Expression arrayNew(Class<?> type, Expression length) {
        return new ExpressionArrayNew(type, length);
    }

    public static Expression staticCall(Class<?> owner, String method, Expression ... arguments) {
        return new ExpressionStaticCall(owner, method, Arrays.asList(arguments));
    }

    public static Expression staticCallSelf(String method, Expression ... arguments) {
        return new ExpressionStaticCallSelf(method, Arrays.asList(arguments));
    }

    public static Expression arrayGet(Expression array, Expression index) {
        return new ExpressionArrayGet(array, index);
    }

    public static Expression isNull(Expression field) {
        return new ExpressionIsNull(field);
    }

    public static Expression isNotNull(Expression field) {
        return new ExpressionIsNotNull(field);
    }

    public static Expression nullRef(Class<?> type) {
        return new ExpressionNull(type);
    }

    public static Expression nullRef(Type type) {
        return new ExpressionNull(type);
    }

    public static Expression voidExp() {
        return ExpressionVoid.INSTANCE;
    }

    public static Expression throwException(Expression exception) {
        return new ExpressionThrow(exception);
    }

    public static Expression throwException(Class<? extends Throwable> exceptionClass) {
        return new ExpressionThrow(Expressions.constructor(exceptionClass, new Expression[0]));
    }

    public static Expression throwException(Class<? extends Throwable> exceptionClass, Expression message) {
        return new ExpressionThrow(Expressions.constructor(exceptionClass, message));
    }

    public static Expression throwException(Class<? extends Throwable> exceptionClass, String message) {
        return new ExpressionThrow(Expressions.constructor(exceptionClass, Expressions.value(message)));
    }

    public static Expression throwException(Throwable exception) {
        return new ExpressionThrow(Expressions.value(exception));
    }

    public static Expression switchByIndex(Expression index, Expression ... expressions) {
        return Expressions.switchByIndex(index, Arrays.asList(expressions), ExpressionSwitch.DEFAULT_EXPRESSION);
    }

    public static Expression switchByIndex(Expression index, List<Expression> expressions) {
        return Expressions.switchByIndex(index, expressions, ExpressionSwitch.DEFAULT_EXPRESSION);
    }

    public static Expression switchByIndex(Expression index, List<Expression> expressions, Expression defaultExpression) {
        return new ExpressionSwitch(index, IntStream.range(0, expressions.size()).mapToObj(Expressions::value).collect(Collectors.toList()), expressions, defaultExpression);
    }

    public static Expression switchByKey(Expression key, List<Expression> matchCases, List<Expression> matchExpressions) {
        return new ExpressionSwitch(key, matchCases, matchExpressions, ExpressionSwitch.DEFAULT_EXPRESSION);
    }

    public static Expression switchByKey(Expression key, List<Expression> matchCases, List<Expression> matchExpressions, Expression defaultExpression) {
        return new ExpressionSwitch(key, matchCases, matchExpressions, defaultExpression);
    }

    public static Expression switchByKey(Expression key, Map<Expression, Expression> cases) {
        return Expressions.switchByKey(key, cases, ExpressionSwitch.DEFAULT_EXPRESSION);
    }

    public static Expression switchByKey(Expression key, Map<Expression, Expression> cases, Expression defaultExpression) {
        ArrayList<Expression> matchCases = new ArrayList<Expression>();
        ArrayList<Expression> matchExpressions = new ArrayList<Expression>();
        for (Map.Entry<Expression, Expression> entry : cases.entrySet()) {
            matchCases.add(entry.getKey());
            matchExpressions.add(entry.getValue());
        }
        return new ExpressionSwitch(key, matchCases, matchExpressions, defaultExpression);
    }

    public static Expression arraySet(Expression array, Expression position, Expression newElement) {
        return new ExpressionArraySet(array, position, newElement);
    }

    public static Expression loop(Expression body) {
        return Expressions.loop(body, Expressions.voidExp());
    }

    public static Expression loop(Expression condition, Expression body) {
        return new ExpressionLoop(condition, body);
    }

    public static Expression iterate(Expression from, Expression to, UnaryOperator<Expression> action) {
        return new ExpressionIterate(from, to, action);
    }

    public static Expression iterateArray(Variable array, UnaryOperator<Expression> action) {
        return Expressions.iterate(Expressions.value(0), Expressions.length(array), i -> (Expression)action.apply(Expressions.arrayGet(array, i)));
    }

    public static Expression iterateList(Variable list, UnaryOperator<Expression> action) {
        return Expressions.iterate(Expressions.value(0), Expressions.length(list), i -> (Expression)action.apply(Expressions.call(list, "get", i)));
    }

    public static Expression iterateIterable(Expression iterable, UnaryOperator<Expression> action) {
        return Expressions.let(Expressions.call(iterable, "iterator", new Expression[0]), (Variable it) -> Expressions.iterateIterator(it, action));
    }

    public static Expression iterateIterator(Variable iterator, UnaryOperator<Expression> action) {
        return Expressions.loop(Expressions.call(iterator, "hasNext", new Expression[0]), Expressions.let(Expressions.call(iterator, "next", new Expression[0]), action::apply));
    }

    public static Expression iterateMap(Expression map, UnaryOperator<Expression> keyAction, UnaryOperator<Expression> valueAction) {
        return Expressions.iterateMap(map, (key, value) -> Expressions.sequence((Expression)keyAction.apply((Expression)key), (Expression)valueAction.apply((Expression)value)));
    }

    public static Expression iterateMap(Expression map, BinaryOperator<Expression> action) {
        return Expressions.iterateIterable(Expressions.call(map, "entrySet", new Expression[0]), it -> (Expression)action.apply(Expressions.call(Expressions.cast(it, Map.Entry.class), "getKey", new Expression[0]), Expressions.call(Expressions.cast(it, Map.Entry.class), "getValue", new Expression[0])));
    }

    public static Expression iterateMapKeys(Expression map, UnaryOperator<Expression> action) {
        return Expressions.iterateIterable(Expressions.call(map, "keySet", new Expression[0]), action);
    }

    public static Expression iterateMapValues(Expression map, UnaryOperator<Expression> action) {
        return Expressions.iterateIterable(Expressions.call(map, "values", new Expression[0]), action);
    }
}

