/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen.expression;

import io.activej.codegen.Context;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.util.Utils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public final class ExpressionToString
implements Expression {
    private String begin = "{";
    private String end = "}";
    private String separator = " ";
    private final Map<Object, Expression> arguments = new LinkedHashMap<Object, Expression>();

    ExpressionToString() {
    }

    public static ExpressionToString create() {
        return new ExpressionToString();
    }

    public ExpressionToString with(String label, Expression expression) {
        this.arguments.put(label, expression);
        return this;
    }

    public ExpressionToString with(Expression expression) {
        this.arguments.put(this.arguments.size() + 1, expression);
        return this;
    }

    public ExpressionToString withSeparator(String separator) {
        this.separator = separator;
        return this;
    }

    public ExpressionToString withQuotes(String begin, String end) {
        this.begin = begin;
        this.end = end;
        return this;
    }

    public ExpressionToString withQuotes(String begin, String end, String separator) {
        this.begin = begin;
        this.end = end;
        this.separator = separator;
        return this;
    }

    @Override
    public Type load(Context ctx) {
        GeneratorAdapter g = ctx.getGeneratorAdapter();
        g.newInstance(Type.getType(StringBuilder.class));
        g.dup();
        g.invokeConstructor(Type.getType(StringBuilder.class), Method.getMethod((String)"void <init> ()"));
        boolean first = true;
        for (Map.Entry<Object, Expression> entry : this.arguments.entrySet()) {
            String str = first ? this.begin : this.separator;
            first = false;
            if (entry.getKey() instanceof String) {
                str = str + entry.getKey();
            }
            if (!str.isEmpty()) {
                g.dup();
                g.push(str);
                g.invokeVirtual(Type.getType(StringBuilder.class), Method.getMethod((String)"StringBuilder append(String)"));
                g.pop();
            }
            g.dup();
            Type type = entry.getValue().load(ctx);
            if (Utils.isPrimitiveType(type)) {
                g.invokeStatic(Utils.wrap(type), new Method("toString", Type.getType(String.class), new Type[]{type}));
            } else {
                Label nullLabel = new Label();
                Label afterToString = new Label();
                g.dup();
                g.ifNull(nullLabel);
                g.invokeVirtual(type, Method.getMethod((String)"String toString()"));
                g.goTo(afterToString);
                g.mark(nullLabel);
                g.pop();
                g.push("null");
                g.mark(afterToString);
            }
            g.invokeVirtual(Type.getType(StringBuilder.class), Method.getMethod((String)"StringBuilder append(String)"));
            g.pop();
        }
        if (!this.end.isEmpty()) {
            g.dup();
            g.push(this.end);
            g.invokeVirtual(Type.getType(StringBuilder.class), Method.getMethod((String)"StringBuilder append(String)"));
            g.pop();
        }
        g.invokeVirtual(Type.getType(StringBuilder.class), Method.getMethod((String)"String toString()"));
        return Type.getType(String.class);
    }
}

