/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen.expression;

import io.activej.codegen.Context;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.expression.VarLocal;
import io.activej.codegen.util.Utils;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

final class ExpressionSwitch
implements Expression {
    public static final Expression DEFAULT_EXPRESSION = Expressions.throwException(IllegalArgumentException.class);
    private final Expression value;
    private final List<Expression> matchCases;
    private final List<Expression> matchExpressions;
    private final Expression defaultExpression;

    ExpressionSwitch(Expression value, List<Expression> matchCases, List<Expression> matchExpressions, Expression defaultExpression) {
        this.value = value;
        this.matchCases = matchCases;
        this.matchExpressions = matchExpressions;
        this.defaultExpression = defaultExpression;
    }

    @Override
    public Type load(Context ctx) {
        GeneratorAdapter g = ctx.getGeneratorAdapter();
        Type keyType = this.value.load(ctx);
        VarLocal value = ctx.newLocal(keyType);
        value.store(ctx);
        Label labelExit = new Label();
        Type resultType = Type.getType(Object.class);
        for (int i = 0; i < this.matchCases.size(); ++i) {
            Label labelNext = new Label();
            if (Utils.isPrimitiveType(keyType) || keyType.equals((Object)Type.getType(Class.class))) {
                this.matchCases.get(i).load(ctx);
                value.load(ctx);
                g.ifCmp(keyType, 154, labelNext);
            } else {
                ctx.invoke(this.matchCases.get(i), "equals", value);
                g.push(true);
                g.ifCmp(Type.BOOLEAN_TYPE, 154, labelNext);
            }
            resultType = this.matchExpressions.get(i).load(ctx);
            g.goTo(labelExit);
            g.mark(labelNext);
        }
        this.defaultExpression.load(ctx);
        g.mark(labelExit);
        return resultType;
    }
}

