/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen.expression;

import io.activej.codegen.Context;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;

final class ExpressionCast
implements Expression {
    static final Type SELF_TYPE = Type.getType(Object.class);
    private final Expression expression;
    private final Type targetType;

    ExpressionCast(@NotNull Expression expression, @NotNull Type type) {
        this.expression = expression;
        this.targetType = type;
    }

    @Override
    public Type load(Context ctx) {
        Type targetType = this.targetType == SELF_TYPE ? ctx.getSelfType() : this.targetType;
        Type sourceType = this.expression.load(ctx);
        if (!targetType.equals((Object)InstructionAdapter.OBJECT_TYPE) || Utils.isPrimitiveType(sourceType)) {
            ctx.cast(sourceType, targetType);
        }
        return targetType;
    }
}

