/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen.expression;

import io.activej.codegen.Context;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.operation.ArithmeticOperation;
import io.activej.codegen.util.Utils;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

final class ExpressionArithmeticOp
implements Expression {
    private final ArithmeticOperation op;
    private final Expression left;
    private final Expression right;

    ExpressionArithmeticOp(ArithmeticOperation op, Expression left, Expression right) {
        this.op = op;
        this.left = left;
        this.right = right;
    }

    static Class<?> unifyArithmeticTypes(Class<?> ... dataTypes) {
        Class<Integer> resultType = null;
        int maxOrder = 0;
        for (Class<?> dataType : dataTypes) {
            int order;
            Class<Integer> t;
            if (dataType == Byte.TYPE || dataType == Short.TYPE || dataType == Character.TYPE || dataType == Integer.TYPE) {
                t = Integer.TYPE;
                order = 1;
            } else {
                t = dataType;
                if (dataType == Long.TYPE) {
                    order = 2;
                } else if (dataType == Float.TYPE) {
                    order = 3;
                } else if (dataType == Double.TYPE) {
                    order = 4;
                } else {
                    throw new IllegalArgumentException("Not an arithmetic type: " + dataType);
                }
            }
            if (resultType != null && order <= maxOrder) continue;
            resultType = t;
            maxOrder = order;
        }
        return resultType;
    }

    @Override
    public Type load(Context ctx) {
        Type rightType;
        GeneratorAdapter g = ctx.getGeneratorAdapter();
        Type leftType = this.left.load(ctx);
        if (Utils.isWrapperType(leftType)) {
            leftType = Utils.unwrap(leftType);
            g.unbox(leftType);
        }
        if (Utils.isWrapperType(rightType = this.right.load(ctx))) {
            rightType = Utils.unwrap(rightType);
            g.unbox(rightType);
        }
        if (this.op != ArithmeticOperation.SHL && this.op != ArithmeticOperation.SHR && this.op != ArithmeticOperation.USHR) {
            Type resultType = Type.getType(ExpressionArithmeticOp.unifyArithmeticTypes(ctx.toJavaType(leftType), ctx.toJavaType(rightType)));
            if (leftType != resultType) {
                int rightLocal = g.newLocal(rightType);
                g.storeLocal(rightLocal);
                g.cast(leftType, resultType);
                g.loadLocal(rightLocal);
            }
            if (rightType != resultType) {
                g.cast(rightType, resultType);
            }
            g.visitInsn(resultType.getOpcode(this.op.opCode));
            return resultType;
        }
        if (rightType != Type.getType(Integer.TYPE)) {
            g.cast(rightType, Type.getType(Integer.TYPE));
        }
        g.visitInsn(leftType.getOpcode(this.op.opCode));
        return leftType;
    }
}

