/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen;

import io.activej.codegen.Context;
import io.activej.codegen.DefiningClassLoader;
import io.activej.codegen.GeneratedBytecode;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.ExpressionConstant;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.util.DefiningClassWriter;
import io.activej.codegen.util.Utils;
import io.activej.codegen.util.WithInitializer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassBuilder<T>
implements WithInitializer<ClassBuilder<T>> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String CLASS_BUILDER_MARKER = "$GENERATED";
    public static final String PACKAGE_PREFIX = Utils.getStringSetting(ClassBuilder.class, "packagePrefix", "io.activej.codegen.");
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private static final ConcurrentHashMap<Integer, Object> STATIC_CONSTANTS = new ConcurrentHashMap();
    final Class<?> superclass;
    final List<Class<?>> interfaces;
    private String className;
    private final String autoClassName;
    final Map<String, Class<?>> fields = new LinkedHashMap();
    final Set<String> fieldsFinal = new HashSet<String>();
    final Set<String> fieldsStatic = new HashSet<String>();
    final Map<String, Expression> fieldExpressions = new HashMap<String, Expression>();
    final Map<Method, Expression> methods = new LinkedHashMap<Method, Expression>();
    final Map<Method, Expression> staticMethods = new LinkedHashMap<Method, Expression>();
    private final Map<Method, Expression> constructors = new LinkedHashMap<Method, Expression>();
    private final List<Expression> staticInitializers = new ArrayList<Expression>();

    private ClassBuilder(Class<?> superclass, List<Class<?>> interfaces, @NotNull String className) {
        this.superclass = superclass;
        this.interfaces = interfaces;
        this.autoClassName = PACKAGE_PREFIX + className;
        this.withStaticField(CLASS_BUILDER_MARKER, Void.class);
    }

    public static <T> ClassBuilder<T> create(Class<?> implementation, List<Class<?>> interfaces) {
        if (!interfaces.stream().allMatch(Class::isInterface)) {
            throw new IllegalArgumentException();
        }
        if (implementation.isInterface()) {
            return new ClassBuilder<T>(Object.class, Stream.concat(Stream.of(implementation), interfaces.stream()).collect(Collectors.toList()), implementation.getName());
        }
        return new ClassBuilder<T>(implementation, interfaces, implementation.getName());
    }

    public static <T> ClassBuilder<T> create(Class<T> implementation, Class<?> ... interfaces) {
        return ClassBuilder.create(implementation, Arrays.asList(interfaces));
    }

    public ClassBuilder<T> withClassName(String name) {
        this.className = name;
        return this;
    }

    public ClassBuilder<T> withStaticInitializer(Expression expression) {
        this.staticInitializers.add(expression);
        return this;
    }

    public ClassBuilder<T> withConstructor(List<? extends Class<?>> argumentTypes, Expression expression) {
        this.constructors.put(new Method("<init>", Type.VOID_TYPE, (Type[])argumentTypes.stream().map(Type::getType).toArray(Type[]::new)), expression);
        return this;
    }

    public ClassBuilder<T> withConstructor(Expression expression) {
        return this.withConstructor(Collections.emptyList(), expression);
    }

    public ClassBuilder<T> withField(String field, Class<?> type) {
        this.fields.put(field, type);
        return this;
    }

    public ClassBuilder<T> withField(String field, Class<?> type, Expression value) {
        this.fields.put(field, type);
        this.fieldExpressions.put(field, value);
        return this;
    }

    public ClassBuilder<T> withFinalField(String field, Class<?> type, Expression value) {
        this.fields.put(field, type);
        this.fieldsFinal.add(field);
        this.fieldExpressions.put(field, value);
        return this;
    }

    public ClassBuilder<T> withMethod(String methodName, Class<?> returnType, List<? extends Class<?>> argumentTypes, Expression expression) {
        this.methods.put(new Method(methodName, Type.getType(returnType), (Type[])argumentTypes.stream().map(Type::getType).toArray(Type[]::new)), expression);
        return this;
    }

    public ClassBuilder<T> withMethod(String methodName, Expression expression) {
        if (methodName.contains("(")) {
            Method method = Method.getMethod((String)methodName);
            this.methods.put(method, expression);
            return this;
        }
        Method foundMethod = null;
        ArrayList<List<java.lang.reflect.Method>> listOfMethods = new ArrayList<List<java.lang.reflect.Method>>();
        listOfMethods.add(Arrays.asList(Object.class.getMethods()));
        listOfMethods.add(Arrays.asList(this.superclass.getMethods()));
        listOfMethods.add(Arrays.asList(this.superclass.getDeclaredMethods()));
        for (Class<?> clazz : this.interfaces) {
            listOfMethods.add(Arrays.asList(clazz.getMethods()));
            listOfMethods.add(Arrays.asList(clazz.getDeclaredMethods()));
        }
        for (List list : listOfMethods) {
            for (java.lang.reflect.Method m : list) {
                if (!m.getName().equals(methodName)) continue;
                Method method = Method.getMethod((java.lang.reflect.Method)m);
                if (foundMethod != null && !method.equals((Object)foundMethod)) {
                    throw new IllegalArgumentException("Method " + method + " collides with " + foundMethod);
                }
                foundMethod = method;
            }
        }
        if (foundMethod == null) {
            throw new IllegalArgumentException(String.format("Could not find method '%s'", methodName));
        }
        this.methods.put(foundMethod, expression);
        return this;
    }

    public ClassBuilder<T> withStaticMethod(String methodName, Class<?> returnClass, List<? extends Class<?>> argumentTypes, Expression expression) {
        this.setStaticMethod(methodName, returnClass, argumentTypes, expression);
        return this;
    }

    public void setStaticMethod(String methodName, Class<?> returnClass, List<? extends Class<?>> argumentTypes, Expression expression) {
        this.staticMethods.put(new Method(methodName, Type.getType(returnClass), (Type[])argumentTypes.stream().map(Type::getType).toArray(Type[]::new)), expression);
    }

    public ClassBuilder<T> withStaticField(String field, Class<?> type) {
        this.fields.put(field, type);
        this.fieldsStatic.add(field);
        return this;
    }

    public ClassBuilder<T> withStaticField(String field, Class<?> type, Expression value) {
        this.fields.put(field, type);
        this.fieldsStatic.add(field);
        this.fieldExpressions.put(field, value);
        return this;
    }

    public ClassBuilder<T> withStaticFinalField(String field, Class<?> type, Expression value) {
        this.fields.put(field, type);
        this.fieldsStatic.add(field);
        this.fieldsFinal.add(field);
        if (value instanceof ExpressionConstant && !((ExpressionConstant)value).isJvmPrimitive()) {
            STATIC_CONSTANTS.put(((ExpressionConstant)value).getId(), ((ExpressionConstant)value).getValue());
        }
        this.fieldExpressions.put(field, value);
        return this;
    }

    @ApiStatus.Internal
    public static Object getStaticConstant(int id) {
        return STATIC_CONSTANTS.get(id);
    }

    @VisibleForTesting
    public static int getStaticConstantsSize() {
        return STATIC_CONSTANTS.size();
    }

    @VisibleForTesting
    public static void clearStaticConstants() {
        STATIC_CONSTANTS.clear();
    }

    public Class<T> defineClass(@NotNull DefiningClassLoader classLoader) {
        GeneratedBytecode generatedBytecode = this.toBytecode(classLoader);
        return generatedBytecode.defineClass(classLoader);
    }

    public T defineClassAndCreateInstance(DefiningClassLoader classLoader, Object ... arguments) {
        Class<T> aClass = this.defineClass(classLoader);
        return DefiningClassLoader.createInstance(aClass, arguments);
    }

    public GeneratedBytecode toBytecode(ClassLoader classLoader) {
        return this.toBytecode(classLoader, this.className != null ? this.className : this.autoClassName + '_' + COUNTER.incrementAndGet());
    }

    public GeneratedBytecode toBytecode(ClassLoader classLoader, String className) {
        byte[] bytecode = this.toBytecode(className, classLoader);
        return new GeneratedBytecode(className, bytecode){

            @Override
            protected void onDefinedClass(Class<?> clazz) {
                try {
                    Field field = clazz.getField(ClassBuilder.CLASS_BUILDER_MARKER);
                    field.get(null);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new AssertionError((Object)e);
                }
                finally {
                    ClassBuilder.this.cleanup();
                }
            }

            @Override
            protected void onError(Exception e) {
                ClassBuilder.this.cleanup();
            }
        };
    }

    private byte[] toBytecode(String className, ClassLoader classLoader) {
        DefiningClassWriter cw = DefiningClassWriter.create(classLoader);
        Type classType = Type.getType((String)('L' + className.replace('.', '/') + ';'));
        cw.visit(50, 49, classType.getInternalName(), null, Type.getInternalName(this.superclass), (String[])this.interfaces.stream().map(Type::getInternalName).toArray(String[]::new));
        LinkedHashMap<Method, Expression> constructors = new LinkedHashMap<Method, Expression>(this.constructors);
        if (constructors.isEmpty()) {
            constructors.put(new Method("<init>", Type.VOID_TYPE, new Type[0]), Expressions.superConstructor(new Expression[0]));
        }
        for (Map.Entry entry : constructors.entrySet()) {
            Method method = (Method)entry.getKey();
            GeneratorAdapter g = new GeneratorAdapter(1, method, null, null, (ClassVisitor)cw);
            Context ctx = new Context(classLoader, this, g, classType, method);
            ctx.cast(((Expression)entry.getValue()).load(ctx), method.getReturnType());
            g.returnValue();
            g.endMethod();
        }
        HashSet<Method> methods = new HashSet<Method>();
        HashSet<Method> staticMethods = new HashSet<Method>();
        HashSet<String> fields = new HashSet<String>();
        while (true) {
            Expression expression;
            Context ctx;
            GeneratorAdapter g;
            LinkedHashSet<String> newFields = new LinkedHashSet<String>(this.fields.keySet());
            newFields.removeAll(fields);
            LinkedHashSet<Method> newMethods = new LinkedHashSet<Method>(this.methods.keySet());
            newMethods.removeAll(methods);
            LinkedHashSet<Method> newStaticMethods = new LinkedHashSet<Method>(this.staticMethods.keySet());
            newStaticMethods.removeAll(staticMethods);
            if (newFields.isEmpty() && newMethods.isEmpty() && newStaticMethods.isEmpty()) break;
            for (String string : newFields) {
                cw.visitField(1 + (this.fieldsStatic.contains(string) ? 8 : 0) + (this.fieldsFinal.contains(string) ? 16 : 0), string, Type.getType(this.fields.get(string)).getDescriptor(), null, null);
            }
            for (Method method : newMethods) {
                g = new GeneratorAdapter(17, method, null, null, (ClassVisitor)cw);
                ctx = new Context(classLoader, this, g, classType, method);
                expression = this.methods.get(method);
                ctx.cast(expression.load(ctx), method.getReturnType());
                g.returnValue();
                g.endMethod();
            }
            for (Method method : newStaticMethods) {
                g = new GeneratorAdapter(25, method, null, null, (ClassVisitor)cw);
                ctx = new Context(classLoader, this, g, classType, method);
                expression = this.staticMethods.get(method);
                ctx.cast(expression.load(ctx), method.getReturnType());
                g.returnValue();
                g.endMethod();
            }
            fields.addAll(newFields);
            methods.addAll(newMethods);
            staticMethods.addAll(newStaticMethods);
        }
        Method m = Method.getMethod((String)"void <clinit> ()");
        GeneratorAdapter g = new GeneratorAdapter(9, m, null, null, (ClassVisitor)cw);
        Context ctx = new Context(classLoader, this, g, classType, m);
        for (Map.Entry entry : this.fieldExpressions.entrySet()) {
            String field = (String)entry.getKey();
            if (!this.fieldsStatic.contains(field)) continue;
            Expression expression = (Expression)entry.getValue();
            if (expression instanceof ExpressionConstant && !((ExpressionConstant)expression).isJvmPrimitive()) {
                Expressions.set(Expressions.staticField(field), Expressions.cast(Expressions.staticCall(ClassBuilder.class, "getStaticConstant", Expressions.value(((ExpressionConstant)expression).getId())), this.fields.get(field))).load(ctx);
                continue;
            }
            Expressions.set(Expressions.staticField(field), expression).load(ctx);
        }
        for (Expression expression : this.staticInitializers) {
            expression.load(ctx);
        }
        g.returnValue();
        g.endMethod();
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void cleanup() {
        for (Expression expression : this.fieldExpressions.values()) {
            if (!(expression instanceof ExpressionConstant)) continue;
            STATIC_CONSTANTS.remove(((ExpressionConstant)expression).getId());
        }
    }
}

