/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.network;

import io.ably.lib.network.WebSocketClient;
import io.ably.lib.network.WebSocketListener;
import java.nio.ByteBuffer;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okio.ByteString;

public class OkHttpWebSocketClient
implements WebSocketClient {
    private final OkHttpClient connection;
    private final Request request;
    private final WebSocketListener listener;
    private WebSocket webSocket;

    public OkHttpWebSocketClient(OkHttpClient connection, Request request, WebSocketListener listener) {
        this.connection = connection;
        this.request = request;
        this.listener = listener;
    }

    public void connect() {
        this.webSocket = this.connection.newWebSocket(this.request, (okhttp3.WebSocketListener)new WebSocketHandler(this.listener));
    }

    public void close() {
        this.webSocket.close(1000, "Close");
    }

    public void close(int code, String reason) {
        this.webSocket.close(code, reason);
    }

    public void cancel(int code, String reason) {
        this.webSocket.cancel();
        this.listener.onClose(code, reason);
    }

    public void send(byte[] bytes) {
        this.webSocket.send(ByteString.of((byte[])bytes));
    }

    public void send(String message) {
        this.webSocket.send(message);
    }

    private static class WebSocketHandler
    extends okhttp3.WebSocketListener {
        private final WebSocketListener listener;

        private WebSocketHandler(WebSocketListener listener) {
            this.listener = listener;
        }

        public void onClosed(WebSocket webSocket, int code, String reason) {
            this.listener.onClose(code, reason);
        }

        public void onFailure(WebSocket webSocket, Throwable t, Response response) {
            this.listener.onError(t);
        }

        public void onMessage(WebSocket webSocket, String text) {
            this.listener.onMessage(text);
        }

        public void onMessage(WebSocket webSocket, ByteString bytes) {
            this.listener.onMessage(ByteBuffer.wrap(bytes.toByteArray()));
        }

        public void onOpen(WebSocket webSocket, Response response) {
            this.listener.onOpen();
        }
    }
}

