/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.objects;

import io.ably.lib.objects.Adapter;
import io.ably.lib.objects.LiveObjectsPlugin;
import io.ably.lib.objects.ObjectsAdapter;
import io.ably.lib.objects.ObjectsSerializer;
import io.ably.lib.realtime.AblyRealtime;
import io.ably.lib.util.Log;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.Nullable;

public class ObjectsHelper {
    private static final String TAG = ObjectsHelper.class.getName();
    private static volatile ObjectsSerializer objectsSerializer;

    @Nullable
    public static LiveObjectsPlugin tryInitializeObjectsPlugin(AblyRealtime ablyRealtime) {
        try {
            Class<?> objectsImplementation = Class.forName("io.ably.lib.objects.DefaultLiveObjectsPlugin");
            Adapter adapter = new Adapter(ablyRealtime);
            return (LiveObjectsPlugin)objectsImplementation.getDeclaredConstructor(ObjectsAdapter.class).newInstance(adapter);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Log.i(TAG, "LiveObjects plugin not found in classpath. LiveObjects functionality will not be available.", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static ObjectsSerializer getSerializer() {
        if (objectsSerializer != null) return objectsSerializer;
        Class<ObjectsHelper> clazz = ObjectsHelper.class;
        synchronized (ObjectsHelper.class) {
            if (objectsSerializer != null) return objectsSerializer;
            try {
                Class<?> serializerClass = Class.forName("io.ably.lib.objects.serialization.DefaultObjectsSerializer");
                objectsSerializer = (ObjectsSerializer)serializerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                Log.w(TAG, "Failed to init ObjectsSerializer, LiveObjects plugin not included in the classpath", e);
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            return objectsSerializer;
        }
    }
}

