/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.transport;

import io.ably.lib.transport.ConnectionManager;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ClientOptions;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Param;
import io.ably.lib.types.ProtocolMessage;
import io.ably.lib.types.RecoveryKeyContext;
import io.ably.lib.util.AgentHeaderCreator;
import io.ably.lib.util.Log;
import io.ably.lib.util.PlatformAgentProvider;
import io.ably.lib.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;

public interface ITransport {
    public static final String TAG = ITransport.class.getName();

    public void connect(ConnectListener var1);

    public void close();

    public void send(ProtocolMessage var1) throws AblyException;

    public void receive(ProtocolMessage var1) throws AblyException;

    public String getURL();

    public String getHost();

    public static interface ConnectListener {
        public void onTransportAvailable(ITransport var1);

        public void onTransportUnavailable(ITransport var1, ErrorInfo var2);
    }

    public static class TransportParams {
        protected ClientOptions options;
        protected String host;
        protected int port;
        protected String connectionKey;
        protected Mode mode;
        protected boolean heartbeats;
        private final PlatformAgentProvider platformAgentProvider;

        public TransportParams(ClientOptions options, PlatformAgentProvider platformAgentProvider) {
            this.options = options;
            this.platformAgentProvider = platformAgentProvider;
            this.heartbeats = true;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public ClientOptions getClientOptions() {
            return this.options;
        }

        public Param[] getConnectParams(Param[] baseParams) {
            ArrayList<Param> paramList = new ArrayList<Param>(Arrays.asList(baseParams));
            paramList.add(new Param("v", "2"));
            paramList.add(new Param("format", this.options.useBinaryProtocol ? "msgpack" : "json"));
            if (!this.options.echoMessages) {
                paramList.add(new Param("echo", "false"));
            }
            if (!StringUtils.isNullOrEmpty(this.connectionKey)) {
                this.mode = Mode.resume;
                paramList.add(new Param("resume", this.connectionKey));
            } else if (!StringUtils.isNullOrEmpty(this.options.recover)) {
                this.mode = Mode.recover;
                RecoveryKeyContext recoveryKeyContext = RecoveryKeyContext.decode(this.options.recover);
                if (recoveryKeyContext != null) {
                    paramList.add(new Param("recover", recoveryKeyContext.getConnectionKey()));
                }
            }
            if (this.options.clientId != null) {
                paramList.add(new Param("clientId", this.options.clientId));
            }
            if (!this.heartbeats) {
                paramList.add(new Param("heartbeats", "false"));
            }
            if (this.options.transportParams != null) {
                paramList.addAll(Arrays.asList(this.options.transportParams));
            }
            paramList.add(new Param("agent", AgentHeaderCreator.create(this.options.agents, this.platformAgentProvider)));
            Log.d(TAG, "getConnectParams: params = " + paramList);
            return paramList.toArray(new Param[paramList.size()]);
        }
    }

    public static enum Mode {
        clean,
        resume,
        recover;

    }

    public static interface Factory {
        public ITransport getTransport(TransportParams var1, ConnectionManager var2);
    }
}

