/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import io.ably.lib.types.AblyException;
import io.ably.lib.types.ChannelMode;
import io.ably.lib.util.Base64Coder;
import io.ably.lib.util.Crypto;
import java.util.Map;

public class ChannelOptions {
    public Map<String, String> params;
    public ChannelMode[] modes;
    public Object cipherParams;
    public boolean encrypted;

    public boolean hasModes() {
        return null != this.modes && 0 != this.modes.length;
    }

    public boolean hasParams() {
        return null != this.params && !this.params.isEmpty();
    }

    public int getModeFlags() {
        int flags = 0;
        for (ChannelMode mode : this.modes) {
            flags |= mode.getMask();
        }
        return flags;
    }

    @Deprecated
    public static ChannelOptions fromCipherKey(byte[] key) throws AblyException {
        return ChannelOptions.withCipherKey(key);
    }

    @Deprecated
    public static ChannelOptions fromCipherKey(String base64Key) throws AblyException {
        return ChannelOptions.fromCipherKey(Base64Coder.decode(base64Key));
    }

    public static ChannelOptions withCipherKey(byte[] key) throws AblyException {
        ChannelOptions options = new ChannelOptions();
        options.encrypted = true;
        options.cipherParams = Crypto.getDefaultParams(key);
        return options;
    }

    public static ChannelOptions withCipherKey(String base64Key) throws AblyException {
        return ChannelOptions.withCipherKey(Base64Coder.decode(base64Key));
    }

    public synchronized Crypto.CipherParams getCipherParamsOrDefault() throws AblyException {
        Crypto.CipherParams params = Crypto.checkCipherParams(this.cipherParams);
        if (this.cipherParams == null) {
            this.cipherParams = params;
        }
        return params;
    }
}

