/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.transport;

import io.ably.lib.transport.Defaults;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ClientOptions;
import io.ably.lib.types.ErrorInfo;
import java.util.Arrays;
import java.util.Collections;

public class Hosts {
    private final String primaryHost;
    private final boolean primaryHostIsDefault;
    private final String defaultHost;
    private final String[] fallbackHosts;
    private final boolean fallbackHostsIsDefault;
    private final boolean fallbackHostsUseDefault;
    private final long fallbackRetryTimeout;
    private final Preferred preferred = new Preferred();

    public Hosts(String primaryHost, String defaultHost, ClientOptions options) throws AblyException {
        boolean isProduction;
        this.defaultHost = defaultHost;
        this.fallbackHostsUseDefault = options.fallbackHostsUseDefault;
        boolean hasCustomPrimaryHost = primaryHost != null && !primaryHost.equalsIgnoreCase(defaultHost);
        Object[] tempFallbackHosts = options.fallbackHosts;
        if (options.fallbackHostsUseDefault) {
            if (options.fallbackHosts != null) {
                throw AblyException.fromErrorInfo(new ErrorInfo("fallbackHosts and fallbackHostsUseDefault cannot both be set", 40000, 400));
            }
            if (options.port != 0 || options.tlsPort != 0) {
                throw AblyException.fromErrorInfo(new ErrorInfo("fallbackHostsUseDefault cannot be set when port or tlsPort are set", 40000, 400));
            }
            tempFallbackHosts = Defaults.HOST_FALLBACKS;
        }
        boolean bl = isProduction = options.environment == null || options.environment.isEmpty() || "production".equalsIgnoreCase(options.environment);
        if (!hasCustomPrimaryHost && tempFallbackHosts == null && options.port == 0 && options.tlsPort == 0) {
            Object[] objectArray = tempFallbackHosts = isProduction ? Defaults.HOST_FALLBACKS : Defaults.getEnvironmentFallbackHosts(options.environment);
        }
        if (hasCustomPrimaryHost) {
            this.primaryHost = primaryHost;
            if (options.environment != null) {
                throw AblyException.fromErrorInfo(new ErrorInfo("cannot set both restHost/realtimeHost and environment options", 40000, 400));
            }
        } else {
            this.primaryHost = isProduction ? defaultHost : options.environment + "-" + defaultHost;
        }
        this.primaryHostIsDefault = this.primaryHost.equalsIgnoreCase(defaultHost);
        this.fallbackHostsIsDefault = Arrays.equals(Defaults.HOST_FALLBACKS, tempFallbackHosts);
        this.fallbackHosts = tempFallbackHosts == null ? new String[]{} : (String[])tempFallbackHosts.clone();
        Collections.shuffle(Arrays.asList(this.fallbackHosts));
        this.fallbackRetryTimeout = options.fallbackRetryTimeout;
    }

    public synchronized void setPreferredHost(String prefHost, boolean temporary) {
        if (this.preferred.isHost(prefHost)) {
            return;
        }
        if (prefHost.equals(this.primaryHost)) {
            this.preferred.clear();
        } else {
            this.preferred.setHost(prefHost, temporary ? System.currentTimeMillis() + this.fallbackRetryTimeout : 0L);
        }
    }

    public String getPrimaryHost() {
        return this.primaryHost;
    }

    public synchronized String getPreferredHost() {
        String host = this.preferred.getHostOrClearIfExpired();
        return host == null ? this.primaryHost : host;
    }

    public synchronized String getFallback(String lastHost) {
        int idx;
        if (this.fallbackHosts == null) {
            return null;
        }
        if (lastHost.equals(this.primaryHost)) {
            if (!this.primaryHostIsDefault && !this.fallbackHostsUseDefault && this.fallbackHostsIsDefault) {
                return null;
            }
            idx = 0;
        } else {
            if (lastHost.equals(this.preferred.getHostOrClearIfExpired())) {
                this.preferred.clear();
                return this.primaryHost;
            }
            idx = Arrays.asList(this.fallbackHosts).indexOf(lastHost);
            if (idx < 0) {
                return null;
            }
            ++idx;
        }
        if (idx >= this.fallbackHosts.length) {
            return null;
        }
        return this.fallbackHosts[idx];
    }

    public synchronized int fallbackHostsRemaining(String candidateHost) {
        if (this.fallbackHosts == null) {
            return 0;
        }
        if (candidateHost.equals(this.primaryHost) || candidateHost.equals(this.preferred.getHost())) {
            return this.fallbackHosts.length;
        }
        return this.fallbackHosts.length - Arrays.asList(this.fallbackHosts).indexOf(candidateHost) - 1;
    }

    private static class Preferred {
        private String host;
        private long expiry;

        private Preferred() {
        }

        public void clear() {
            this.host = null;
            this.expiry = 0L;
        }

        public boolean isHost(String host) {
            return this.host == null ? host == null : this.host.equals(host);
        }

        public void setHost(String host, long expiry) {
            this.host = host;
            this.expiry = expiry;
        }

        public String getHostOrClearIfExpired() {
            if (this.expiry > 0L && this.expiry <= System.currentTimeMillis()) {
                this.clear();
            }
            return this.host;
        }

        public String getHost() {
            return this.host;
        }
    }
}

