/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public final class DeltaExtras {
    private static final String TAG = DeltaExtras.class.getName();
    public static final String FORMAT_VCDIFF = "vcdiff";
    private static final String FROM = "from";
    private static final String FORMAT = "format";
    private final String format;
    private final String from;

    private DeltaExtras(String format, String from) {
        if (null == format) {
            throw new IllegalArgumentException("format cannot be null.");
        }
        if (null == from) {
            throw new IllegalArgumentException("from cannot be null.");
        }
        this.format = format;
        this.from = from;
    }

    public String getFormat() {
        return this.format;
    }

    public String getFrom() {
        return this.from;
    }

    void write(MessagePacker packer) throws IOException {
        packer.packMapHeader(2);
        packer.packString(FORMAT);
        packer.packString(this.format);
        packer.packString(FROM);
        packer.packString(this.from);
    }

    static DeltaExtras read(Map<Value, Value> map) throws IOException {
        Value format = map.get(ValueFactory.newString((String)FORMAT));
        Value from = map.get(ValueFactory.newString((String)FROM));
        return new DeltaExtras(format.asStringValue().asString(), from.asStringValue().asString());
    }

    static DeltaExtras read(JsonObject map) {
        return new DeltaExtras(map.get(FORMAT).getAsString(), map.get(FROM).getAsString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeltaExtras that = (DeltaExtras)o;
        return this.format.equals(that.format) && this.from.equals(that.from);
    }

    public int hashCode() {
        return Objects.hash(this.format, this.from);
    }
}

