/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.rest;

import io.ably.lib.http.BasePaginatedQuery;
import io.ably.lib.http.Http;
import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpScheduler;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.realtime.CompletionListener;
import io.ably.lib.rest.AblyBase;
import io.ably.lib.rest.MessageEditsMixin;
import io.ably.lib.rest.RestAnnotations;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.AsyncPaginatedResult;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.Message;
import io.ably.lib.types.MessageOperation;
import io.ably.lib.types.MessageSerializer;
import io.ably.lib.types.PaginatedResult;
import io.ably.lib.types.Param;
import io.ably.lib.types.PresenceMessage;
import io.ably.lib.types.PresenceSerializer;
import io.ably.lib.types.PublishResult;
import io.ably.lib.types.UpdateDeleteResult;
import io.ably.lib.util.Crypto;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.NonBlocking;

public class ChannelBase {
    public final String name;
    public final Presence presence;
    public final RestAnnotations annotations;
    private final MessageEditsMixin messageEditsMixin;
    private final AblyBase ably;
    private final String basePath;
    ChannelOptions options;

    @Blocking
    public void publish(String name, Object data) throws AblyException {
        this.publish(this.ably.http, name, data);
    }

    @Blocking
    void publish(Http http, String name, Object data) throws AblyException {
        this.publishImpl(http, name, data).sync();
    }

    @Blocking
    public PublishResult publishWithResult(String name, Object data) throws AblyException {
        return this.publishWithResult(this.ably.http, name, data);
    }

    @Blocking
    PublishResult publishWithResult(Http http, String name, Object data) throws AblyException {
        return this.publishImpl(http, name, data).sync();
    }

    @Deprecated
    public void publishAsync(String name, Object data, CompletionListener listener) {
        this.publishAsync(this.ably.http, name, data, listener);
    }

    @NonBlocking
    void publishAsync(Http http, String name, Object data, CompletionListener listener) {
        this.publishImpl(http, name, data).async(new CompletionListener.ToCallback(listener));
    }

    @NonBlocking
    public void publishAsync(String name, Object data, Callback<PublishResult> callback) {
        this.publishAsync(this.ably.http, name, data, callback);
    }

    @NonBlocking
    void publishAsync(Http http, String name, Object data, Callback<PublishResult> callback) {
        this.publishImpl(http, name, data).async(callback);
    }

    private Http.Request<PublishResult> publishImpl(Http http, String name, Object data) {
        return this.publishImpl(http, new Message[]{new Message(name, data)});
    }

    @Blocking
    public void publish(Message[] messages) throws AblyException {
        this.publish(this.ably.http, messages);
    }

    @Blocking
    void publish(Http http, Message[] messages) throws AblyException {
        this.publishImpl(http, messages).sync();
    }

    @Blocking
    public PublishResult publishWithResult(Message[] messages) throws AblyException {
        return this.publishImpl(this.ably.http, messages).sync();
    }

    @Deprecated
    @NonBlocking
    public void publishAsync(Message[] messages, CompletionListener listener) {
        this.publishAsync(this.ably.http, messages, listener);
    }

    @Deprecated
    void publishAsync(Http http, Message[] messages, CompletionListener listener) {
        this.publishImpl(http, messages).async(new CompletionListener.ToCallback(listener));
    }

    @NonBlocking
    public void publishAsync(Message[] messages, Callback<PublishResult> callback) {
        this.publishImpl(this.ably.http, messages).async(callback);
    }

    private Http.Request<PublishResult> publishImpl(Http http, final Message[] messages) {
        return http.request(new Http.Execute<PublishResult>(){

            @Override
            public void execute(HttpScheduler http, Callback<PublishResult> callback) throws AblyException {
                boolean hasClientSuppliedId = false;
                for (Message message : messages) {
                    hasClientSuppliedId |= message.id != null;
                    ((ChannelBase)ChannelBase.this).ably.auth.checkClientId(message, true, false);
                    message.encode(ChannelBase.this.options);
                }
                if (!hasClientSuppliedId && ((ChannelBase)ChannelBase.this).ably.options.idempotentRestPublishing) {
                    String messageId = Crypto.getRandomId();
                    for (int i = 0; i < messages.length; ++i) {
                        messages[i].id = messageId + ':' + i;
                    }
                }
                HttpCore.RequestBody requestBody = ((ChannelBase)ChannelBase.this).ably.options.useBinaryProtocol ? MessageSerializer.asMsgpackRequest(messages) : MessageSerializer.asJsonRequest(messages);
                Param[] params = ((ChannelBase)ChannelBase.this).ably.options.addRequestIds ? Param.array(Crypto.generateRandomRequestId()) : null;
                HttpCore.BodyHandler<String> bodyHandler = PublishResult.getBodyHandler();
                HttpCore.ResponseHandler<PublishResult> responseHandler = (response, error) -> {
                    if (error != null) {
                        throw AblyException.fromErrorInfo(error);
                    }
                    String[] serials = (String[])bodyHandler.handleResponseBody(response.contentType, response.body);
                    return new PublishResult(serials);
                };
                http.post(ChannelBase.this.basePath + "/messages", HttpUtils.defaultAcceptHeaders(((ChannelBase)ChannelBase.this).ably.options.useBinaryProtocol), params, requestBody, responseHandler, true, callback);
            }
        });
    }

    public PaginatedResult<Message> history(Param[] params) throws AblyException {
        return this.history(this.ably.http, params);
    }

    PaginatedResult<Message> history(Http http, Param[] params) throws AblyException {
        return this.historyImpl(http, params).sync();
    }

    public void historyAsync(Param[] params, Callback<AsyncPaginatedResult<Message>> callback) {
        this.historyAsync(this.ably.http, params, callback);
    }

    void historyAsync(Http http, Param[] params, Callback<AsyncPaginatedResult<Message>> callback) {
        this.historyImpl(http, params).async(callback);
    }

    private BasePaginatedQuery.ResultRequest<Message> historyImpl(Http http, Param[] initialParams) {
        HttpCore.BodyHandler<Message> bodyHandler = MessageSerializer.getMessageResponseHandler(this.options);
        Param[] params = this.ably.options.addRequestIds ? Param.set(initialParams, Crypto.generateRandomRequestId()) : initialParams;
        return new BasePaginatedQuery<Message>(http, this.basePath + "/messages", HttpUtils.defaultAcceptHeaders(this.ably.options.useBinaryProtocol), params, bodyHandler).get();
    }

    @Blocking
    public Message getMessage(String serial) throws AblyException {
        return this.messageEditsMixin.getMessage(this.ably.http, serial);
    }

    @NonBlocking
    public void getMessageAsync(String serial, Callback<Message> callback) {
        this.messageEditsMixin.getMessageAsync(this.ably.http, serial, callback);
    }

    @Blocking
    public UpdateDeleteResult updateMessage(Message message, MessageOperation operation) throws AblyException {
        return this.messageEditsMixin.updateMessage(this.ably.http, message, operation);
    }

    @Blocking
    public UpdateDeleteResult updateMessage(Message message) throws AblyException {
        return this.updateMessage(message, null);
    }

    @NonBlocking
    public void updateMessageAsync(Message message, MessageOperation operation, Callback<UpdateDeleteResult> callback) {
        this.messageEditsMixin.updateMessageAsync(this.ably.http, message, operation, callback);
    }

    @NonBlocking
    public void updateMessageAsync(Message message, Callback<UpdateDeleteResult> callback) {
        this.updateMessageAsync(message, null, callback);
    }

    @Blocking
    public UpdateDeleteResult deleteMessage(Message message, MessageOperation operation) throws AblyException {
        return this.messageEditsMixin.deleteMessage(this.ably.http, message, operation);
    }

    @Blocking
    public UpdateDeleteResult deleteMessage(Message message) throws AblyException {
        return this.deleteMessage(message, null);
    }

    @NonBlocking
    public void deleteMessageAsync(Message message, MessageOperation operation, Callback<UpdateDeleteResult> callback) {
        this.messageEditsMixin.deleteMessageAsync(this.ably.http, message, operation, callback);
    }

    @NonBlocking
    public void deleteMessageAsync(Message message, Callback<UpdateDeleteResult> callback) {
        this.deleteMessageAsync(message, null, callback);
    }

    @Blocking
    public UpdateDeleteResult appendMessage(Message message, MessageOperation operation) throws AblyException {
        return this.messageEditsMixin.appendMessage(this.ably.http, message, operation);
    }

    @Blocking
    public UpdateDeleteResult appendMessage(Message message) throws AblyException {
        return this.appendMessage(message, null);
    }

    @NonBlocking
    public void appendMessageAsync(Message message, MessageOperation operation, Callback<UpdateDeleteResult> callback) {
        this.messageEditsMixin.appendMessageAsync(this.ably.http, message, operation, callback);
    }

    @NonBlocking
    public void appendMessageAsync(Message message, Callback<UpdateDeleteResult> callback) {
        this.appendMessageAsync(message, null, callback);
    }

    @Blocking
    public PaginatedResult<Message> getMessageVersions(String serial, Param[] params) throws AblyException {
        return this.messageEditsMixin.getMessageVersions(this.ably.http, serial, params);
    }

    @NonBlocking
    public void getMessageVersionsAsync(String serial, Param[] params, Callback<AsyncPaginatedResult<Message>> callback) throws AblyException {
        this.messageEditsMixin.getMessageVersionsAsync(this.ably.http, serial, params, callback);
    }

    ChannelBase(AblyBase ably, String name, ChannelOptions options) throws AblyException {
        this.ably = ably;
        this.name = name;
        this.options = options;
        this.basePath = "/channels/" + HttpUtils.encodeURIComponent(name);
        this.presence = new Presence();
        this.annotations = new RestAnnotations(name, ably.http, ably.options, options);
        this.messageEditsMixin = new MessageEditsMixin(this.basePath, ably.options, options, ably.auth);
    }

    public class Presence {
        public PaginatedResult<PresenceMessage> get(Param[] params) throws AblyException {
            return this.get(((ChannelBase)ChannelBase.this).ably.http, params);
        }

        PaginatedResult<PresenceMessage> get(Http http, Param[] params) throws AblyException {
            return this.getImpl(http, params).sync();
        }

        public void getAsync(Param[] params, Callback<AsyncPaginatedResult<PresenceMessage>> callback) {
            this.getAsync(((ChannelBase)ChannelBase.this).ably.http, params, callback);
        }

        void getAsync(Http http, Param[] params, Callback<AsyncPaginatedResult<PresenceMessage>> callback) {
            this.getImpl(http, params).async(callback);
        }

        private BasePaginatedQuery.ResultRequest<PresenceMessage> getImpl(Http http, Param[] initialParams) {
            HttpCore.BodyHandler<PresenceMessage> bodyHandler = PresenceSerializer.getPresenceResponseHandler(ChannelBase.this.options);
            Param[] params = ((ChannelBase)ChannelBase.this).ably.options.addRequestIds ? Param.set(initialParams, Crypto.generateRandomRequestId()) : initialParams;
            return new BasePaginatedQuery<PresenceMessage>(http, ChannelBase.this.basePath + "/presence", HttpUtils.defaultAcceptHeaders(((ChannelBase)ChannelBase.this).ably.options.useBinaryProtocol), params, bodyHandler).get();
        }

        public PaginatedResult<PresenceMessage> history(Param[] params) throws AblyException {
            return this.history(((ChannelBase)ChannelBase.this).ably.http, params);
        }

        PaginatedResult<PresenceMessage> history(Http http, Param[] params) throws AblyException {
            return this.historyImpl(http, params).sync();
        }

        public void historyAsync(Param[] params, Callback<AsyncPaginatedResult<PresenceMessage>> callback) {
            this.historyAsync(((ChannelBase)ChannelBase.this).ably.http, params, callback);
        }

        void historyAsync(Http http, Param[] params, Callback<AsyncPaginatedResult<PresenceMessage>> callback) {
            this.historyImpl(http, params).async(callback);
        }

        private BasePaginatedQuery.ResultRequest<PresenceMessage> historyImpl(Http http, Param[] initialParams) {
            HttpCore.BodyHandler<PresenceMessage> bodyHandler = PresenceSerializer.getPresenceResponseHandler(ChannelBase.this.options);
            Param[] params = ((ChannelBase)ChannelBase.this).ably.options.addRequestIds ? Param.set(initialParams, Crypto.generateRandomRequestId()) : initialParams;
            return new BasePaginatedQuery<PresenceMessage>(http, ChannelBase.this.basePath + "/presence/history", HttpUtils.defaultAcceptHeaders(((ChannelBase)ChannelBase.this).ably.options.useBinaryProtocol), params, bodyHandler).get();
        }
    }
}

