/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.platform;

import android.content.Context;
import io.ably.lib.platform.AndroidNetworkConnectivity;
import io.ably.lib.transport.NetworkConnectivity;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.util.Log;

public class Platform {
    public static final String name = "android";
    private Context applicationContext;
    private final NetworkConnectivity.DelegatedNetworkConnectivity networkConnectivity = new NetworkConnectivity.DelegatedNetworkConnectivity();
    private static final String TAG = Platform.class.getName();

    public Context getApplicationContext() {
        return this.applicationContext;
    }

    public void setAndroidContext(Context context) throws AblyException {
        Log.v(TAG, "setAndroidContext: context=" + context);
        context = context.getApplicationContext();
        if (this.applicationContext != null) {
            Log.v(TAG, "setAndroidContext(): applicationContext has already been set");
            if (context == this.applicationContext) {
                Log.v(TAG, "setAndroidContext(): existing applicationContext is compatible with that being set");
                return;
            }
            throw AblyException.fromErrorInfo(new ErrorInfo("Incompatible application context set", 40000, 400));
        }
        Log.v(TAG, "setAndroidContext(): there was no existing applicationContext");
        this.applicationContext = context;
        AndroidNetworkConnectivity.getNetworkConnectivity(context).addListener(this.networkConnectivity);
    }

    public boolean hasApplicationContext() {
        return this.applicationContext != null;
    }

    public NetworkConnectivity getNetworkConnectivity() {
        return this.networkConnectivity;
    }
}

