/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.transport;

import io.ably.lib.types.ErrorInfo;
import java.util.HashSet;
import java.util.Set;

public abstract class NetworkConnectivity {
    protected Set<NetworkConnectivityListener> listeners = new HashSet<NetworkConnectivityListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(NetworkConnectivityListener listener) {
        boolean wasEmpty;
        NetworkConnectivity networkConnectivity = this;
        synchronized (networkConnectivity) {
            wasEmpty = this.listeners.isEmpty();
            this.listeners.add(listener);
        }
        if (wasEmpty) {
            this.onNonempty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(NetworkConnectivityListener listener) {
        boolean isEmpty;
        NetworkConnectivity networkConnectivity = this;
        synchronized (networkConnectivity) {
            this.listeners.remove(listener);
            isEmpty = this.listeners.isEmpty();
        }
        if (isEmpty) {
            this.onEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyNetworkAvailable() {
        NetworkConnectivityListener[] networkConnectivityListenerArray = this;
        synchronized (this) {
            NetworkConnectivityListener[] allListeners = this.listeners.toArray(new NetworkConnectivityListener[this.listeners.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (NetworkConnectivityListener listener : allListeners) {
                listener.onNetworkAvailable();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyNetworkUnavailable(ErrorInfo reason) {
        NetworkConnectivityListener[] networkConnectivityListenerArray = this;
        synchronized (this) {
            NetworkConnectivityListener[] allListeners = this.listeners.toArray(new NetworkConnectivityListener[this.listeners.size()]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (NetworkConnectivityListener listener : allListeners) {
                listener.onNetworkUnavailable(reason);
            }
            return;
        }
    }

    protected synchronized boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    protected void onEmpty() {
    }

    protected void onNonempty() {
    }

    public static interface NetworkConnectivityListener {
        public void onNetworkAvailable();

        public void onNetworkUnavailable(ErrorInfo var1);
    }

    public static class DelegatedNetworkConnectivity
    extends NetworkConnectivity
    implements NetworkConnectivityListener {
        @Override
        public void onNetworkAvailable() {
            this.notifyNetworkAvailable();
        }

        @Override
        public void onNetworkUnavailable(ErrorInfo reason) {
            this.notifyNetworkUnavailable(reason);
        }
    }

    public static class DefaultNetworkConnectivity
    extends NetworkConnectivity {
    }
}

