/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.transport;

import io.ably.lib.transport.ITransport;
import io.ably.lib.transport.WebSocketTransport;
import io.ably.lib.types.ClientOptions;

public class Defaults {
    public static final String ABLY_PROTOCOL_VERSION = "2";
    public static final String ABLY_AGENT_VERSION = String.format("%s/%s", "ably-java", "1.2.54");
    public static final String ABLY_PROTOCOL_VERSION_PARAM = "v";
    public static final String ABLY_AGENT_PARAM = "agent";
    public static final String ABLY_PROTOCOL_VERSION_HEADER = "X-Ably-Version";
    public static final String ABLY_CLIENT_ID_HEADER = "X-Ably-ClientId";
    public static final String ABLY_AGENT_HEADER = "Ably-Agent";
    public static final String[] HOST_FALLBACKS = new String[]{"A.ably-realtime.com", "B.ably-realtime.com", "C.ably-realtime.com", "D.ably-realtime.com", "E.ably-realtime.com"};
    public static final String HOST_REST = "rest.ably.io";
    public static final String HOST_REALTIME = "realtime.ably.io";
    public static final int PORT = 80;
    public static final int TLS_PORT = 443;
    public static int TIMEOUT_CONNECT = 15000;
    public static int TIMEOUT_DISCONNECT = 15000;
    public static int TIMEOUT_CHANNEL_RETRY = 15000;
    public static int TIMEOUT_HTTP_OPEN = 4000;
    public static int TIMEOUT_HTTP_REQUEST = 10000;
    public static int httpMaxRetryDuration = 15000;
    public static long realtimeRequestTimeout = 10000L;
    public static long suspendedRetryTimeout = 30000L;
    public static long fallbackRetryTimeout = 600000L;
    public static long maxIdleInterval = 20000L;
    public static int maxMessageSize = 65536;
    public static long connectionStateTtl = 120000L;
    public static final ITransport.Factory TRANSPORT = new WebSocketTransport.Factory();
    public static final int HTTP_MAX_RETRY_COUNT = 3;
    public static final int HTTP_ASYNC_THREADPOOL_SIZE = 64;

    public static int getPort(ClientOptions options) {
        return options.tls ? (options.tlsPort != 0 ? options.tlsPort : 443) : (options.port != 0 ? options.port : 80);
    }

    public static String[] getEnvironmentFallbackHosts(String environment) {
        return new String[]{environment + "-a-fallback.ably-realtime.com", environment + "-b-fallback.ably-realtime.com", environment + "-c-fallback.ably-realtime.com", environment + "-d-fallback.ably-realtime.com", environment + "-e-fallback.ably-realtime.com"};
    }
}

