/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.realtime;

import io.ably.lib.realtime.ConnectionEvent;
import io.ably.lib.realtime.ConnectionState;
import io.ably.lib.types.ErrorInfo;

public interface ConnectionStateListener {
    public void onConnectionStateChanged(ConnectionStateChange var1);

    public static class Filter
    implements ConnectionStateListener {
        ConnectionState state;
        ConnectionStateListener listener;

        @Override
        public void onConnectionStateChanged(ConnectionStateChange change) {
            if (change.current == this.state) {
                this.listener.onConnectionStateChanged(change);
            }
        }

        Filter(ConnectionState state, ConnectionStateListener listener) {
            this.state = state;
            this.listener = listener;
        }
    }

    public static class Multicaster
    extends io.ably.lib.util.Multicaster<ConnectionStateListener>
    implements ConnectionStateListener {
        public Multicaster() {
            super(new ConnectionStateListener[0]);
        }

        @Override
        public void onConnectionStateChanged(ConnectionStateChange state) {
            for (ConnectionStateListener member : this.getMembers()) {
                try {
                    member.onConnectionStateChanged(state);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static class ConnectionStateChange {
        public final ConnectionEvent event;
        public final ConnectionState previous;
        public final ConnectionState current;
        public final long retryIn;
        public final ErrorInfo reason;

        public ConnectionStateChange(ConnectionState previous, ConnectionState current, long retryIn, ErrorInfo reason) {
            this.event = current.getConnectionEvent();
            this.previous = previous;
            this.current = current;
            this.retryIn = retryIn;
            this.reason = reason;
        }

        private ConnectionStateChange(ErrorInfo reason) {
            this.event = ConnectionEvent.update;
            this.current = this.previous = ConnectionState.connected;
            this.retryIn = 0L;
            this.reason = reason;
        }

        public static ConnectionStateChange createUpdateEvent(ErrorInfo reason) {
            return new ConnectionStateChange(reason);
        }
    }
}

