/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import io.ably.lib.util.Log;
import io.ably.lib.util.Serialisation;
import java.io.IOException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessageUnpacker;

public class ErrorInfo {
    public int code;
    public int statusCode;
    public String message;
    public String href;
    private static final String HREF_BASE = "https://help.ably.io/error/";
    private static final String TAG = ErrorInfo.class.getName();

    public ErrorInfo() {
    }

    public ErrorInfo(String message, int code) {
        this.code = code;
        this.message = message;
    }

    public ErrorInfo(String message, int statusCode, int code) {
        this(message, code);
        this.statusCode = statusCode;
        if (code > 0) {
            this.href = ErrorInfo.href(code);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder("{ErrorInfo");
        result.append(" message=").append(this.logMessage());
        if (this.code > 0) {
            result.append(" code=").append(this.code);
        }
        if (this.statusCode > 0) {
            result.append(" statusCode=").append(this.statusCode);
        }
        if (this.href != null) {
            result.append(" href=").append(this.href);
        }
        result.append('}');
        return result.toString();
    }

    ErrorInfo readMsgpack(MessageUnpacker unpacker) throws IOException {
        int fieldCount = unpacker.unpackMapHeader();
        block12: for (int i = 0; i < fieldCount; ++i) {
            String fieldName = unpacker.unpackString().intern();
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat.equals((Object)MessageFormat.NIL)) {
                unpacker.unpackNil();
                continue;
            }
            switch (fieldName) {
                case "message": {
                    this.message = unpacker.unpackString();
                    continue block12;
                }
                case "code": {
                    this.code = unpacker.unpackInt();
                    continue block12;
                }
                case "statusCode": {
                    this.statusCode = unpacker.unpackInt();
                    continue block12;
                }
                case "href": {
                    this.href = unpacker.unpackString();
                    continue block12;
                }
                default: {
                    Log.v(TAG, "Unexpected field: " + fieldName);
                    unpacker.skipValue();
                }
            }
        }
        return this;
    }

    public static ErrorInfo fromMsgpackBody(byte[] msgpack) throws IOException {
        MessageUnpacker unpacker = Serialisation.msgpackUnpackerConfig.newUnpacker(msgpack);
        return ErrorInfo.fromMsgpackBody(unpacker);
    }

    private static ErrorInfo fromMsgpackBody(MessageUnpacker unpacker) throws IOException {
        int fieldCount = unpacker.unpackMapHeader();
        ErrorInfo error = null;
        block6: for (int i = 0; i < fieldCount; ++i) {
            String fieldName = unpacker.unpackString().intern();
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat.equals((Object)MessageFormat.NIL)) {
                unpacker.unpackNil();
                continue;
            }
            switch (fieldName) {
                case "error": {
                    error = ErrorInfo.fromMsgpack(unpacker);
                    continue block6;
                }
                default: {
                    Log.v(TAG, "Unexpected field: " + fieldName);
                    unpacker.skipValue();
                }
            }
        }
        return error;
    }

    static ErrorInfo fromMsgpack(MessageUnpacker unpacker) throws IOException {
        return new ErrorInfo().readMsgpack(unpacker);
    }

    public static ErrorInfo fromThrowable(Throwable throwable) {
        ErrorInfo errorInfo = throwable instanceof UnknownHostException || throwable instanceof NoRouteToHostException ? new ErrorInfo(throwable.getLocalizedMessage(), 500, 50002) : (throwable instanceof IOException ? new ErrorInfo(throwable.getLocalizedMessage(), 500, 50000) : new ErrorInfo("Unexpected exception: " + throwable.getLocalizedMessage(), 50000, 500));
        return errorInfo;
    }

    public static ErrorInfo fromResponseStatus(String statusLine, int statusCode) {
        return new ErrorInfo(statusLine, statusCode, statusCode * 100);
    }

    private String logMessage() {
        String logMessage;
        String errHref = null;
        String string = logMessage = this.message == null ? "" : this.message;
        if (this.href != null) {
            errHref = this.href;
        } else if (this.code > 0) {
            errHref = ErrorInfo.href(this.code);
        }
        if (errHref != null && !logMessage.contains(errHref)) {
            logMessage = logMessage + " (See " + errHref + ")";
        }
        return logMessage;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ErrorInfo)) {
            return false;
        }
        ErrorInfo other = (ErrorInfo)o;
        return this.code == other.code && this.statusCode == other.statusCode && (this.message == other.message || this.message != null && this.message.equals(other.message));
    }

    private static String href(int code) {
        return HREF_BASE + code;
    }
}

