/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.realtime;

import io.ably.lib.http.BasePaginatedQuery;
import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.realtime.AblyRealtime;
import io.ably.lib.realtime.Channel;
import io.ably.lib.realtime.ChannelEvent;
import io.ably.lib.realtime.ChannelState;
import io.ably.lib.realtime.ChannelStateListener;
import io.ably.lib.realtime.CompletionListener;
import io.ably.lib.realtime.ConnectionState;
import io.ably.lib.realtime.Presence;
import io.ably.lib.transport.ConnectionManager;
import io.ably.lib.transport.Defaults;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.AsyncPaginatedResult;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ChannelMode;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.ChannelProperties;
import io.ably.lib.types.DecodingContext;
import io.ably.lib.types.DeltaExtras;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Message;
import io.ably.lib.types.MessageAction;
import io.ably.lib.types.MessageDecodeException;
import io.ably.lib.types.MessageSerializer;
import io.ably.lib.types.PaginatedResult;
import io.ably.lib.types.Param;
import io.ably.lib.types.PresenceMessage;
import io.ably.lib.types.ProtocolMessage;
import io.ably.lib.util.CollectionUtils;
import io.ably.lib.util.EventEmitter;
import io.ably.lib.util.Log;
import io.ably.lib.util.Multicaster;
import io.ably.lib.util.ReconnectionStrategy;
import io.ably.lib.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public abstract class ChannelBase
extends EventEmitter<ChannelEvent, ChannelStateListener> {
    public final String name;
    public final Presence presence;
    public ChannelState state;
    public ErrorInfo reason;
    public ChannelProperties properties = new ChannelProperties();
    private int retryAttempt = 0;
    private boolean released = false;
    private AttachRequest pendingAttachRequest;
    private DetachRequest pendingDetachRequest;
    private boolean attachResume;
    private Timer attachTimer;
    private Timer reattachTimer;
    static ErrorInfo REASON_NOT_ATTACHED = new ErrorInfo("Channel not attached", 400, 90001);
    private MessageMulticaster listeners = new MessageMulticaster();
    private HashMap<String, MessageMulticaster> eventListeners = new HashMap();
    private static final String KEY_UNTIL_ATTACH = "untilAttach";
    private static final String KEY_FROM_SERIAL = "fromSerial";
    private static final String TAG = Channel.class.getName();
    final AblyRealtime ably;
    final String basePath;
    ChannelOptions options;
    private Map<String, String> params;
    private Set<ChannelMode> modes;
    private String lastPayloadMessageId;
    private String lastPayloadProtocolMessageChannelSerial;
    private boolean decodeFailureRecoveryInProgress;
    private final DecodingContext decodingContext;

    private void setState(ChannelState newState, ErrorInfo reason) {
        this.setState(newState, reason, false, true);
    }

    private void setState(ChannelState newState, ErrorInfo reason, boolean resumed) {
        this.setState(newState, reason, resumed, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(ChannelState newState, ErrorInfo reason, boolean resumed, boolean notifyStateChange) {
        ChannelStateListener.ChannelStateChange stateChange;
        Log.v(TAG, "setState(): channel = " + this.name + "; setting " + (Object)((Object)newState));
        ChannelBase channelBase = this;
        synchronized (channelBase) {
            stateChange = new ChannelStateListener.ChannelStateChange(newState, this.state, reason, resumed);
            this.state = stateChange.current;
            this.reason = stateChange.reason;
        }
        if (newState != ChannelState.attaching && newState != ChannelState.suspended) {
            this.retryAttempt = 0;
        }
        if (newState == ChannelState.detached || newState == ChannelState.suspended || newState == ChannelState.failed) {
            this.properties.channelSerial = null;
        }
        if (notifyStateChange) {
            this.emit(newState, stateChange);
        }
        if (newState == ChannelState.detached && this.pendingAttachRequest != null) {
            Log.v(TAG, "Pending attach request after detach- now reattaching channel:" + this.name);
            this.attach(this.pendingAttachRequest.forceReattach, this.pendingAttachRequest.completionListener);
            this.pendingAttachRequest = null;
        } else if (newState == ChannelState.attached && this.pendingDetachRequest != null) {
            Log.v(TAG, "Pending detach request after attach. Now detaching channel:" + this.name);
            try {
                this.detach(this.pendingDetachRequest.completionListener);
                this.pendingDetachRequest = null;
            }
            catch (AblyException e) {
                Log.e(TAG, "Channel failed to detach after attach:" + this.name, e);
            }
        }
    }

    public void attach() throws AblyException {
        this.attach(null);
    }

    public void attach(CompletionListener listener) throws AblyException {
        this.attach(false, listener);
    }

    void attach(boolean forceReattach, CompletionListener listener) {
        this.clearAttachTimers();
        this.attachWithTimeout(forceReattach, listener, null);
    }

    synchronized void transferQueuedPresenceMessages(List<ConnectionManager.QueuedMessage> messagesToTransfer) {
        this.state = ChannelState.attaching;
        if (messagesToTransfer != null) {
            for (ConnectionManager.QueuedMessage queuedMessage : messagesToTransfer) {
                PresenceMessage[] presenceMessages = queuedMessage.msg.presence;
                if (presenceMessages == null || presenceMessages.length <= 0) continue;
                for (PresenceMessage presenceMessage : presenceMessages) {
                    this.presence.addPendingPresence(presenceMessage, queuedMessage.listener);
                }
            }
        }
    }

    private void attachImpl(boolean forceReattach, CompletionListener listener, ErrorInfo reattachmentReason) throws AblyException {
        ConnectionManager connectionManager;
        Log.v(TAG, "attach(); channel = " + this.name);
        if (!forceReattach) {
            switch (this.state) {
                case attaching: {
                    if (listener != null) {
                        this.on(new ChannelStateCompletionListener(listener, ChannelState.attached, ChannelState.failed));
                    }
                    return;
                }
                case detaching: {
                    this.pendingAttachRequest = new AttachRequest(forceReattach, listener);
                    return;
                }
                case attached: {
                    ChannelBase.callCompletionListenerSuccess(listener);
                    return;
                }
                case failed: {
                    this.reason = null;
                }
            }
        }
        if (!(connectionManager = this.ably.connection.connectionManager).isActive()) {
            throw AblyException.fromErrorInfo(connectionManager.getStateErrorInfo());
        }
        ConnectionState connState = connectionManager.getConnectionState().state;
        if (connState == ConnectionState.connecting || connState == ConnectionState.disconnected) {
            if (listener != null) {
                this.on(new ChannelStateCompletionListener(listener, ChannelState.attached, ChannelState.failed));
            }
            this.setState(ChannelState.attaching, reattachmentReason);
            return;
        }
        Log.v(TAG, "attach(); channel = " + this.name + "; sending ATTACH request");
        ProtocolMessage attachMessage = new ProtocolMessage(ProtocolMessage.Action.attach, this.name);
        if (this.options != null) {
            if (this.options.hasParams()) {
                attachMessage.params = CollectionUtils.copy(this.options.params);
            }
            if (this.options.hasModes()) {
                attachMessage.setFlags(this.options.getModeFlags());
            }
        }
        attachMessage.channelSerial = this.properties.channelSerial;
        if (this.decodeFailureRecoveryInProgress) {
            Log.v(TAG, "attach(); message decode recovery in progress, setting last message channelserial");
            attachMessage.channelSerial = this.lastPayloadProtocolMessageChannelSerial;
        }
        if (listener != null) {
            this.on(new ChannelStateCompletionListener(listener, ChannelState.attached, ChannelState.failed));
        }
        if (this.attachResume) {
            attachMessage.setFlag(ProtocolMessage.Flag.attach_resume);
        }
        this.setState(ChannelState.attaching, reattachmentReason);
        connectionManager.send(attachMessage, true, null);
    }

    public void detach() throws AblyException {
        this.detach(null);
    }

    public synchronized void markAsReleased() {
        this.released = true;
    }

    public void detach(CompletionListener listener) throws AblyException {
        this.clearAttachTimers();
        this.detachWithTimeout(listener);
    }

    private void detachImpl(CompletionListener listener) throws AblyException {
        Log.v(TAG, "detach(); channel = " + this.name);
        switch (this.state) {
            case initialized: 
            case detached: {
                ChannelBase.callCompletionListenerSuccess(listener);
                return;
            }
            case detaching: {
                if (listener != null) {
                    this.on(new ChannelStateCompletionListener(listener, ChannelState.detached, ChannelState.failed));
                }
                return;
            }
            case attaching: {
                this.pendingDetachRequest = new DetachRequest(listener);
                return;
            }
            case failed: {
                ErrorInfo error = this.reason != null ? this.reason : new ErrorInfo("Channel state is failed", 90000);
                ChannelBase.callCompletionListenerError(listener, error);
                return;
            }
            case suspended: {
                this.setState(ChannelState.detached, null);
                ChannelBase.callCompletionListenerSuccess(listener);
                return;
            }
        }
        ConnectionManager connectionManager = this.ably.connection.connectionManager;
        if (!connectionManager.isActive()) {
            throw AblyException.fromErrorInfo(connectionManager.getStateErrorInfo());
        }
        this.sendDetachMessage(listener);
    }

    private void sendDetachMessage(CompletionListener listener) throws AblyException {
        ProtocolMessage detachMessage = new ProtocolMessage(ProtocolMessage.Action.detach, this.name);
        if (listener != null) {
            this.on(new ChannelStateCompletionListener(listener, ChannelState.detached, ChannelState.failed));
        }
        this.attachResume = false;
        if (this.released) {
            this.setDetached(null);
        } else {
            this.setState(ChannelState.detaching, null);
        }
        this.ably.connection.connectionManager.send(detachMessage, true, null);
    }

    private static void callCompletionListenerSuccess(CompletionListener listener) {
        if (listener != null) {
            try {
                listener.onSuccess();
            }
            catch (Throwable t) {
                Log.e(TAG, "Unexpected exception calling CompletionListener", t);
            }
        }
    }

    @Deprecated
    public void sync() throws AblyException {
        Log.w(TAG, "sync() method is intended only for internal testing purpose as per RTP19");
    }

    private static void callCompletionListenerError(CompletionListener listener, ErrorInfo err) {
        if (listener != null) {
            try {
                listener.onError(err);
            }
            catch (Throwable t) {
                Log.e(TAG, "Unexpected exception calling CompletionListener", t);
            }
        }
    }

    private void setAttached(ProtocolMessage message) {
        this.clearAttachTimers();
        this.properties.attachSerial = message.channelSerial;
        this.params = message.params;
        this.modes = ChannelMode.toSet(message.flags);
        this.attachResume = true;
        if (this.state == ChannelState.detaching || this.state == ChannelState.detached) {
            Log.v(TAG, "setAttached(): channel is in detaching state, as per RTL5k sending detach message!");
            try {
                this.sendDetachMessage(null);
            }
            catch (AblyException e) {
                Log.e(TAG, e.getMessage(), e);
            }
            return;
        }
        if (this.state == ChannelState.attached) {
            Log.v(TAG, String.format(Locale.ROOT, "Server initiated attach for channel %s", this.name));
            if (!message.hasFlag(ProtocolMessage.Flag.resumed)) {
                this.presence.onAttached(message.hasFlag(ProtocolMessage.Flag.has_presence));
                this.emitUpdate(message.error, false);
            }
        } else {
            this.presence.onAttached(message.hasFlag(ProtocolMessage.Flag.has_presence));
            this.setState(ChannelState.attached, message.error, message.hasFlag(ProtocolMessage.Flag.resumed));
        }
    }

    private void setDetached(ErrorInfo reason) {
        this.clearAttachTimers();
        Log.v(TAG, "setDetached(); channel = " + this.name);
        this.presence.onChannelDetachedOrFailed(reason);
        this.setState(ChannelState.detached, reason);
    }

    private void setFailed(ErrorInfo reason) {
        this.clearAttachTimers();
        Log.v(TAG, "setFailed(); channel = " + this.name);
        this.presence.onChannelDetachedOrFailed(reason);
        this.attachResume = false;
        this.setState(ChannelState.failed, reason);
    }

    private synchronized void clearAttachTimers() {
        Timer[] timers = new Timer[]{this.attachTimer, this.reattachTimer};
        this.reattachTimer = null;
        this.attachTimer = null;
        for (Timer t : timers) {
            if (t == null) continue;
            t.cancel();
            t.purge();
        }
    }

    private void attachWithTimeout(CompletionListener listener) throws AblyException {
        this.attachWithTimeout(false, listener, null);
    }

    private synchronized void attachWithTimeout(boolean forceReattach, final CompletionListener listener, ErrorInfo reattachmentReason) {
        Timer currentAttachTimer;
        this.checkChannelIsNotReleased();
        try {
            currentAttachTimer = new Timer();
        }
        catch (Throwable t) {
            ChannelBase.callCompletionListenerError(listener, ErrorInfo.fromThrowable(t));
            return;
        }
        this.attachTimer = currentAttachTimer;
        try {
            this.attachImpl(forceReattach, new CompletionListener(){

                @Override
                public void onSuccess() {
                    ChannelBase.this.clearAttachTimers();
                    ChannelBase.callCompletionListenerSuccess(listener);
                }

                @Override
                public void onError(ErrorInfo reason) {
                    ChannelBase.this.clearAttachTimers();
                    ChannelBase.callCompletionListenerError(listener, reason);
                }
            }, reattachmentReason);
        }
        catch (AblyException e) {
            this.attachTimer = null;
            ChannelBase.callCompletionListenerError(listener, e.errorInfo);
        }
        if (this.attachTimer == null) {
            return;
        }
        final Timer inProgressTimer = currentAttachTimer;
        this.attachTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String errorMessage = String.format(Locale.ROOT, "Attach timed out for channel %s", ChannelBase.this.name);
                Log.v(TAG, errorMessage);
                ChannelBase channelBase = ChannelBase.this;
                synchronized (channelBase) {
                    if (ChannelBase.this.attachTimer != inProgressTimer) {
                        return;
                    }
                    ChannelBase.this.attachTimer = null;
                    if (ChannelBase.this.state == ChannelState.attaching) {
                        ChannelBase.this.setSuspended(new ErrorInfo(errorMessage, 90007), true);
                        ChannelBase.this.reattachAfterTimeout();
                    }
                }
            }
        }, Defaults.realtimeRequestTimeout);
    }

    private void checkChannelIsNotReleased() {
        if (this.released) {
            throw new IllegalStateException("Unable to perform any operation on released channel");
        }
    }

    private synchronized void reattachAfterTimeout() {
        Timer currentReattachTimer;
        try {
            currentReattachTimer = new Timer();
        }
        catch (Throwable t) {
            return;
        }
        this.reattachTimer = currentReattachTimer;
        ++this.retryAttempt;
        int retryDelay = ReconnectionStrategy.getRetryTime(this.ably.options.channelRetryTimeout, this.retryAttempt);
        final Timer inProgressTimer = currentReattachTimer;
        this.reattachTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ChannelBase channelBase = ChannelBase.this;
                synchronized (channelBase) {
                    if (inProgressTimer != ChannelBase.this.reattachTimer) {
                        return;
                    }
                    ChannelBase.this.reattachTimer = null;
                    if (ChannelBase.this.state == ChannelState.suspended) {
                        try {
                            ChannelBase.this.attachWithTimeout(null);
                        }
                        catch (AblyException e) {
                            Log.e(TAG, "Reattach channel failed; channel = " + ChannelBase.this.name, e);
                        }
                    }
                }
            }
        }, retryDelay);
    }

    private synchronized void detachWithTimeout(final CompletionListener listener) {
        Timer currentDetachTimer;
        final ChannelState originalState = this.state;
        try {
            currentDetachTimer = new Timer();
        }
        catch (Throwable t) {
            ChannelBase.callCompletionListenerError(listener, ErrorInfo.fromThrowable(t));
            return;
        }
        this.attachTimer = this.released ? null : currentDetachTimer;
        try {
            CompletionListener completionListener = this.released ? null : new CompletionListener(){

                @Override
                public void onSuccess() {
                    ChannelBase.this.clearAttachTimers();
                    ChannelBase.callCompletionListenerSuccess(listener);
                }

                @Override
                public void onError(ErrorInfo reason) {
                    ChannelBase.this.clearAttachTimers();
                    ChannelBase.callCompletionListenerError(listener, reason);
                }
            };
            this.detachImpl(completionListener);
        }
        catch (AblyException e) {
            this.attachTimer = null;
            ChannelBase.callCompletionListenerError(listener, e.errorInfo);
        }
        if (this.attachTimer == null) {
            return;
        }
        final Timer inProgressTimer = currentDetachTimer;
        this.attachTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ChannelBase channelBase = ChannelBase.this;
                synchronized (channelBase) {
                    if (inProgressTimer != ChannelBase.this.attachTimer) {
                        return;
                    }
                    ChannelBase.this.attachTimer = null;
                    if (ChannelBase.this.state == ChannelState.detaching) {
                        ErrorInfo reason = new ErrorInfo("Detach operation timed out", 90007);
                        ChannelBase.callCompletionListenerError(listener, reason);
                        ChannelBase.this.setState(originalState, reason);
                    }
                }
            }
        }, Defaults.realtimeRequestTimeout);
    }

    public void setConnected() {
        if (this.state.isReattachable()) {
            this.attach(true, null);
        }
    }

    public void setConnectionFailed(ErrorInfo reason) {
        this.clearAttachTimers();
        if (this.state == ChannelState.attached || this.state == ChannelState.attaching) {
            this.setFailed(reason);
        }
    }

    public void setConnectionClosed(ErrorInfo reason) {
        this.clearAttachTimers();
        if (this.state == ChannelState.attached || this.state == ChannelState.attaching) {
            this.setDetached(reason);
        }
    }

    public synchronized void setSuspended(ErrorInfo reason, boolean notifyStateChange) {
        this.clearAttachTimers();
        if (this.state == ChannelState.attached || this.state == ChannelState.attaching) {
            Log.v(TAG, "setSuspended(); channel = " + this.name);
            this.presence.onChannelSuspended(reason);
            this.setState(ChannelState.suspended, reason, false, notifyStateChange);
        }
    }

    @Override
    protected void apply(ChannelStateListener listener, ChannelEvent event, Object ... args) {
        try {
            listener.onChannelStateChanged((ChannelStateListener.ChannelStateChange)args[0]);
        }
        catch (Throwable t) {
            Log.e(TAG, "Unexpected exception calling ChannelStateListener", t);
        }
    }

    public synchronized void unsubscribe() {
        Log.v(TAG, "unsubscribe(); channel = " + this.name);
        this.listeners.clear();
        this.eventListeners.clear();
    }

    protected boolean attachOnSubscribeEnabled() {
        return this.options == null || this.options.attachOnSubscribe;
    }

    public synchronized void subscribe(MessageListener listener) throws AblyException {
        Log.v(TAG, "subscribe(); channel = " + this.name);
        this.listeners.add(listener);
        if (this.attachOnSubscribeEnabled()) {
            this.attach();
        }
    }

    public synchronized void unsubscribe(MessageListener listener) {
        Log.v(TAG, "unsubscribe(); channel = " + this.name);
        this.listeners.remove(listener);
        for (MessageMulticaster multicaster : this.eventListeners.values()) {
            multicaster.remove(listener);
        }
    }

    public synchronized void subscribe(String name, MessageListener listener) throws AblyException {
        Log.v(TAG, "subscribe(); channel = " + this.name + "; event = " + name);
        this.subscribeImpl(name, listener);
        if (this.attachOnSubscribeEnabled()) {
            this.attach();
        }
    }

    public synchronized void unsubscribe(String name, MessageListener listener) {
        Log.v(TAG, "unsubscribe(); channel = " + this.name + "; event = " + name);
        this.unsubscribeImpl(name, listener);
    }

    public synchronized void subscribe(String[] names, MessageListener listener) throws AblyException {
        Log.v(TAG, "subscribe(); channel = " + this.name + "; (multiple events)");
        for (String name : names) {
            this.subscribeImpl(name, listener);
        }
        if (this.attachOnSubscribeEnabled()) {
            this.attach();
        }
    }

    public synchronized void unsubscribe(String[] names, MessageListener listener) {
        Log.v(TAG, "unsubscribe(); channel = " + this.name + "; (multiple events)");
        for (String name : names) {
            this.unsubscribeImpl(name, listener);
        }
    }

    private void onMessage(ProtocolMessage protocolMessage) {
        DeltaExtras deltaExtras;
        Log.v(TAG, "onMessage(); channel = " + this.name);
        Message[] messages = protocolMessage.messages;
        Message firstMessage = messages[0];
        Message lastMessage = messages[messages.length - 1];
        DeltaExtras deltaExtras2 = deltaExtras = null == firstMessage.extras ? null : firstMessage.extras.getDelta();
        if (null != deltaExtras && !deltaExtras.getFrom().equals(this.lastPayloadMessageId)) {
            Log.e(TAG, String.format(Locale.ROOT, "Delta message decode failure - previous message not available. Message id = %s, channel = %s", firstMessage.id, this.name));
            this.startDecodeFailureRecovery();
            return;
        }
        for (int i = 0; i < messages.length; ++i) {
            Message msg = messages[i];
            if (msg.connectionId == null) {
                msg.connectionId = protocolMessage.connectionId;
            }
            if (msg.timestamp == 0L) {
                msg.timestamp = protocolMessage.timestamp;
            }
            if (msg.id == null) {
                msg.id = protocolMessage.id + ':' + i;
            }
            if (msg.version == null) {
                msg.version = String.format("%s:%03d", protocolMessage.channelSerial, i);
            }
            if (msg.serial == null && msg.action == MessageAction.MESSAGE_CREATE) {
                msg.serial = msg.version;
            }
            if (msg.createdAt == null && msg.action == MessageAction.MESSAGE_CREATE) {
                msg.createdAt = msg.timestamp;
            }
            try {
                msg.decode(this.options, this.decodingContext);
            }
            catch (MessageDecodeException e) {
                if (e.errorInfo.code == 40018) {
                    Log.e(TAG, String.format(Locale.ROOT, "Delta message decode failure - %s. Message id = %s, channel = %s", e.errorInfo.message, msg.id, this.name));
                    this.startDecodeFailureRecovery();
                    for (int j = i + 1; j < messages.length; ++j) {
                        String jId = messages[j].id;
                        String jIdToLog = null == jId ? protocolMessage.id + ':' + j : jId;
                        Log.v(TAG, String.format(Locale.ROOT, "Delta recovery in progress - message skipped. Message id = %s, channel = %s", jIdToLog, this.name));
                    }
                    return;
                }
                Log.e(TAG, String.format(Locale.ROOT, "Message decode failure - %s. Message id = %s, channel = %s", e.errorInfo.message, msg.id, this.name));
            }
            MessageMulticaster listeners = this.eventListeners.get(msg.name);
            if (listeners == null) continue;
            listeners.onMessage(msg);
        }
        this.lastPayloadMessageId = lastMessage.id;
        this.lastPayloadProtocolMessageChannelSerial = protocolMessage.channelSerial;
        for (Message msg : messages) {
            this.listeners.onMessage(msg);
        }
    }

    private void startDecodeFailureRecovery() {
        if (this.decodeFailureRecoveryInProgress) {
            return;
        }
        Log.w(TAG, "Starting delta decode failure recovery process");
        this.decodeFailureRecoveryInProgress = true;
        this.attach(true, new CompletionListener(){

            @Override
            public void onSuccess() {
                ChannelBase.this.decodeFailureRecoveryInProgress = false;
            }

            @Override
            public void onError(ErrorInfo reason) {
                ChannelBase.this.decodeFailureRecoveryInProgress = false;
            }
        });
    }

    private void subscribeImpl(String name, MessageListener listener) throws AblyException {
        MessageMulticaster listeners = this.eventListeners.get(name);
        if (listeners == null) {
            listeners = new MessageMulticaster();
            this.eventListeners.put(name, listeners);
        }
        listeners.add(listener);
    }

    private void unsubscribeImpl(String name, MessageListener listener) {
        MessageMulticaster listeners = this.eventListeners.get(name);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.eventListeners.remove(name);
            }
        }
    }

    public void publish(String name, Object data) throws AblyException {
        this.publish(name, data, null);
    }

    public void publish(Message message) throws AblyException {
        this.publish(message, null);
    }

    public void publish(Message[] messages) throws AblyException {
        this.publish(messages, null);
    }

    public void publish(String name, Object data, CompletionListener listener) throws AblyException {
        Log.v(TAG, "publish(String, Object); channel = " + this.name + "; event = " + name);
        this.publish(new Message[]{new Message(name, data)}, listener);
    }

    public void publish(Message message, CompletionListener listener) throws AblyException {
        Log.v(TAG, "publish(Message); channel = " + this.name + "; event = " + message.name);
        this.publish(new Message[]{message}, listener);
    }

    public synchronized void publish(Message[] messages, CompletionListener listener) throws AblyException {
        Log.v(TAG, "publish(Message[]); channel = " + this.name);
        ConnectionManager connectionManager = this.ably.connection.connectionManager;
        ConnectionManager.State connectionState = connectionManager.getConnectionState();
        boolean queueMessages = this.ably.options.queueMessages;
        if (!connectionManager.isActive() || connectionState.queueEvents && !queueMessages) {
            throw AblyException.fromErrorInfo(connectionState.defaultErrorInfo);
        }
        boolean connected = connectionState.sendEvents;
        try {
            for (Message message : messages) {
                this.ably.auth.checkClientId(message, true, connected);
                message.encode(this.options);
            }
        }
        catch (AblyException e) {
            ChannelBase.callCompletionListenerError(listener, e.errorInfo);
            return;
        }
        ProtocolMessage msg = new ProtocolMessage(ProtocolMessage.Action.message, this.name);
        msg.messages = messages;
        switch (this.state) {
            case failed: 
            case suspended: {
                throw AblyException.fromErrorInfo(new ErrorInfo("Unable to publish in failed or suspended state", 400, 40000));
            }
        }
        connectionManager.send(msg, queueMessages, listener);
    }

    static Param[] replacePlaceholderParams(Channel channel, Param[] placeholderParams) throws AblyException {
        if (placeholderParams == null) {
            return null;
        }
        HashSet<Param> params = new HashSet<Param>();
        for (int i = 0; i < placeholderParams.length; ++i) {
            Param param = placeholderParams[i];
            if (KEY_UNTIL_ATTACH.equals(param.key)) {
                if ("true".equalsIgnoreCase(param.value)) {
                    if (channel.state != ChannelState.attached) {
                        throw AblyException.fromErrorInfo(new ErrorInfo("option untilAttach requires the channel to be attached", 40000, 400));
                    }
                    params.add(new Param(KEY_FROM_SERIAL, channel.properties.attachSerial));
                    continue;
                }
                if ("false".equalsIgnoreCase(param.value)) continue;
                throw AblyException.fromErrorInfo(new ErrorInfo("option untilAttach is invalid. \"true\" or \"false\" expected", 40000, 400));
            }
            params.add(param);
        }
        return params.toArray(new Param[params.size()]);
    }

    public PaginatedResult<Message> history(Param[] params) throws AblyException {
        return this.historyImpl(params).sync();
    }

    public void historyAsync(Param[] params, Callback<AsyncPaginatedResult<Message>> callback) {
        this.historyImpl(params).async(callback);
    }

    private BasePaginatedQuery.ResultRequest<Message> historyImpl(Param[] params) {
        try {
            params = ChannelBase.replacePlaceholderParams((Channel)this, params);
        }
        catch (AblyException e) {
            return new BasePaginatedQuery.ResultRequest.Failed<Message>(e);
        }
        HttpCore.BodyHandler<Message> bodyHandler = MessageSerializer.getMessageResponseHandler(this.options);
        return new BasePaginatedQuery<Message>(this.ably.http, this.basePath + "/history", HttpUtils.defaultAcceptHeaders(this.ably.options.useBinaryProtocol), params, bodyHandler).get();
    }

    public void setOptions(ChannelOptions options) throws AblyException {
        this.setOptions(options, null);
    }

    public void setOptions(ChannelOptions options, CompletionListener listener) throws AblyException {
        this.options = options;
        if (this.shouldReattachToSetOptions(options)) {
            this.attach(true, listener);
        } else {
            ChannelBase.callCompletionListenerSuccess(listener);
        }
    }

    boolean shouldReattachToSetOptions(ChannelOptions options) {
        return !(this.state != ChannelState.attached && this.state != ChannelState.attaching || !options.hasModes() && !options.hasParams());
    }

    public Map<String, String> getParams() {
        return CollectionUtils.copy(this.params);
    }

    public ChannelMode[] getModes() {
        return this.modes.toArray(new ChannelMode[this.modes.size()]);
    }

    ChannelBase(AblyRealtime ably, String name, ChannelOptions options) throws AblyException {
        Log.v(TAG, "RealtimeChannel(); channel = " + name);
        this.ably = ably;
        this.name = name;
        this.basePath = "/channels/" + HttpUtils.encodeURIComponent(name);
        this.setOptions(options);
        this.presence = new Presence((Channel)this);
        this.attachResume = false;
        this.state = ChannelState.initialized;
        this.decodingContext = new DecodingContext();
    }

    void onChannelMessage(ProtocolMessage msg) {
        if (!(StringUtils.isNullOrEmpty(msg.channelSerial) || msg.action != ProtocolMessage.Action.message && msg.action != ProtocolMessage.Action.presence && msg.action != ProtocolMessage.Action.attached)) {
            Log.v(TAG, String.format(Locale.ROOT, "Setting channel serial for channelName - %s, previous - %s, current - %s", this.name, this.properties.channelSerial, msg.channelSerial));
            this.properties.channelSerial = msg.channelSerial;
        }
        block0 : switch (msg.action) {
            case attached: {
                this.setAttached(msg);
                break;
            }
            case detach: 
            case detached: {
                ChannelState oldState = this.state;
                switch (oldState) {
                    case attached: 
                    case suspended: {
                        Log.v(TAG, String.format(Locale.ROOT, "Server initiated detach for channel %s; attempting reattach", this.name));
                        this.attachWithTimeout(true, null, msg.error);
                        break block0;
                    }
                    case attaching: {
                        Log.v(TAG, String.format(Locale.ROOT, "Server initiated detach for channel %s whilst attaching; moving to suspended", this.name));
                        this.setSuspended(msg.error, true);
                        this.reattachAfterTimeout();
                        break block0;
                    }
                    case detaching: {
                        this.setDetached(msg.error != null ? msg.error : REASON_NOT_ATTACHED);
                        break block0;
                    }
                }
                break;
            }
            case message: {
                if (this.state == ChannelState.attached) {
                    this.onMessage(msg);
                    break;
                }
                String errorMsgPrefix = this.decodeFailureRecoveryInProgress ? "Delta recovery in progress - message skipped." : "Message skipped on a channel that is not ATTACHED.";
                for (Message skippedMessage : msg.messages) {
                    Log.v(TAG, String.format(errorMsgPrefix + " Message id = %s, channel = %s", skippedMessage.id, this.name));
                }
                break;
            }
            case sync: {
                this.presence.onSync(msg);
                break;
            }
            case presence: {
                this.presence.onPresence(msg);
                break;
            }
            case error: {
                this.setFailed(msg.error);
                break;
            }
            default: {
                Log.e(TAG, "onChannelMessage(): Unexpected message action (" + (Object)((Object)msg.action) + ")");
            }
        }
    }

    void emitUpdate(ErrorInfo errorInfo, boolean resumed) {
        if (this.state == ChannelState.attached) {
            this.emit(ChannelEvent.update, ChannelStateListener.ChannelStateChange.createUpdateEvent(errorInfo, resumed));
        }
    }

    public void emit(ChannelState state, ChannelStateListener.ChannelStateChange channelStateChange) {
        super.emit(state.getChannelEvent(), channelStateChange);
    }

    @Override
    public void on(ChannelState state, ChannelStateListener listener) {
        super.on(state.getChannelEvent(), listener);
    }

    @Override
    public void once(ChannelState state, ChannelStateListener listener) {
        super.once(state.getChannelEvent(), listener);
    }

    private static class AttachRequest {
        final boolean forceReattach;
        final CompletionListener completionListener;

        private AttachRequest(boolean forceReattach, CompletionListener completionListener) {
            this.forceReattach = forceReattach;
            this.completionListener = completionListener;
        }
    }

    private static class DetachRequest {
        final CompletionListener completionListener;

        private DetachRequest(CompletionListener completionListener) {
            this.completionListener = completionListener;
        }
    }

    private class ChannelStateCompletionListener
    implements ChannelStateListener {
        private CompletionListener completionListener;
        private final ChannelState successState;
        private final ChannelState failureState;

        ChannelStateCompletionListener(CompletionListener completionListener, ChannelState successState, ChannelState failureState) {
            this.completionListener = completionListener;
            this.successState = successState;
            this.failureState = failureState;
        }

        @Override
        public void onChannelStateChanged(ChannelStateListener.ChannelStateChange stateChange) {
            if (stateChange.current.equals((Object)this.successState)) {
                ChannelBase.this.off(this);
                this.completionListener.onSuccess();
            } else if (stateChange.current.equals((Object)this.failureState)) {
                ChannelBase.this.off(this);
                this.completionListener.onError(ChannelBase.this.reason);
            }
        }
    }

    private static class MessageMulticaster
    extends Multicaster<MessageListener>
    implements MessageListener {
        private MessageMulticaster() {
            super(new MessageListener[0]);
        }

        @Override
        public void onMessage(Message message) {
            for (MessageListener member : this.getMembers()) {
                try {
                    member.onMessage(message);
                }
                catch (Throwable t) {
                    Log.e(TAG, "Unexpected exception calling listener", t);
                }
            }
        }
    }

    public static interface MessageListener {
        public void onMessage(Message var1);
    }

    private static class FailedMessage {
        ConnectionManager.QueuedMessage msg;
        ErrorInfo reason;

        FailedMessage(ConnectionManager.QueuedMessage msg, ErrorInfo reason) {
            this.msg = msg;
            this.reason = reason;
        }
    }
}

