/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.push;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ably.lib.http.BasePaginatedQuery;
import io.ably.lib.http.Http;
import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpScheduler;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.push.LocalDevice;
import io.ably.lib.push.PushBase;
import io.ably.lib.realtime.CompletionListener;
import io.ably.lib.rest.AblyRest;
import io.ably.lib.rest.Channel;
import io.ably.lib.rest.DeviceDetails;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.AsyncPaginatedResult;
import io.ably.lib.types.Callback;
import io.ably.lib.types.PaginatedResult;
import io.ably.lib.types.Param;
import io.ably.lib.util.ParamsUtils;

public class PushChannel {
    protected final Channel channel;
    protected final AblyRest rest;

    public PushChannel(Channel channel, AblyRest rest) {
        this.channel = channel;
        this.rest = rest;
    }

    public void subscribeClient() throws AblyException {
        this.subscribeClientImpl().sync();
    }

    public void subscribeClientAsync(CompletionListener listener) {
        this.subscribeClientImpl().async(new CompletionListener.ToCallback(listener));
    }

    protected Http.Request<Void> subscribeClientImpl() {
        JsonObject bodyJson = new JsonObject();
        try {
            bodyJson.addProperty("clientId", this.getClientId());
        }
        catch (AblyException e) {
            return this.rest.http.failedRequest(e);
        }
        return this.postSubscription(bodyJson);
    }

    public void subscribeDevice() throws AblyException {
        this.subscribeDeviceImpl().sync();
    }

    public void subscribeDeviceAsync(CompletionListener listener) {
        this.subscribeDeviceImpl().async(new CompletionListener.ToCallback(listener));
    }

    protected Http.Request<Void> subscribeDeviceImpl() {
        try {
            DeviceDetails device = this.getDevice();
            JsonObject bodyJson = new JsonObject();
            bodyJson.addProperty("deviceId", device.id);
            return this.postSubscription(bodyJson);
        }
        catch (AblyException e) {
            return this.rest.http.failedRequest(e);
        }
    }

    protected Http.Request<Void> postSubscription(JsonObject bodyJson) {
        bodyJson.addProperty("channel", this.channel.name);
        final HttpCore.RequestBody body = HttpUtils.requestBodyFromGson((JsonElement)bodyJson, this.rest.options.useBinaryProtocol);
        return this.rest.http.request(new Http.Execute<Void>(){

            @Override
            public void execute(HttpScheduler http, Callback<Void> callback) throws AblyException {
                Param[] params = ParamsUtils.enrichParams(null, PushChannel.this.rest.options);
                http.post("/push/channelSubscriptions", PushChannel.this.rest.push.pushRequestHeaders(true), params, body, null, true, callback);
            }
        });
    }

    public void unsubscribeClient() throws AblyException {
        this.unsubscribeClientImpl().sync();
    }

    public void unsubscribeClientAsync(CompletionListener listener) {
        this.unsubscribeClientImpl().async(new CompletionListener.ToCallback(listener));
    }

    protected Http.Request<Void> unsubscribeClientImpl() {
        try {
            Param[] params = new Param[]{new Param("channel", this.channel.name), new Param("clientId", this.getClientId())};
            return this.delSubscription(params);
        }
        catch (AblyException e) {
            return this.rest.http.failedRequest(e);
        }
    }

    public void unsubscribeDevice() throws AblyException {
        this.unsubscribeDeviceImpl().sync();
    }

    public void unsubscribeDeviceAsync(CompletionListener listener) {
        this.unsubscribeDeviceImpl().async(new CompletionListener.ToCallback(listener));
    }

    protected Http.Request<Void> unsubscribeDeviceImpl() {
        try {
            DeviceDetails device = this.getDevice();
            Param[] params = new Param[]{new Param("channel", this.channel.name), new Param("deviceId", device.id)};
            return this.delSubscription(params);
        }
        catch (AblyException e) {
            return this.rest.http.failedRequest(e);
        }
    }

    protected Http.Request<Void> delSubscription(Param[] params) {
        final Param[] finalParams = ParamsUtils.enrichParams(params, this.rest.options);
        return this.rest.http.request(new Http.Execute<Void>(){

            @Override
            public void execute(HttpScheduler http, Callback<Void> callback) throws AblyException {
                http.del("/push/channelSubscriptions", PushChannel.this.rest.push.pushRequestHeaders(true), finalParams, null, true, callback);
            }
        });
    }

    public PaginatedResult<PushBase.ChannelSubscription> listSubscriptions() throws AblyException {
        return this.listSubscriptions(new Param[0]);
    }

    public PaginatedResult<PushBase.ChannelSubscription> listSubscriptions(Param[] params) throws AblyException {
        return this.listSubscriptionsImpl(params).sync();
    }

    public void listSubscriptionsAsync(Callback<AsyncPaginatedResult<PushBase.ChannelSubscription>> callback) {
        this.listSubscriptionsAsync(new Param[0], callback);
    }

    public void listSubscriptionsAsync(Param[] params, Callback<AsyncPaginatedResult<PushBase.ChannelSubscription>> callback) {
        this.listSubscriptionsImpl(params).async(callback);
    }

    protected BasePaginatedQuery.ResultRequest<PushBase.ChannelSubscription> listSubscriptionsImpl(Param[] params) {
        params = Param.set(params, "concatFilters", "true");
        return new BasePaginatedQuery<PushBase.ChannelSubscription>(this.rest.http, "/push/channelSubscriptions", this.rest.push.pushRequestHeaders(true), params, PushBase.ChannelSubscription.httpBodyHandler).get();
    }

    protected String getClientId() throws AblyException {
        String clientId = this.getDevice().clientId;
        if (clientId == null) {
            throw AblyException.fromThrowable(new Exception("cannot subscribe with null client ID"));
        }
        return clientId;
    }

    protected DeviceDetails getDevice() throws AblyException {
        LocalDevice localDevice = this.rest.push.getActivationContext().getLocalDevice();
        if (localDevice == null || localDevice.deviceIdentityToken == null) {
            throw AblyException.fromThrowable(new Exception("cannot use device before AblyRest.push.activate has finished"));
        }
        return localDevice;
    }
}

