/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.realtime;

import io.ably.lib.http.BasePaginatedQuery;
import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.realtime.AblyRealtime;
import io.ably.lib.realtime.Channel;
import io.ably.lib.realtime.ChannelState;
import io.ably.lib.realtime.CompletionListener;
import io.ably.lib.realtime.ConnectionState;
import io.ably.lib.transport.ConnectionManager;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.AsyncPaginatedResult;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.MessageDecodeException;
import io.ably.lib.types.PaginatedResult;
import io.ably.lib.types.Param;
import io.ably.lib.types.PresenceMessage;
import io.ably.lib.types.PresenceSerializer;
import io.ably.lib.types.ProtocolMessage;
import io.ably.lib.util.Log;
import io.ably.lib.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Presence {
    public static final String GET_WAITFORSYNC = "waitForSync";
    public static final String GET_CLIENTID = "clientId";
    public static final String GET_CONNECTIONID = "connectionId";
    private final Multicaster listeners = new Multicaster();
    private final EnumMap<PresenceMessage.Action, Multicaster> eventListeners = new EnumMap(PresenceMessage.Action.class);
    private final List<QueuedPresence> pendingPresence = new ArrayList<QueuedPresence>();
    private final PresenceMap presence = new PresenceMap();
    private final PresenceMap internalPresence = new InternalPresenceMap();
    private static final String TAG = Channel.class.getName();
    private final Channel channel;
    private String currentSyncChannelSerial;
    public boolean syncComplete;

    public synchronized PresenceMessage[] get(Param ... params) throws AblyException {
        if (this.channel.state == ChannelState.failed) {
            throw AblyException.fromErrorInfo(new ErrorInfo("channel operation failed (invalid channel state)", 90001));
        }
        this.channel.attach();
        try {
            Collection<PresenceMessage> values = this.presence.get(params);
            return values.toArray(new PresenceMessage[values.size()]);
        }
        catch (InterruptedException e) {
            Log.v(TAG, String.format(Locale.ROOT, "Channel %s: get() operation interrupted", this.channel.name));
            throw AblyException.fromThrowable(e);
        }
    }

    public synchronized PresenceMessage[] get(boolean wait) throws AblyException {
        return this.get(new Param(GET_WAITFORSYNC, String.valueOf(wait)));
    }

    public synchronized PresenceMessage[] get(String clientId, boolean wait) throws AblyException {
        return this.get(new Param(GET_WAITFORSYNC, String.valueOf(wait)), new Param(GET_CLIENTID, clientId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPendingPresence(PresenceMessage presenceMessage, CompletionListener listener) {
        Channel channel = this.channel;
        synchronized (channel) {
            QueuedPresence queuedPresence = new QueuedPresence(presenceMessage, listener);
            this.pendingPresence.add(queuedPresence);
        }
    }

    public void subscribe(PresenceListener listener, CompletionListener completionListener) throws AblyException {
        this.implicitAttachOnSubscribe(completionListener);
        this.listeners.add(listener);
    }

    public void subscribe(PresenceListener listener) throws AblyException {
        this.subscribe(listener, null);
    }

    public void unsubscribe(PresenceListener listener) {
        this.listeners.remove(listener);
        for (Multicaster multicaster : this.eventListeners.values()) {
            multicaster.remove(listener);
        }
    }

    public void subscribe(PresenceMessage.Action action, PresenceListener listener, CompletionListener completionListener) throws AblyException {
        this.implicitAttachOnSubscribe(completionListener);
        this.subscribeImpl(action, listener);
    }

    public void subscribe(PresenceMessage.Action action, PresenceListener listener) throws AblyException {
        this.subscribe(action, listener, null);
    }

    public void unsubscribe(PresenceMessage.Action action, PresenceListener listener) {
        this.unsubscribeImpl(action, listener);
    }

    public void subscribe(EnumSet<PresenceMessage.Action> actions, PresenceListener listener, CompletionListener completionListener) throws AblyException {
        this.implicitAttachOnSubscribe(completionListener);
        for (PresenceMessage.Action action : actions) {
            this.subscribeImpl(action, listener);
        }
    }

    public void subscribe(EnumSet<PresenceMessage.Action> actions, PresenceListener listener) throws AblyException {
        this.subscribe(actions, listener, null);
    }

    public void unsubscribe(EnumSet<PresenceMessage.Action> actions, PresenceListener listener) {
        for (PresenceMessage.Action action : actions) {
            this.unsubscribeImpl(action, listener);
        }
    }

    public void unsubscribe() {
        this.listeners.clear();
        this.eventListeners.clear();
    }

    private void implicitAttachOnSubscribe(CompletionListener completionListener) throws AblyException {
        if (this.channel.state == ChannelState.failed) {
            String errorString = String.format(Locale.ROOT, "Channel %s: subscribe in FAILED channel state", this.channel.name);
            Log.v(TAG, errorString);
            ErrorInfo errorInfo = new ErrorInfo(errorString, 90001);
            throw AblyException.fromErrorInfo(errorInfo);
        }
        this.channel.attach(completionListener);
    }

    private void endSync() {
        List<PresenceMessage> residualMembers = this.presence.endSync();
        for (PresenceMessage member : residualMembers) {
            member.action = PresenceMessage.Action.leave;
            member.id = null;
            member.timestamp = System.currentTimeMillis();
        }
        this.broadcastPresence(residualMembers);
    }

    private void updateInnerPresenceMessageFields(ProtocolMessage message) {
        for (int i = 0; i < message.presence.length; ++i) {
            PresenceMessage msg = message.presence[i];
            try {
                msg.decode(this.channel.options);
            }
            catch (MessageDecodeException e) {
                Log.e(TAG, String.format(Locale.ROOT, "%s on channel %s", e.errorInfo.message, this.channel.name));
            }
            if (msg.connectionId == null) {
                msg.connectionId = message.connectionId;
            }
            if (msg.timestamp == 0L) {
                msg.timestamp = message.timestamp;
            }
            if (msg.id != null) continue;
            msg.id = message.id + ':' + i;
        }
    }

    void onSync(ProtocolMessage protocolMessage) {
        String syncCursor = null;
        String syncChannelSerial = protocolMessage.channelSerial;
        if (!StringUtils.isNullOrEmpty(syncChannelSerial)) {
            String[] serials = syncChannelSerial.split(":");
            String syncSequenceId = serials[0];
            String string = syncCursor = serials.length > 1 ? serials[1] : "";
            if (this.presence.syncInProgress && !StringUtils.isNullOrEmpty(this.currentSyncChannelSerial) && !this.currentSyncChannelSerial.equals(syncSequenceId)) {
                this.endSync();
            }
            this.presence.startSync();
            if (!StringUtils.isNullOrEmpty(syncCursor)) {
                this.currentSyncChannelSerial = syncSequenceId;
            }
        }
        this.onPresence(protocolMessage);
        if (StringUtils.isNullOrEmpty(syncChannelSerial) || StringUtils.isNullOrEmpty(syncCursor)) {
            this.endSync();
            this.currentSyncChannelSerial = null;
        }
    }

    void onPresence(ProtocolMessage protocolMessage) {
        this.updateInnerPresenceMessageFields(protocolMessage);
        ArrayList<PresenceMessage> updatedPresenceMessages = new ArrayList<PresenceMessage>();
        for (PresenceMessage presenceMessage : protocolMessage.presence) {
            boolean updateInternalPresence = presenceMessage.connectionId.equals(this.channel.ably.connection.id);
            boolean memberUpdated = false;
            switch (presenceMessage.action) {
                case enter: 
                case update: 
                case present: {
                    PresenceMessage shallowPresenceCopy = (PresenceMessage)presenceMessage.clone();
                    shallowPresenceCopy.action = PresenceMessage.Action.present;
                    memberUpdated = this.presence.put(shallowPresenceCopy);
                    if (!updateInternalPresence) break;
                    this.internalPresence.put(presenceMessage);
                    break;
                }
                case leave: {
                    memberUpdated = this.presence.remove(presenceMessage);
                    if (!updateInternalPresence) break;
                    this.internalPresence.remove(presenceMessage);
                    break;
                }
            }
            if (!memberUpdated) continue;
            updatedPresenceMessages.add(presenceMessage);
        }
        this.broadcastPresence(updatedPresenceMessages);
    }

    private void broadcastPresence(List<PresenceMessage> messages) {
        for (PresenceMessage message : messages) {
            this.listeners.onPresenceMessage(message);
            Multicaster eventListener = this.eventListeners.get((Object)message.action);
            if (eventListener == null) continue;
            eventListener.onPresenceMessage(message);
        }
    }

    private void subscribeImpl(PresenceMessage.Action action, PresenceListener listener) {
        Multicaster listeners = this.eventListeners.get((Object)action);
        if (listeners == null) {
            listeners = new Multicaster();
            this.eventListeners.put(action, listeners);
        }
        listeners.add(listener);
    }

    private void unsubscribeImpl(PresenceMessage.Action action, PresenceListener listener) {
        Multicaster listeners = this.eventListeners.get((Object)action);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.eventListeners.remove((Object)action);
            }
        }
    }

    public void enter(Object data, CompletionListener listener) throws AblyException {
        Log.v(TAG, "enter(); channel = " + this.channel.name);
        this.updatePresence(new PresenceMessage(PresenceMessage.Action.enter, null, data), listener);
    }

    public void update(Object data, CompletionListener listener) throws AblyException {
        Log.v(TAG, "update(); channel = " + this.channel.name);
        this.updatePresence(new PresenceMessage(PresenceMessage.Action.update, null, data), listener);
    }

    public void leave(Object data, CompletionListener listener) throws AblyException {
        Log.v(TAG, "leave(); channel = " + this.channel.name);
        this.updatePresence(new PresenceMessage(PresenceMessage.Action.leave, null, data), listener);
    }

    public void leave(CompletionListener listener) throws AblyException {
        this.leave(null, listener);
    }

    public void enterClient(String clientId) throws AblyException {
        this.enterClient(clientId, null);
    }

    public void enterClient(String clientId, Object data) throws AblyException {
        this.enterClient(clientId, data, null);
    }

    public void enterClient(String clientId, Object data, CompletionListener listener) throws AblyException {
        if (clientId == null) {
            String errorMessage = String.format(Locale.ROOT, "Channel %s: unable to enter presence channel (null clientId specified)", this.channel.name);
            Log.v(TAG, errorMessage);
            if (listener != null) {
                listener.onError(new ErrorInfo(errorMessage, 40000));
                return;
            }
        }
        Log.v(TAG, "enterClient(); channel = " + this.channel.name + "; clientId = " + clientId);
        this.updatePresence(new PresenceMessage(PresenceMessage.Action.enter, clientId, data), listener);
    }

    private void enterClientWithId(String id, String clientId, Object data, CompletionListener listener) throws AblyException {
        if (clientId == null) {
            String errorMessage = String.format(Locale.ROOT, "Channel %s: unable to enter presence channel (null clientId specified)", this.channel.name);
            Log.v(TAG, errorMessage);
            if (listener != null) {
                listener.onError(new ErrorInfo(errorMessage, 40000));
                return;
            }
        }
        PresenceMessage presenceMsg = new PresenceMessage(PresenceMessage.Action.enter, clientId, data);
        presenceMsg.id = id;
        Log.v(TAG, "enterClient(); channel = " + this.channel.name + "; clientId = " + clientId);
        this.updatePresence(presenceMsg, listener);
    }

    public void updateClient(String clientId) throws AblyException {
        this.updateClient(clientId, null);
    }

    public void updateClient(String clientId, Object data) throws AblyException {
        this.updateClient(clientId, data, null);
    }

    public void updateClient(String clientId, Object data, CompletionListener listener) throws AblyException {
        if (clientId == null) {
            String errorMessage = String.format(Locale.ROOT, "Channel %s: unable to update presence channel (null clientId specified)", this.channel.name);
            Log.v(TAG, errorMessage);
            if (listener != null) {
                listener.onError(new ErrorInfo(errorMessage, 40000));
                return;
            }
        }
        Log.v(TAG, "updateClient(); channel = " + this.channel.name + "; clientId = " + clientId);
        this.updatePresence(new PresenceMessage(PresenceMessage.Action.update, clientId, data), listener);
    }

    public void leaveClient(String clientId) throws AblyException {
        this.leaveClient(clientId, null);
    }

    public void leaveClient(String clientId, Object data) throws AblyException {
        this.leaveClient(clientId, data, null);
    }

    public void leaveClient(String clientId, Object data, CompletionListener listener) throws AblyException {
        if (clientId == null) {
            String errorMessage = String.format(Locale.ROOT, "Channel %s: unable to leave presence channel (null clientId specified)", this.channel.name);
            Log.v(TAG, errorMessage);
            if (listener != null) {
                listener.onError(new ErrorInfo(errorMessage, 40000));
                return;
            }
        }
        Log.v(TAG, "leaveClient(); channel = " + this.channel.name + "; clientId = " + clientId);
        this.updatePresence(new PresenceMessage(PresenceMessage.Action.leave, clientId, data), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePresence(PresenceMessage msg, CompletionListener listener) throws AblyException {
        Log.v(TAG, "updatePresence(); channel = " + this.channel.name);
        AblyRealtime ably = this.channel.ably;
        boolean connected = ably.connection.state == ConnectionState.connected;
        try {
            ably.auth.checkClientId(msg, false, connected);
        }
        catch (AblyException e) {
            if (listener != null) {
                listener.onError(e.errorInfo);
            }
            return;
        }
        msg.encode(null);
        Channel channel = this.channel;
        synchronized (channel) {
            switch (this.channel.state) {
                case initialized: {
                    this.channel.attach();
                }
                case attaching: {
                    this.pendingPresence.add(new QueuedPresence(msg, listener));
                    break;
                }
                case attached: {
                    ProtocolMessage message = new ProtocolMessage(ProtocolMessage.Action.presence, this.channel.name);
                    message.presence = new PresenceMessage[]{msg};
                    ConnectionManager connectionManager = ably.connection.connectionManager;
                    connectionManager.send(message, ably.options.queueMessages, listener);
                    break;
                }
                default: {
                    throw AblyException.fromErrorInfo(new ErrorInfo("Unable to enter presence channel in detached or failed state", 400, 91001));
                }
            }
        }
    }

    public PaginatedResult<PresenceMessage> history(Param[] params) throws AblyException {
        return this.historyImpl(params).sync();
    }

    public void historyAsync(Param[] params, Callback<AsyncPaginatedResult<PresenceMessage>> callback) {
        this.historyImpl(params).async(callback);
    }

    private BasePaginatedQuery.ResultRequest<PresenceMessage> historyImpl(Param[] params) {
        try {
            params = Channel.replacePlaceholderParams(this.channel, params);
        }
        catch (AblyException e) {
            return new BasePaginatedQuery.ResultRequest.Failed<PresenceMessage>(e);
        }
        AblyRealtime ably = this.channel.ably;
        HttpCore.BodyHandler<PresenceMessage> bodyHandler = PresenceSerializer.getPresenceResponseHandler(this.channel.options);
        return new BasePaginatedQuery<PresenceMessage>(ably.http, this.channel.basePath + "/presence/history", HttpUtils.defaultAcceptHeaders(ably.options.useBinaryProtocol), params, bodyHandler).get();
    }

    private void sendQueuedMessages() {
        block6: {
            CompletionListener listener;
            Log.v(TAG, "sendQueuedMessages()");
            AblyRealtime ably = this.channel.ably;
            boolean queueMessages = ably.options.queueMessages;
            ConnectionManager connectionManager = ably.connection.connectionManager;
            int count = this.pendingPresence.size();
            if (count == 0) {
                return;
            }
            ProtocolMessage message = new ProtocolMessage(ProtocolMessage.Action.presence, this.channel.name);
            Iterator<QueuedPresence> allQueued = this.pendingPresence.iterator();
            message.presence = new PresenceMessage[count];
            PresenceMessage[] presenceMessages = message.presence;
            if (count == 1) {
                QueuedPresence queued = allQueued.next();
                presenceMessages[0] = queued.msg;
                listener = queued.listener;
            } else {
                int idx = 0;
                CompletionListener.Multicaster mListener = new CompletionListener.Multicaster(new CompletionListener[0]);
                while (allQueued.hasNext()) {
                    QueuedPresence queued = allQueued.next();
                    presenceMessages[idx++] = queued.msg;
                    if (queued.listener == null) continue;
                    mListener.add(queued.listener);
                }
                listener = mListener.isEmpty() ? null : mListener;
            }
            this.pendingPresence.clear();
            try {
                connectionManager.send(message, queueMessages, listener);
            }
            catch (AblyException e) {
                Log.e(TAG, "sendQueuedMessages(): Unexpected exception sending message", e);
                if (listener == null) break block6;
                listener.onError(e.errorInfo);
            }
        }
    }

    private void failQueuedMessages(ErrorInfo reason) {
        Log.v(TAG, "failQueuedMessages()");
        for (QueuedPresence msg : this.pendingPresence) {
            if (msg.listener == null) continue;
            try {
                msg.listener.onError(reason);
            }
            catch (Throwable t) {
                Log.e(TAG, "failQueuedMessages(): Unexpected exception calling listener", t);
            }
        }
        this.pendingPresence.clear();
    }

    void onAttached(boolean hasPresence) {
        this.presence.startSync();
        if (!hasPresence) {
            this.endSync();
        }
        this.sendQueuedMessages();
        this.enterInternalMembers();
    }

    void enterInternalMembers() {
        for (final PresenceMessage item : this.internalPresence.members.values()) {
            try {
                this.enterClientWithId(item.id, item.clientId, item.data, new CompletionListener(){

                    @Override
                    public void onSuccess() {
                    }

                    @Override
                    public void onError(ErrorInfo reason) {
                        String errorString = String.format(Locale.ROOT, "Cannot automatically re-enter %s on channel %s (%s)", item.clientId, ((Presence)Presence.this).channel.name, reason.message);
                        Log.e(TAG, errorString);
                        Presence.this.channel.emitUpdate(new ErrorInfo(errorString, 91004), true);
                    }
                });
            }
            catch (AblyException e) {
                String errorString = String.format(Locale.ROOT, "Cannot automatically re-enter %s on channel %s (%s)", item.clientId, this.channel.name, e.errorInfo.message);
                Log.e(TAG, errorString);
                this.channel.emitUpdate(new ErrorInfo(errorString, 91004), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onChannelDetachedOrFailed(ErrorInfo reason) {
        PresenceMap presenceMap = this.presence;
        synchronized (presenceMap) {
            this.presence.notifyAll();
        }
        this.presence.clear();
        this.internalPresence.clear();
        this.failQueuedMessages(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onChannelSuspended(ErrorInfo reason) {
        PresenceMap presenceMap = this.presence;
        synchronized (presenceMap) {
            this.presence.notifyAll();
        }
        this.failQueuedMessages(reason);
    }

    Presence(Channel channel) {
        this.channel = channel;
    }

    private class InternalPresenceMap
    extends PresenceMap {
        private InternalPresenceMap() {
        }

        @Override
        public String memberKey(PresenceMessage item) {
            return item.clientId;
        }
    }

    private class PresenceMap {
        private boolean syncInProgress;
        private Collection<String> residualMembers;
        private final HashMap<String, PresenceMessage> members = new HashMap();

        private PresenceMap() {
        }

        synchronized void waitForSync() throws AblyException, InterruptedException {
            String errorMessage;
            int errorCode;
            boolean syncIsComplete = false;
            while (((Presence)Presence.this).channel.state == ChannelState.attaching) {
                this.wait();
            }
            if (((Presence)Presence.this).channel.state == ChannelState.attached) {
                do {
                    boolean bl = syncIsComplete = !this.syncInProgress && Presence.this.syncComplete;
                    if (syncIsComplete) continue;
                    this.wait();
                } while (!syncIsComplete);
            }
            if (((Presence)Presence.this).channel.state == ChannelState.suspended) {
                errorCode = 91005;
                errorMessage = String.format(Locale.ROOT, "Channel %s: presence state is out of sync due to the channel being in a SUSPENDED state", ((Presence)Presence.this).channel.name);
            } else {
                if (syncIsComplete) {
                    return;
                }
                errorCode = 90001;
                errorMessage = String.format(Locale.ROOT, "Channel %s: cannot get presence state because channel is in invalid state", ((Presence)Presence.this).channel.name);
            }
            Log.v(TAG, errorMessage);
            throw AblyException.fromErrorInfo(new ErrorInfo(errorMessage, errorCode));
        }

        synchronized Collection<PresenceMessage> get(Param[] params) throws AblyException, InterruptedException {
            boolean waitForSync = true;
            String clientId = null;
            String connectionId = null;
            block10: for (Param param : params) {
                switch (param.key) {
                    case "waitForSync": {
                        waitForSync = Boolean.parseBoolean(param.value);
                        continue block10;
                    }
                    case "clientId": {
                        clientId = param.value;
                        continue block10;
                    }
                    case "connectionId": {
                        connectionId = param.value;
                    }
                }
            }
            HashSet<PresenceMessage> result = new HashSet<PresenceMessage>();
            if (waitForSync) {
                this.waitForSync();
            }
            for (PresenceMessage member : this.members.values()) {
                if (clientId != null && !member.clientId.equals(clientId) || connectionId != null && !member.connectionId.equals(connectionId)) continue;
                result.add(member);
            }
            return result;
        }

        synchronized boolean put(PresenceMessage item) {
            String key = this.memberKey(item);
            if (this.residualMembers != null) {
                this.residualMembers.remove(key);
            }
            if (this.hasNewerItem(key, item)) {
                return false;
            }
            this.members.put(key, item);
            return true;
        }

        synchronized boolean hasNewerItem(String key, PresenceMessage item) {
            PresenceMessage existingItem = this.members.get(key);
            if (existingItem == null) {
                return false;
            }
            if (!(item.connectionId == null || existingItem.connectionId == null || item.id.startsWith(item.connectionId) && existingItem.id.startsWith(existingItem.connectionId))) {
                return existingItem.timestamp >= item.timestamp;
            }
            String[] itemComponents = item.id.split(":", 3);
            String[] existingItemComponents = existingItem.id.split(":", 3);
            if (itemComponents.length < 3 || existingItemComponents.length < 3) {
                return false;
            }
            try {
                long messageSerial = Long.parseLong(itemComponents[1]);
                long messageIndex = Long.parseLong(itemComponents[2]);
                long existingMessageSerial = Long.parseLong(existingItemComponents[1]);
                long existingMessageIndex = Long.parseLong(existingItemComponents[2]);
                return existingMessageSerial > messageSerial || existingMessageSerial == messageSerial && existingMessageIndex >= messageIndex;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        synchronized boolean remove(PresenceMessage item) {
            String key = this.memberKey(item);
            if (this.hasNewerItem(key, item)) {
                return false;
            }
            PresenceMessage existingItem = this.members.remove(key);
            return existingItem == null || existingItem.action != PresenceMessage.Action.absent;
        }

        synchronized void startSync() {
            Log.v(TAG, "startSync(); channel = " + ((Presence)Presence.this).channel.name + "; syncInProgress = " + this.syncInProgress);
            if (!this.syncInProgress) {
                this.residualMembers = new HashSet<String>(this.members.keySet());
                this.syncInProgress = true;
            }
        }

        synchronized List<PresenceMessage> endSync() {
            Log.v(TAG, "endSync(); channel = " + ((Presence)Presence.this).channel.name + "; syncInProgress = " + this.syncInProgress);
            ArrayList<PresenceMessage> removedEntries = new ArrayList<PresenceMessage>();
            if (this.syncInProgress) {
                Iterator<Map.Entry<String, PresenceMessage>> it = this.members.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, PresenceMessage> entry = it.next();
                    if (entry.getValue().action != PresenceMessage.Action.absent) continue;
                    it.remove();
                }
                for (String itemKey : this.residualMembers) {
                    PresenceMessage removedMember = this.members.remove(itemKey);
                    if (removedMember == null) continue;
                    removedEntries.add((PresenceMessage)removedMember.clone());
                }
                this.residualMembers = null;
                this.syncInProgress = false;
            }
            Presence.this.syncComplete = true;
            this.notifyAll();
            return removedEntries;
        }

        synchronized void clear() {
            this.members.clear();
            if (this.residualMembers != null) {
                this.residualMembers.clear();
            }
        }

        public String memberKey(PresenceMessage item) {
            return item.memberKey();
        }
    }

    private static class QueuedPresence {
        public PresenceMessage msg;
        public CompletionListener listener;

        QueuedPresence(PresenceMessage msg, CompletionListener listener) {
            this.msg = msg;
            this.listener = listener;
        }
    }

    private static class Multicaster
    extends io.ably.lib.util.Multicaster<PresenceListener>
    implements PresenceListener {
        private Multicaster() {
            super(new PresenceListener[0]);
        }

        @Override
        public void onPresenceMessage(PresenceMessage message) {
            for (PresenceListener member : this.getMembers()) {
                try {
                    member.onPresenceMessage(message);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static interface PresenceListener {
        public void onPresenceMessage(PresenceMessage var1);
    }
}

