/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import io.ably.lib.types.AblyException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;

public class Capability {
    private JsonObject json;
    private boolean dirty;
    private static final Gson gson = new Gson();
    private static final JsonParser gsonParser = new JsonParser();

    public static final String c14n(String capability) throws AblyException {
        if (capability == null || capability.isEmpty()) {
            return "";
        }
        try {
            JsonObject json = (JsonObject)gsonParser.parse(capability);
            return new Capability(json).toString();
        }
        catch (ClassCastException e) {
            throw AblyException.fromThrowable(e);
        }
        catch (JsonParseException e) {
            throw AblyException.fromThrowable(e);
        }
    }

    public Capability() {
        this.json = new JsonObject();
    }

    private Capability(JsonObject json) {
        this.json = json;
        this.dirty = true;
    }

    public void addResource(String resource, String[] ops) {
        JsonArray jsonOps = (JsonArray)gson.toJsonTree((Object)ops);
        this.json.add(resource, (JsonElement)jsonOps);
        this.dirty = true;
    }

    public void addResource(String resource, String op) {
        this.addResource(resource, new String[]{op});
    }

    public void addResource(String resource) {
        this.addResource(resource, new String[0]);
    }

    public void removeResource(String resource) {
        this.json.remove(resource);
    }

    public void addOperation(String resource, String op) {
        JsonArray jsonOps = (JsonArray)this.json.get(resource);
        if (jsonOps == null) {
            jsonOps = new JsonArray();
            this.json.add(resource, (JsonElement)jsonOps);
        }
        int opCount = jsonOps.size();
        for (int i = 0; i < opCount; ++i) {
            if (!jsonOps.get(i).getAsString().equals(op)) continue;
            return;
        }
        jsonOps.add(op);
        this.dirty = true;
    }

    public void removeOperation(String resource, String op) {
        JsonArray jsonOps = (JsonArray)this.json.get(resource);
        if (jsonOps == null) {
            return;
        }
        int opCount = jsonOps.size();
        for (int i = 0; i < opCount; ++i) {
            if (!jsonOps.get(i).getAsString().equals(op)) continue;
            if (opCount == 1) {
                this.json.remove(resource);
            } else {
                jsonOps.remove(i);
            }
            return;
        }
    }

    public String toString() {
        if (this.dirty) {
            Set entries = this.json.entrySet();
            if (entries.isEmpty()) {
                return "";
            }
            Object[] resources = new String[entries.size()];
            int idx = 0;
            for (Map.Entry entry : entries) {
                resources[idx++] = (String)entry.getKey();
            }
            Arrays.sort(resources);
            JsonObject c14nJson = new JsonObject();
            for (Object resource : resources) {
                JsonArray jsonOps = this.json.get((String)resource).getAsJsonArray();
                int count = jsonOps.size();
                Object[] ops = new String[count];
                for (int i = 0; i < count; ++i) {
                    ops[i] = jsonOps.get(i).getAsString();
                }
                Arrays.sort(ops);
                c14nJson.add((String)resource, gson.toJsonTree((Object)ops));
            }
            this.json = c14nJson;
            this.dirty = false;
        }
        return gson.toJson((JsonElement)this.json);
    }
}

