/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.realtime;

import io.ably.lib.realtime.ChannelEvent;
import io.ably.lib.realtime.ChannelState;
import io.ably.lib.types.ErrorInfo;

public interface ChannelStateListener {
    public void onChannelStateChanged(ChannelStateChange var1);

    public static class Filter
    implements ChannelStateListener {
        ChannelState state;
        ChannelStateListener listener;

        @Override
        public void onChannelStateChanged(ChannelStateChange stateChange) {
            if (stateChange.current == this.state) {
                this.listener.onChannelStateChanged(stateChange);
            }
        }

        Filter(ChannelState state, ChannelStateListener listener) {
            this.state = state;
            this.listener = listener;
        }
    }

    public static class Multicaster
    extends io.ably.lib.util.Multicaster<ChannelStateListener>
    implements ChannelStateListener {
        public Multicaster() {
            super(new ChannelStateListener[0]);
        }

        @Override
        public void onChannelStateChanged(ChannelStateChange stateChange) {
            for (ChannelStateListener member : this.members) {
                try {
                    member.onChannelStateChanged(stateChange);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static class ChannelStateChange {
        public final ChannelEvent event;
        public final ChannelState current;
        public final ChannelState previous;
        public final ErrorInfo reason;
        public final boolean resumed;

        ChannelStateChange(ChannelState current, ChannelState previous, ErrorInfo reason, boolean resumed) {
            this.event = current.getChannelEvent();
            this.current = current;
            this.previous = previous;
            this.reason = reason;
            this.resumed = resumed;
        }

        private ChannelStateChange(ErrorInfo reason, boolean resumed) {
            this.event = ChannelEvent.update;
            this.current = this.previous = ChannelState.attached;
            this.reason = reason;
            this.resumed = resumed;
        }

        static ChannelStateChange createUpdateEvent(ErrorInfo reason, boolean resumed) {
            return new ChannelStateChange(reason, resumed);
        }
    }
}

