/*
 * Decompiled with CFR 0.152.
 */
package info.vividcode.android.cra.components;

import info.vividcode.android.cra.Component;
import info.vividcode.android.cra.ComponentsRecyclerAdapter;

public abstract class OffsettingBypassObserver
implements ComponentsRecyclerAdapter.ComponentObserver {
    private final ComponentsRecyclerAdapter.ComponentObservable mObservable;

    public OffsettingBypassObserver(ComponentsRecyclerAdapter.ComponentObservable observable) {
        this.mObservable = observable;
    }

    @Override
    public void onChanged(Component dc) {
        this.mObservable.notifyChanged();
    }

    protected abstract int calcOffsetCount(Component var1);

    @Override
    public void onItemRangeChanged(Component dc, int positionStart, int itemCount) {
        int offsetCount = this.calcOffsetCount(dc);
        this.mObservable.notifyItemRangeChanged(offsetCount + positionStart, itemCount);
    }

    @Override
    public void onItemRangeInserted(Component dc, int positionStart, int itemCount) {
        int offsetCount = this.calcOffsetCount(dc);
        this.mObservable.notifyItemRangeInserted(offsetCount + positionStart, itemCount);
    }

    @Override
    public void onItemRangeRemoved(Component dc, int positionStart, int itemCount) {
        int offsetCount = this.calcOffsetCount(dc);
        this.mObservable.notifyItemRangeRemoved(offsetCount + positionStart, itemCount);
    }

    @Override
    public void onItemMoved(Component dc, int fromPosition, int toPosition) {
        int offsetCount = this.calcOffsetCount(dc);
        this.mObservable.notifyItemMoved(offsetCount + fromPosition, offsetCount + toPosition);
    }
}

