package info.setmy.exceptions.web;

import info.setmy.exceptions.UncheckedException;
import info.setmy.models.web.WebError;

/**
 * Web layer exceptions
 *
 * @author <a href="mailto:imre.tabur@eesti.ee">Imre Tabur</a>
 */
public abstract class WebException extends UncheckedException {

    public abstract int getStatusCode();

    public WebException() {
        super();
    }

    public WebException(final String string) {
        super(string);
    }

    public WebException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public WebException(Throwable throwable) {
        super(throwable);
    }

    protected WebException(String string, Throwable throwable, boolean bln, boolean bln1) {
        super(string, throwable, bln, bln1);
    }

    public WebError getWebError() {
        return new WebError(getMessage(), getStatusCode());
    }
}
