/*
 * Decompiled with CFR 0.152.
 */
package picocli.codegen.annotation.processing;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Locale;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import picocli.CommandLine;
import picocli.codegen.annotation.processing.AbstractCommandSpecProcessor;
import picocli.codegen.annotation.processing.CompileTimeTypeInfo;
import picocli.codegen.annotation.processing.internal.GetterSetterMetaData;
import picocli.codegen.util.Assert;

class TypedMember
implements CommandLine.Model.IAnnotatedElement {
    final Element element;
    final String name;
    final CommandLine.Model.ITypeInfo typeInfo;
    final boolean hasInitialValue;
    final int position;
    private CommandLine.Model.IGetter getter;
    private CommandLine.Model.ISetter setter;

    static boolean isAnnotated(Element e) {
        return e.getAnnotation(CommandLine.Option.class) != null || e.getAnnotation(CommandLine.Parameters.class) != null || e.getAnnotation(CommandLine.ArgGroup.class) != null || e.getAnnotation(CommandLine.Unmatched.class) != null || e.getAnnotation(CommandLine.Mixin.class) != null || e.getAnnotation(CommandLine.Spec.class) != null || e.getAnnotation(CommandLine.ParentCommand.class) != null;
    }

    TypedMember(VariableElement variable, int position) {
        this.element = Assert.notNull(variable, "field");
        this.name = variable.getSimpleName().toString();
        this.hasInitialValue = variable.getConstantValue() != null;
        this.typeInfo = new CompileTimeTypeInfo(variable.asType());
        this.position = position;
        this.getter = new GetterSetterMetaData(this.element);
        this.setter = (GetterSetterMetaData)this.getter;
    }

    TypedMember(ExecutableElement method, AbstractCommandSpecProcessor processor) {
        boolean isSetter;
        this.element = Assert.notNull(method, "method");
        this.name = TypedMember.propertyName(method.getSimpleName().toString());
        this.position = -1;
        List<? extends TypeMirror> parameterTypes = ((ExecutableType)method.asType()).getParameterTypes();
        boolean isGetter = parameterTypes.isEmpty() && method.getReturnType().getKind() != TypeKind.VOID;
        boolean bl = isSetter = !parameterTypes.isEmpty();
        if (isSetter == isGetter) {
            processor.error(method, "Only getter or setter methods can be annotated with @Option, but %s is neither.", method.getSimpleName());
            isGetter = true;
        }
        if (isGetter) {
            this.hasInitialValue = true;
            this.typeInfo = new CompileTimeTypeInfo(method.getReturnType());
        } else {
            this.hasInitialValue = false;
            this.typeInfo = new CompileTimeTypeInfo(parameterTypes.get(0));
        }
        this.getter = new GetterSetterMetaData(this.element);
        this.setter = (GetterSetterMetaData)this.getter;
    }

    public Object userObject() {
        return this.element;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.element.getAnnotation(annotationClass);
    }

    public String getName() {
        return this.name;
    }

    public boolean isArgSpec() {
        return this.isOption() || this.isParameter() || this.isMethodParameter();
    }

    public boolean isOption() {
        return this.isAnnotationPresent(CommandLine.Option.class);
    }

    public boolean isParameter() {
        return this.isAnnotationPresent(CommandLine.Parameters.class);
    }

    public boolean isArgGroup() {
        return this.isAnnotationPresent(CommandLine.ArgGroup.class);
    }

    public boolean isMixin() {
        return this.isAnnotationPresent(CommandLine.Mixin.class);
    }

    public boolean isUnmatched() {
        return this.isAnnotationPresent(CommandLine.Unmatched.class);
    }

    public boolean isSpec() {
        return this.isAnnotationPresent(CommandLine.Spec.class);
    }

    public boolean isParentCommand() {
        return this.isAnnotationPresent(CommandLine.ParentCommand.class);
    }

    public boolean isMultiValue() {
        return this.getTypeInfo().isMultiValue();
    }

    public boolean isInteractive() {
        return this.isOption() && this.getAnnotation(CommandLine.Option.class).interactive() || this.isParameter() && this.getAnnotation(CommandLine.Parameters.class).interactive();
    }

    public CommandLine.Model.ITypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public CommandLine.Model.IGetter getter() {
        return this.getter;
    }

    public CommandLine.Model.ISetter setter() {
        return this.setter;
    }

    public String toString() {
        return this.element.toString();
    }

    public String getToString() {
        if (this.isMixin()) {
            return TypedMember.abbreviate("mixin from member " + this.toGenericString());
        }
        return String.valueOf((Object)this.element.getKind()).toLowerCase(Locale.ENGLISH) + " " + TypedMember.abbreviate(this.toGenericString());
    }

    String toGenericString() {
        return this.element.asType().toString() + " " + this.element.getEnclosingElement() + "." + this.element.getSimpleName();
    }

    public boolean hasInitialValue() {
        return this.hasInitialValue;
    }

    public boolean isMethodParameter() {
        return this.position >= 0;
    }

    public int getMethodParamPosition() {
        return this.position;
    }

    public CommandLine.Model.IScope scope() {
        return null;
    }

    public String getMixinName() {
        String annotationName = this.getAnnotation(CommandLine.Mixin.class).name();
        return TypedMember.empty(annotationName) ? this.getName() : annotationName;
    }

    static String propertyName(String methodName) {
        if (methodName.length() > 3 && (methodName.startsWith("get") || methodName.startsWith("set"))) {
            return TypedMember.decapitalize(methodName.substring(3));
        }
        return TypedMember.decapitalize(methodName);
    }

    private static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    static String abbreviate(String text) {
        return text.replace("private ", "").replace("protected ", "").replace("public ", "").replace("java.lang.", "");
    }

    static boolean empty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

