/*
 * Decompiled with CFR 0.152.
 */
package picocli.codegen.annotation.processing;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import picocli.CommandLine;
import picocli.codegen.AnnotatedCommandSourceGenerator;
import picocli.codegen.annotation.processing.AbstractCommandSpecProcessor;

public class AnnotatedCommandSourceGeneratorProcessor
extends AbstractCommandSpecProcessor {
    private static Logger logger = Logger.getLogger(AnnotatedCommandSourceGeneratorProcessor.class.getName());

    @Override
    protected boolean handleCommands(Map<Element, CommandLine.Model.CommandSpec> commands, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ArrayList<SourceUnit> list = new ArrayList<SourceUnit>();
        for (Map.Entry<Element, CommandLine.Model.CommandSpec> entry : commands.entrySet()) {
            SourceUnit sourceUnit = this.find(entry.getKey(), list);
            sourceUnit.commands.add(entry.getValue());
        }
        for (SourceUnit sourceUnit : list) {
            try {
                this.generateCode(sourceUnit);
            }
            catch (IOException e) {
                this.error(sourceUnit.topLevel, "Unable to generated code for %s: %s", sourceUnit.topLevel, e);
            }
        }
        return true;
    }

    private SourceUnit find(Element element, List<SourceUnit> list) {
        for (SourceUnit sourceUnit : list) {
            if (!sourceUnit.contains(element)) continue;
            return sourceUnit;
        }
        SourceUnit result = new SourceUnit(element);
        list.add(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateCode(SourceUnit sourceUnit) throws IOException {
        TypeElement typeElement = (TypeElement)sourceUnit.topLevel;
        int count = 0;
        for (CommandLine.Model.CommandSpec spec : sourceUnit.commandHierarchies()) {
            AnnotatedCommandSourceGenerator generator = new AnnotatedCommandSourceGenerator(spec);
            generator.setOutputPackage("generated." + generator.getOutputPackage());
            String unique = count == 0 ? "" : count + "";
            ++count;
            FileObject sourceFile = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, generator.getOutputPackage(), typeElement.getSimpleName() + unique + ".java", new Element[0]);
            Writer writer = null;
            try {
                writer = sourceFile.openWriter();
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                generator.writeTo(pw, "");
                pw.flush();
                writer.write(sw.toString());
                writer.flush();
            }
            finally {
                if (writer == null) continue;
                writer.close();
            }
        }
    }

    private Map<Element, CommandLine.Model.CommandSpec> removeNested(Map<Element, CommandLine.Model.CommandSpec> commands) {
        LinkedHashMap<Element, CommandLine.Model.CommandSpec> result = new LinkedHashMap<Element, CommandLine.Model.CommandSpec>();
        for (Map.Entry<Element, CommandLine.Model.CommandSpec> entry : commands.entrySet()) {
            CommandLine.Model.CommandSpec cmd = entry.getValue();
            Object var6_6 = null;
        }
        return result;
    }

    static class SourceUnit {
        String packageName;
        String className;
        Element topLevel;
        List<CommandLine.Model.CommandSpec> commands = new ArrayList<CommandLine.Model.CommandSpec>();

        public SourceUnit(Element element) {
            this.topLevel = SourceUnit.topLevel(element);
        }

        public boolean contains(Element element) {
            Element topLevelELement = SourceUnit.topLevel(element);
            return this.equals(topLevelELement, this.topLevel);
        }

        private boolean equals(Element topLevelELement, Element topLevel) {
            return topLevelELement.toString().equals(topLevel.toString());
        }

        static Element topLevel(Element element) {
            while (element.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
                element = element.getEnclosingElement();
            }
            return element;
        }

        public List<CommandLine.Model.CommandSpec> commandHierarchies() {
            ArrayList<CommandLine.Model.CommandSpec> result = new ArrayList<CommandLine.Model.CommandSpec>();
            for (CommandLine.Model.CommandSpec cmd : this.commands) {
                String excludeReason = null;
                for (CommandLine.Model.CommandSpec any : this.commands) {
                    if (cmd != any && AnnotatedCommandSourceGenerator.isNestedCommand(cmd, any)) {
                        excludeReason = "Excluding " + cmd + ": it is nested in " + any;
                        break;
                    }
                    if (!AnnotatedCommandSourceGenerator.isBuiltInMixin(cmd) && !AnnotatedCommandSourceGenerator.isBuiltInSubcommand(cmd)) continue;
                    excludeReason = "Excluding built-in " + cmd.userObject();
                    break;
                }
                if (excludeReason == null) {
                    result.add(cmd);
                    continue;
                }
                logger.info(excludeReason);
            }
            return result;
        }
    }
}

