/*
 * Decompiled with CFR 0.152.
 */
package picocli.codegen.annotation.processing;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import picocli.CommandLine;
import picocli.codegen.annotation.processing.ITypeMetaData;
import picocli.codegen.annotation.processing.JulLogFormatter;
import picocli.codegen.annotation.processing.internal.CompletionCandidatesMetaData;
import picocli.codegen.annotation.processing.internal.DefaultValueProviderMetaData;
import picocli.codegen.annotation.processing.internal.GetterSetterMetaData;
import picocli.codegen.annotation.processing.internal.TypeConverterMetaData;
import picocli.codegen.annotation.processing.internal.VersionProviderMetaData;
import picocli.codegen.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCommandSpecProcessor
extends AbstractProcessor {
    private static final String COMMAND_DEFAULT_NAME = "<main class>";
    private static Logger logger = Logger.getLogger(AbstractCommandSpecProcessor.class.getName());
    protected ProcessingEnvironment processingEnv;
    private static final String COMMAND_TYPE = CommandLine.Command.class.getName().replace('$', '.');
    static ConsoleHandler handler = new ConsoleHandler();

    public AbstractCommandSpecProcessor() {
        for (Handler h : Logger.getLogger("picocli.annotation.processing").getHandlers()) {
            Logger.getLogger("picocli.annotation.processing").removeHandler(h);
        }
        handler.setFormatter(new JulLogFormatter());
        handler.setLevel(Level.ALL);
        Logger.getLogger("picocli.annotation.processing").addHandler(handler);
        Logger.getLogger("picocli.annotation.processing").setLevel(Level.ALL);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        Set<String> result = super.getSupportedAnnotationTypes();
        if (!result.contains("picocli.*")) {
            result = new TreeSet<String>(result);
            result.add("picocli.*");
        }
        return result;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        CommandLine.Model.CommandSpec commandSpec;
        logger.info("Entered process, processingOver=" + roundEnv.processingOver());
        CommandLine.IFactory factory = null;
        LinkedHashMap<Element, CommandLine.Model.CommandSpec> commands = new LinkedHashMap<Element, CommandLine.Model.CommandSpec>();
        LinkedHashMap<TypeMirror, List<CommandLine.Model.CommandSpec>> commandTypes = new LinkedHashMap<TypeMirror, List<CommandLine.Model.CommandSpec>>();
        LinkedHashMap<Element, CommandLine.Model.OptionSpec.Builder> options = new LinkedHashMap<Element, CommandLine.Model.OptionSpec.Builder>();
        LinkedHashMap<Element, CommandLine.Model.PositionalParamSpec.Builder> parameters = new LinkedHashMap<Element, CommandLine.Model.PositionalParamSpec.Builder>();
        ArrayList<MixinInfo> mixinInfoList = new ArrayList<MixinInfo>();
        LinkedHashMap<Element, CommandLine.Model.IAnnotatedElement> parentCommands = new LinkedHashMap<Element, CommandLine.Model.IAnnotatedElement>();
        LinkedHashMap<Element, CommandLine.Model.IAnnotatedElement> specs = new LinkedHashMap<Element, CommandLine.Model.IAnnotatedElement>();
        LinkedHashMap<Element, CommandLine.Model.IAnnotatedElement> unmatched = new LinkedHashMap<Element, CommandLine.Model.IAnnotatedElement>();
        logger.fine("Building commands...");
        this.buildCommands(roundEnv, factory, commands, commandTypes, options, parameters);
        logger.fine("Building mixins...");
        this.buildMixins(roundEnv, factory, commands, mixinInfoList, commandTypes, options, parameters);
        logger.fine("Building options...");
        this.buildOptions(roundEnv, factory, options);
        logger.fine("Building parameters...");
        this.buildParameters(roundEnv, factory, parameters);
        logger.fine("Building parentCommands...");
        this.buildParentCommands(roundEnv, factory, parentCommands);
        logger.fine("Building specs...");
        this.buildSpecs(roundEnv, factory, specs);
        logger.fine("Building unmatched...");
        this.buildUnmatched(roundEnv, factory, unmatched);
        logger.fine("---------------------------");
        logger.fine("Known commands...");
        for (Map.Entry entry : commands.entrySet()) {
            logger.fine(String.format("%s has CommandSpec[name=%s]", entry.getKey(), ((CommandLine.Model.CommandSpec)entry.getValue()).name()));
        }
        logger.fine("Known mixins...");
        for (MixinInfo mixinInfo : mixinInfoList) {
            logger.fine(String.format("%s is mixin for %s", mixinInfo.mixin.userObject(), mixinInfo.mixee.userObject()));
        }
        for (Map.Entry entry : options.entrySet()) {
            commandSpec = this.getOrCreateCommandSpecForArg(entry, commands);
            logger.fine("Building OptionSpec for " + entry + " in spec " + commandSpec);
            commandSpec.addOption(((CommandLine.Model.OptionSpec.Builder)entry.getValue()).build());
        }
        for (Map.Entry entry : parameters.entrySet()) {
            commandSpec = this.getOrCreateCommandSpecForArg(entry, commands);
            logger.fine("Building PositionalParamSpec for " + entry);
            commandSpec.addPositional(((CommandLine.Model.PositionalParamSpec.Builder)entry.getValue()).build());
        }
        for (MixinInfo mixinInfo : mixinInfoList) {
            mixinInfo.addMixin();
        }
        logger.fine("Found annotations: " + annotations);
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(typeElement);
            logger.finest(annotatedElements + " is annotated with " + typeElement);
        }
        this.validateNoAnnotationsOnInterfaceField(roundEnv);
        this.validateInvalidCombination(roundEnv, CommandLine.Mixin.class, CommandLine.Option.class);
        this.validateInvalidCombination(roundEnv, CommandLine.Mixin.class, CommandLine.Parameters.class);
        this.validateInvalidCombination(roundEnv, CommandLine.Mixin.class, CommandLine.Unmatched.class);
        this.validateInvalidCombination(roundEnv, CommandLine.Mixin.class, CommandLine.Spec.class);
        this.validateInvalidCombination(roundEnv, CommandLine.Unmatched.class, CommandLine.Option.class);
        this.validateInvalidCombination(roundEnv, CommandLine.Unmatched.class, CommandLine.Parameters.class);
        this.validateInvalidCombination(roundEnv, CommandLine.Spec.class, CommandLine.Option.class);
        this.validateInvalidCombination(roundEnv, CommandLine.Spec.class, CommandLine.Parameters.class);
        this.validateInvalidCombination(roundEnv, CommandLine.Spec.class, CommandLine.Unmatched.class);
        this.validateInvalidCombination(roundEnv, CommandLine.Option.class, CommandLine.Parameters.class);
        return this.handleCommands(commands, annotations, roundEnv);
    }

    private void validateNoAnnotationsOnInterfaceField(RoundEnvironment roundEnv) {
        this.validateNoAnnotationsOnInterfaceField(roundEnv.getElementsAnnotatedWith(CommandLine.Option.class));
        this.validateNoAnnotationsOnInterfaceField(roundEnv.getElementsAnnotatedWith(CommandLine.Parameters.class));
        this.validateNoAnnotationsOnInterfaceField(roundEnv.getElementsAnnotatedWith(CommandLine.Mixin.class));
        this.validateNoAnnotationsOnInterfaceField(roundEnv.getElementsAnnotatedWith(CommandLine.ParentCommand.class));
        this.validateNoAnnotationsOnInterfaceField(roundEnv.getElementsAnnotatedWith(CommandLine.Spec.class));
        this.validateNoAnnotationsOnInterfaceField(roundEnv.getElementsAnnotatedWith(CommandLine.Unmatched.class));
    }

    private void validateNoAnnotationsOnInterfaceField(Set<? extends Element> all) {
        for (Element element : all) {
            if (element.getKind() != ElementKind.FIELD || element.getEnclosingElement().getKind() != ElementKind.INTERFACE) continue;
            this.error(element, "Invalid picocli annotation on interface field %s.%s", element.getEnclosingElement().toString(), element.getSimpleName());
        }
    }

    private <T1 extends Annotation, T2 extends Annotation> void validateInvalidCombination(RoundEnvironment roundEnv, Class<T1> c1, Class<T2> c2) {
        for (Element element : roundEnv.getElementsAnnotatedWith(c1)) {
            if (element.getAnnotation(c2) == null) continue;
            this.error(element, "%s cannot have both @%s and @%s annotations", element, c1.getCanonicalName(), c2.getCanonicalName());
        }
    }

    protected abstract boolean handleCommands(Map<Element, CommandLine.Model.CommandSpec> var1, Set<? extends TypeElement> var2, RoundEnvironment var3);

    private CommandLine.Model.CommandSpec getOrCreateCommandSpecForArg(Map.Entry<Element, ?> argElement, Map<Element, CommandLine.Model.CommandSpec> commands) {
        Element key = argElement.getKey().getEnclosingElement();
        CommandLine.Model.CommandSpec commandSpec = commands.get(key);
        if (commandSpec == null) {
            logger.fine("Element " + argElement.getKey() + " is enclosed by " + key + " which does not have a @Command annotation");
            commandSpec = CommandLine.Model.CommandSpec.forAnnotatedObjectLenient((Object)key);
            commands.put(key, commandSpec);
        }
        return commandSpec;
    }

    private void buildUnmatched(RoundEnvironment roundEnv, CommandLine.IFactory factory, Map<Element, CommandLine.Model.IAnnotatedElement> unmatched) {
        Set<? extends Element> explicitUnmatched = roundEnv.getElementsAnnotatedWith(CommandLine.Unmatched.class);
        for (Element element : explicitUnmatched) {
            this.debugElement(element, "@Unmatched");
            if (element.getKind() != ElementKind.FIELD && element.getKind() != ElementKind.METHOD && element.getKind() != ElementKind.PARAMETER) continue;
        }
    }

    private void buildSpecs(RoundEnvironment roundEnv, CommandLine.IFactory factory, Map<Element, CommandLine.Model.IAnnotatedElement> specs) {
        Set<? extends Element> explicitSpecs = roundEnv.getElementsAnnotatedWith(CommandLine.Spec.class);
        for (Element element : explicitSpecs) {
            this.debugElement(element, "@Spec");
            if (element.getKind() != ElementKind.FIELD && element.getKind() != ElementKind.METHOD && element.getKind() != ElementKind.PARAMETER) continue;
        }
    }

    private void buildMixins(RoundEnvironment roundEnv, CommandLine.IFactory factory, Map<Element, CommandLine.Model.CommandSpec> mixinsDeclared, List<MixinInfo> mixinInfoList, Map<TypeMirror, List<CommandLine.Model.CommandSpec>> commandTypes, Map<Element, CommandLine.Model.OptionSpec.Builder> options, Map<Element, CommandLine.Model.PositionalParamSpec.Builder> parameters) {
        Set<? extends Element> explicitMixins = roundEnv.getElementsAnnotatedWith(CommandLine.Mixin.class);
        for (Element element : explicitMixins) {
            if (element.asType().getKind() != TypeKind.DECLARED) {
                this.error(element, "@Mixin must have a declared type, not %s", element.asType());
                continue;
            }
            TypeElement type = (TypeElement)((DeclaredType)element.asType()).asElement();
            CommandLine.Model.CommandSpec mixin = this.buildCommand(type, factory, mixinsDeclared, commandTypes, options, parameters);
            logger.fine("Built mixin: " + mixin + " from " + element);
            if (!EnumSet.of(ElementKind.FIELD, ElementKind.PARAMETER).contains((Object)element.getKind())) continue;
            VariableElement variableElement = (VariableElement)element;
            String name = element.getAnnotation(CommandLine.Mixin.class).name();
            if (name.length() == 0) {
                name = variableElement.getSimpleName().toString();
            }
            Element targetType = element.getEnclosingElement();
            CommandLine.Model.CommandSpec mixee = this.buildCommand(targetType, factory, mixinsDeclared, commandTypes, options, parameters);
            mixinInfoList.add(new MixinInfo(mixee, name, mixin));
            logger.fine("Mixin name=" + name + ", target command=" + mixee.userObject());
        }
    }

    private void buildParentCommands(RoundEnvironment roundEnv, CommandLine.IFactory factory, Map<Element, CommandLine.Model.IAnnotatedElement> parentCommands) {
        Set<? extends Element> explicitParentCommands = roundEnv.getElementsAnnotatedWith(CommandLine.ParentCommand.class);
        for (Element element : explicitParentCommands) {
            this.debugElement(element, "@ParentCommand");
            if (element.getKind() != ElementKind.FIELD && element.getKind() != ElementKind.METHOD && element.getKind() != ElementKind.PARAMETER) continue;
        }
    }

    private void buildOptions(RoundEnvironment roundEnv, CommandLine.IFactory factory, Map<Element, CommandLine.Model.OptionSpec.Builder> options) {
        Set<? extends Element> explicitOptions = roundEnv.getElementsAnnotatedWith(CommandLine.Option.class);
        for (Element element : explicitOptions) {
            TypedMember typedMember;
            if (options.containsKey(element) || (typedMember = this.extractTypedMember(element, "@Option")) == null) continue;
            CommandLine.Model.OptionSpec.Builder builder = CommandLine.Model.OptionSpec.builder((CommandLine.Model.IAnnotatedElement)typedMember, (CommandLine.IFactory)factory);
            builder.completionCandidates(this.extractCompletionCandidates(element, element.getAnnotationMirrors()));
            builder.converters((CommandLine.ITypeConverter[])this.extractConverters(element, element.getAnnotationMirrors()));
            options.put(element, builder);
        }
    }

    private void buildParameters(RoundEnvironment roundEnv, CommandLine.IFactory factory, Map<Element, CommandLine.Model.PositionalParamSpec.Builder> parameters) {
        Set<? extends Element> explicitParameters = roundEnv.getElementsAnnotatedWith(CommandLine.Parameters.class);
        for (Element element : explicitParameters) {
            TypedMember typedMember;
            if (parameters.containsKey(element) || (typedMember = this.extractTypedMember(element, "@Parameters")) == null) continue;
            CommandLine.Model.PositionalParamSpec.Builder builder = CommandLine.Model.PositionalParamSpec.builder((CommandLine.Model.IAnnotatedElement)typedMember, (CommandLine.IFactory)factory);
            builder.completionCandidates(this.extractCompletionCandidates(element, element.getAnnotationMirrors()));
            builder.converters((CommandLine.ITypeConverter[])this.extractConverters(element, element.getAnnotationMirrors()));
            parameters.put(element, builder);
        }
    }

    private TypedMember extractTypedMember(Element element, String annotation) {
        this.debugElement(element, annotation);
        if (element.getKind() == ElementKind.FIELD) {
            return new TypedMember((VariableElement)element, -1);
        }
        if (element.getKind() == ElementKind.METHOD) {
            return new TypedMember((ExecutableElement)element);
        }
        this.error(element, "Cannot only process %s annotations on fields, methods and method parameters, not on %s", new Object[]{annotation, element.getKind()});
        return null;
    }

    private void buildCommands(RoundEnvironment roundEnv, CommandLine.IFactory factory, Map<Element, CommandLine.Model.CommandSpec> commands, Map<TypeMirror, List<CommandLine.Model.CommandSpec>> commandTypes, Map<Element, CommandLine.Model.OptionSpec.Builder> options, Map<Element, CommandLine.Model.PositionalParamSpec.Builder> parameters) {
        Set<? extends Element> explicitCommands = roundEnv.getElementsAnnotatedWith(CommandLine.Command.class);
        for (Element element : explicitCommands) {
            this.buildCommand(element, factory, commands, commandTypes, options, parameters);
        }
    }

    private CommandLine.Model.CommandSpec buildCommand(Element element, CommandLine.IFactory factory, Map<Element, CommandLine.Model.CommandSpec> commands, Map<TypeMirror, List<CommandLine.Model.CommandSpec>> commandTypes, Map<Element, CommandLine.Model.OptionSpec.Builder> options, Map<Element, CommandLine.Model.PositionalParamSpec.Builder> parameters) {
        String commandClassName = element.asType().toString();
        this.debugElement(element, "@Command");
        CommandLine.Model.CommandSpec result = commands.get(element);
        if (result != null) {
            return result;
        }
        result = CommandLine.Model.CommandSpec.wrapWithoutInspection((Object)element);
        result.withToString(commandClassName);
        commands.put(element, result);
        boolean hasCommandAnnotation = false;
        boolean mixinStandardHelpOptions = false;
        if (element.getKind() == ElementKind.CLASS) {
            TypeElement superClass = AbstractCommandSpecProcessor.superClassFor((TypeElement)element);
            this.debugElement(superClass, "  super");
            TypeElement typeElement = (TypeElement)element;
            Stack<TypeElement> hierarchy = new Stack<TypeElement>();
            int count = 0;
            while (typeElement != null && count++ < 20) {
                logger.fine("Adding to type hierarchy: " + typeElement);
                hierarchy.add(typeElement);
                typeElement = AbstractCommandSpecProcessor.superClassFor(typeElement);
            }
            while (!hierarchy.isEmpty()) {
                List<CommandLine.Model.CommandSpec> forSubclass;
                typeElement = (TypeElement)hierarchy.pop();
                CommandLine.Command cmd = typeElement.getAnnotation(CommandLine.Command.class);
                if (cmd != null) {
                    this.updateCommandAttributes(result, cmd);
                    List<CommandLine.Model.CommandSpec> subcommands = this.findSubcommands(typeElement.getAnnotationMirrors(), factory, commands, commandTypes, options, parameters);
                    for (CommandLine.Model.CommandSpec sub : subcommands) {
                        result.addSubcommand(sub.name(), sub);
                    }
                    hasCommandAnnotation = true;
                }
                if ((forSubclass = commandTypes.get(typeElement.asType())) == null) {
                    forSubclass = new ArrayList<CommandLine.Model.CommandSpec>();
                    commandTypes.put(typeElement.asType(), forSubclass);
                }
                forSubclass.add(result);
                if (cmd == null) continue;
                mixinStandardHelpOptions |= cmd.mixinStandardHelpOptions();
            }
            result.mixinStandardHelpOptions(mixinStandardHelpOptions);
        } else if (element.getKind() == ElementKind.METHOD) {
            Element cls;
            ExecutableElement method = (ExecutableElement)element;
            this.debugMethod(method);
            CommandLine.Command cmd = method.getAnnotation(CommandLine.Command.class);
            this.updateCommandAttributes(result, cmd);
            result.setAddMethodSubcommands(Boolean.valueOf(false));
            result.withToString(commandClassName + "." + method.getSimpleName());
            if (result.name().equals(COMMAND_DEFAULT_NAME)) {
                result.name(method.getSimpleName().toString());
            }
            if ((cls = method.getEnclosingElement()).getAnnotation(CommandLine.Command.class) != null && cls.getAnnotation(CommandLine.Command.class).addMethodSubcommands()) {
                CommandLine.Model.CommandSpec commandSpec = this.buildCommand(cls, factory, commands, commandTypes, options, parameters);
                commandSpec.addSubcommand(result.name(), result);
            }
            hasCommandAnnotation = true;
            result.mixinStandardHelpOptions(method.getAnnotation(CommandLine.Command.class).mixinStandardHelpOptions());
            this.buildOptionsAndPositionalsFromMethodParameters(method, result, factory, options, parameters);
        }
        logger.fine(String.format("CommandSpec[name=%s] built for %s", result.name(), element));
        return result;
    }

    private void updateCommandAttributes(CommandLine.Model.CommandSpec result, CommandLine.Command cmd) {
        block5: {
            ITypeMetaData provider;
            block4: {
                result.updateCommandAttributes(cmd, null);
                try {
                    cmd.versionProvider();
                }
                catch (MirroredTypeException ex) {
                    provider = new VersionProviderMetaData(ex.getTypeMirror());
                    if (((VersionProviderMetaData)provider).isDefault()) break block4;
                    result.versionProvider((CommandLine.IVersionProvider)provider);
                }
            }
            try {
                cmd.defaultValueProvider();
            }
            catch (MirroredTypeException ex) {
                provider = new DefaultValueProviderMetaData(ex.getTypeMirror());
                if (((DefaultValueProviderMetaData)provider).isDefault()) break block5;
                result.defaultValueProvider((CommandLine.IDefaultValueProvider)provider);
            }
        }
    }

    private List<CommandLine.Model.CommandSpec> findSubcommands(List<? extends AnnotationMirror> annotationMirrors, CommandLine.IFactory factory, Map<Element, CommandLine.Model.CommandSpec> commands, Map<TypeMirror, List<CommandLine.Model.CommandSpec>> commandTypes, Map<Element, CommandLine.Model.OptionSpec.Builder> options, Map<Element, CommandLine.Model.PositionalParamSpec.Builder> parameters) {
        ArrayList<CommandLine.Model.CommandSpec> result = new ArrayList<CommandLine.Model.CommandSpec>();
        block0: for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationMirror.getAnnotationType().toString().equals(COMMAND_TYPE)) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"subcommands".equals(entry.getKey().getSimpleName().toString())) continue;
                AnnotationValue list = entry.getValue();
                List typeMirrors = (List)list.getValue();
                this.registerSubcommands(typeMirrors, result, factory, commands, commandTypes, options, parameters);
                continue block0;
            }
        }
        return result;
    }

    private void registerSubcommands(List<AnnotationValue> typeMirrors, List<CommandLine.Model.CommandSpec> result, CommandLine.IFactory factory, Map<Element, CommandLine.Model.CommandSpec> commands, Map<TypeMirror, List<CommandLine.Model.CommandSpec>> commandTypes, Map<Element, CommandLine.Model.OptionSpec.Builder> options, Map<Element, CommandLine.Model.PositionalParamSpec.Builder> parameters) {
        for (AnnotationValue typeMirror : typeMirrors) {
            TypeElement subcommandElement = this.processingEnv.getElementUtils().getTypeElement(typeMirror.getValue().toString().replace('$', '.'));
            logger.fine("Processing subcommand: " + subcommandElement);
            if (!this.isValidSubcommandHasNameAttribute(subcommandElement)) continue;
            CommandLine.Model.CommandSpec commandSpec = this.buildCommand(subcommandElement, factory, commands, commandTypes, options, parameters);
            result.add(commandSpec);
        }
    }

    private boolean isValidSubcommandHasNameAttribute(Element subcommandElement) {
        CommandLine.Command annotation = subcommandElement.getAnnotation(CommandLine.Command.class);
        if (annotation == null) {
            this.error(subcommandElement, "Subcommand is missing @Command annotation with a name attribute", new Object[0]);
            return false;
        }
        if (COMMAND_DEFAULT_NAME.equals(annotation.name())) {
            this.error(subcommandElement, "Subcommand @Command annotation should have a name attribute", new Object[0]);
            return false;
        }
        return true;
    }

    private void buildOptionsAndPositionalsFromMethodParameters(ExecutableElement method, CommandLine.Model.CommandSpec result, CommandLine.IFactory factory, Map<Element, CommandLine.Model.OptionSpec.Builder> options, Map<Element, CommandLine.Model.PositionalParamSpec.Builder> parameters) {
        List<? extends VariableElement> params = method.getParameters();
        int position = -1;
        for (VariableElement variableElement : params) {
            CommandLine.Model.OptionSpec.Builder builder;
            TypedMember typedMember;
            boolean isMixin;
            boolean isOption = variableElement.getAnnotation(CommandLine.Option.class) != null;
            boolean isPositional = variableElement.getAnnotation(CommandLine.Parameters.class) != null;
            boolean bl = isMixin = variableElement.getAnnotation(CommandLine.Mixin.class) != null;
            if (isOption && isPositional) {
                this.error(variableElement, "Method %s parameter %s should not have both @Option and @Parameters annotation", method.getSimpleName(), variableElement.getSimpleName());
            } else if ((isOption || isPositional) && isMixin) {
                this.error(variableElement, "Method %s parameter %s should not have a @Mixin annotation as well as an @Option or @Parameters annotation", method.getSimpleName(), variableElement.getSimpleName());
            }
            if (isOption) {
                typedMember = new TypedMember(variableElement, -1);
                builder = CommandLine.Model.OptionSpec.builder((CommandLine.Model.IAnnotatedElement)typedMember, (CommandLine.IFactory)factory);
                builder.completionCandidates(this.extractCompletionCandidates(variableElement, variableElement.getAnnotationMirrors()));
                builder.converters((CommandLine.ITypeConverter[])this.extractConverters(variableElement, variableElement.getAnnotationMirrors()));
                options.put(variableElement, builder);
                continue;
            }
            if (isMixin) continue;
            typedMember = new TypedMember(variableElement, ++position);
            builder = CommandLine.Model.PositionalParamSpec.builder((CommandLine.Model.IAnnotatedElement)typedMember, (CommandLine.IFactory)factory);
            builder.completionCandidates(this.extractCompletionCandidates(variableElement, variableElement.getAnnotationMirrors()));
            builder.converters((CommandLine.ITypeConverter[])this.extractConverters(variableElement, variableElement.getAnnotationMirrors()));
            parameters.put(variableElement, (CommandLine.Model.PositionalParamSpec.Builder)builder);
        }
    }

    private Iterable<String> extractCompletionCandidates(Element element, List<? extends AnnotationMirror> annotationMirrors) {
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (!this.isOption(annotationType) && !this.isParameter(annotationType)) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
            for (ExecutableElement executableElement : elementValues.keySet()) {
                if (!"completionCandidates".equals(executableElement.getSimpleName().toString())) continue;
                AnnotationValue typeMirror = elementValues.get(executableElement);
                return new CompletionCandidatesMetaData((TypeMirror)((Object)typeMirror));
            }
        }
        return null;
    }

    private TypeConverterMetaData[] extractConverters(Element element, List<? extends AnnotationMirror> annotationMirrors) {
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (!this.isOption(annotationType) && !this.isParameter(annotationType)) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
            for (ExecutableElement executableElement : elementValues.keySet()) {
                if (!"converter".equals(executableElement.getSimpleName().toString())) continue;
                AnnotationValue list = elementValues.get(executableElement);
                List typeMirrors = (List)list.getValue();
                ArrayList<TypeConverterMetaData> result = new ArrayList<TypeConverterMetaData>();
                for (AnnotationValue annotationValue : typeMirrors) {
                    result.add(new TypeConverterMetaData((TypeMirror)((Object)annotationValue)));
                }
                return result.toArray(new TypeConverterMetaData[0]);
            }
        }
        return new TypeConverterMetaData[0];
    }

    private boolean isOption(DeclaredType annotationType) {
        return CommandLine.Option.class.getName().equals(annotationType.toString());
    }

    private boolean isParameter(DeclaredType annotationType) {
        return CommandLine.Parameters.class.getName().equals(annotationType.toString());
    }

    private void debugMethod(ExecutableElement method) {
        logger.finest(String.format("  method: simpleName=%s, asType=%s, varargs=%s, returnType=%s, enclosingElement=%s, params=%s, typeParams=%s", method.getSimpleName(), method.asType(), method.isVarArgs(), method.getReturnType(), method.getEnclosingElement(), method.getParameters(), method.getTypeParameters()));
        for (VariableElement variableElement : method.getParameters()) {
            logger.finest(String.format("    variable: name=%s, annotationMirrors=%s, @Option=%s, @Parameters=%s", variableElement.getSimpleName(), variableElement.getAnnotationMirrors(), variableElement.getAnnotation(CommandLine.Option.class), variableElement.getAnnotation(CommandLine.Parameters.class)));
        }
    }

    private void debugElement(Element element, String s) {
        logger.finest(String.format(s + ": kind=%s, cls=%s, simpleName=%s, type=%s, typeKind=%s, enclosed=%s, enclosing=%s", new Object[]{element.getKind(), element.getClass().getName(), element.getSimpleName(), element.asType(), element.asType().getKind(), element.getEnclosedElements(), element.getEnclosingElement()}));
        TypeMirror typeMirror = element.asType();
        if (element.getKind() == ElementKind.ENUM) {
            for (Element element2 : element.getEnclosedElements()) {
                this.debugElement(element2, s + "  ");
            }
        } else {
            this.debugType(typeMirror, element, s + "  ");
        }
    }

    private void debugType(TypeMirror typeMirror, Element element, String indent) {
        if (indent.length() > 20) {
            return;
        }
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            logger.finest(String.format("%stype=%s, asElement=%s, (elementKind=%s, elementClass=%s), typeArgs=%s, enclosing=%s", new Object[]{indent, declaredType, declaredType.asElement(), declaredType.asElement().getKind(), declaredType.asElement().getClass(), declaredType.getTypeArguments(), declaredType.getEnclosingType()}));
            for (TypeMirror typeMirror2 : declaredType.getTypeArguments()) {
                if (typeMirror2.equals(typeMirror)) continue;
                this.debugType(typeMirror2, element, indent + "  ");
            }
            if (declaredType.asElement().getKind() == ElementKind.ENUM && !element.equals(declaredType.asElement())) {
                this.debugElement(declaredType.asElement(), indent + "  --> ");
            }
        } else if (typeMirror.getKind() == TypeKind.EXECUTABLE) {
            ExecutableType type = (ExecutableType)typeMirror;
            logger.finest(String.format("%stype=%s, typeArgs=%s, paramTypes=%s, returnType=%s", indent, type, type.getTypeVariables(), type.getParameterTypes(), type.getReturnType()));
            for (TypeMirror typeMirror3 : type.getParameterTypes()) {
                if (typeMirror3.equals(typeMirror)) continue;
                this.debugType(typeMirror3, element, indent + "  ");
            }
        } else {
            logger.finest(String.format("%s%s %s is of kind=%s", new Object[]{indent, typeMirror, element.getSimpleName(), typeMirror.getKind()}));
        }
    }

    static TypeElement superClassFor(TypeElement element) {
        TypeMirror superclass = element.getSuperclass();
        if (superclass.getKind() == TypeKind.NONE) {
            return null;
        }
        logger.finest(String.format("Superclass of %s is %s (of kind %s)", new Object[]{element, superclass, superclass.getKind()}));
        DeclaredType kind = (DeclaredType)superclass;
        return (TypeElement)kind.asElement();
    }

    void error(Element e, String msg, Object ... args) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NullFactory
    implements CommandLine.IFactory {
        NullFactory() {
        }

        public <K> K create(Class<K> cls) throws Exception {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TypedMember
    implements CommandLine.Model.IAnnotatedElement {
        final Element element;
        final String name;
        final CommandLine.Model.ITypeInfo typeInfo;
        final boolean hasInitialValue;
        final int position;
        private CommandLine.Model.IGetter getter;
        private CommandLine.Model.ISetter setter;

        static boolean isAnnotated(Element e) {
            return e.getAnnotation(CommandLine.Option.class) == null || e.getAnnotation(CommandLine.Parameters.class) == null || e.getAnnotation(CommandLine.ArgGroup.class) == null || e.getAnnotation(CommandLine.Unmatched.class) == null || e.getAnnotation(CommandLine.Mixin.class) == null || e.getAnnotation(CommandLine.Spec.class) == null || e.getAnnotation(CommandLine.ParentCommand.class) == null;
        }

        TypedMember(VariableElement variable, int position) {
            this.element = Assert.notNull(variable, "field");
            this.name = variable.getSimpleName().toString();
            this.hasInitialValue = variable.getConstantValue() != null;
            this.typeInfo = new CompileTimeTypeInfo(variable.asType());
            this.position = position;
            this.getter = new GetterSetterMetaData(this.element);
            this.setter = (GetterSetterMetaData)this.getter;
        }

        private TypedMember(ExecutableElement method) {
            boolean isSetter;
            this.element = Assert.notNull(method, "method");
            this.name = TypedMember.propertyName(method.getSimpleName().toString());
            this.position = -1;
            List<? extends TypeMirror> parameterTypes = ((ExecutableType)method.asType()).getParameterTypes();
            boolean isGetter = parameterTypes.isEmpty() && method.getReturnType().getKind() != TypeKind.VOID;
            boolean bl = isSetter = !parameterTypes.isEmpty();
            if (isSetter == isGetter) {
                throw new CommandLine.InitializationException("Invalid method, must be either getter or setter: " + method);
            }
            if (isGetter) {
                this.hasInitialValue = true;
                this.typeInfo = new CompileTimeTypeInfo(method.getReturnType());
            } else {
                this.hasInitialValue = false;
                this.typeInfo = new CompileTimeTypeInfo(parameterTypes.get(0));
            }
            this.getter = new GetterSetterMetaData(this.element);
            this.setter = (GetterSetterMetaData)this.getter;
        }

        public Object userObject() {
            return this.element;
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            return this.getAnnotation(annotationClass) != null;
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return this.element.getAnnotation(annotationClass);
        }

        public String getName() {
            return this.name;
        }

        public boolean isArgSpec() {
            return this.isOption() || this.isParameter() || this.isMethodParameter();
        }

        public boolean isOption() {
            return this.isAnnotationPresent(CommandLine.Option.class);
        }

        public boolean isParameter() {
            return this.isAnnotationPresent(CommandLine.Parameters.class);
        }

        public boolean isArgGroup() {
            return this.isAnnotationPresent(CommandLine.ArgGroup.class);
        }

        public boolean isMixin() {
            return this.isAnnotationPresent(CommandLine.Mixin.class);
        }

        public boolean isUnmatched() {
            return this.isAnnotationPresent(CommandLine.Unmatched.class);
        }

        public boolean isInjectSpec() {
            return this.isAnnotationPresent(CommandLine.Spec.class);
        }

        public boolean isMultiValue() {
            return this.getTypeInfo().isMultiValue();
        }

        public CommandLine.Model.ITypeInfo getTypeInfo() {
            return this.typeInfo;
        }

        public CommandLine.Model.IGetter getter() {
            return this.getter;
        }

        public CommandLine.Model.ISetter setter() {
            return this.setter;
        }

        public String toString() {
            return this.element.toString();
        }

        public String getToString() {
            if (this.isMixin()) {
                return TypedMember.abbreviate("mixin from member " + this.toGenericString());
            }
            return (Object)((Object)this.element.getKind()) + " " + TypedMember.abbreviate(this.toGenericString());
        }

        String toGenericString() {
            return this.element.asType().toString() + this.element.getEnclosingElement() + "." + this.element.getSimpleName();
        }

        public boolean hasInitialValue() {
            return this.hasInitialValue;
        }

        public boolean isMethodParameter() {
            return this.position >= 0;
        }

        public int getMethodParamPosition() {
            return this.position;
        }

        public CommandLine.Model.IScope scope() {
            return null;
        }

        public String getMixinName() {
            String annotationName = this.getAnnotation(CommandLine.Mixin.class).name();
            return TypedMember.empty(annotationName) ? this.getName() : annotationName;
        }

        static String propertyName(String methodName) {
            if (methodName.length() > 3 && (methodName.startsWith("get") || methodName.startsWith("set"))) {
                return TypedMember.decapitalize(methodName.substring(3));
            }
            return TypedMember.decapitalize(methodName);
        }

        private static String decapitalize(String name) {
            if (name == null || name.length() == 0) {
                return name;
            }
            char[] chars = name.toCharArray();
            chars[0] = Character.toLowerCase(chars[0]);
            return new String(chars);
        }

        static String abbreviate(String text) {
            return text.replace("private ", "").replace("protected ", "").replace("public ", "").replace("java.lang.", "");
        }

        static boolean empty(String str) {
            return str == null || str.trim().length() == 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CompileTimeTypeInfo
    implements CommandLine.Model.ITypeInfo {
        private static Logger logger = Logger.getLogger(CompileTimeTypeInfo.class.getName());
        private static final EnumSet<TypeKind> PRIMITIVES = EnumSet.of(TypeKind.BYTE, new TypeKind[]{TypeKind.BOOLEAN, TypeKind.CHAR, TypeKind.DOUBLE, TypeKind.FLOAT, TypeKind.INT, TypeKind.LONG, TypeKind.SHORT});
        final TypeMirror typeMirror;
        final List<? extends TypeMirror> auxTypeMirrors;
        final List<String> actualGenericTypeArguments;
        final TypeElement typeElement;
        final boolean isCollection;
        final boolean isMap;

        public CompileTimeTypeInfo(TypeMirror asType) {
            this.typeMirror = asType;
            List<TypeMirror> aux = Arrays.asList(this.typeMirror);
            TypeElement tempTypeElement = null;
            boolean collection = false;
            boolean map = false;
            if (this.typeMirror.getKind() == TypeKind.DECLARED) {
                logger.finest("CompileTimeTypeInfo DECLARED typeMirror " + this.typeMirror);
                Element element = ((DeclaredType)this.typeMirror).asElement();
                if (element.getKind().isClass() || element.getKind().isInterface()) {
                    tempTypeElement = (TypeElement)element;
                    logger.finest("element is class or interface " + tempTypeElement);
                    map = CompileTimeTypeInfo.find("java.util.Map", tempTypeElement);
                    collection = !map && CompileTimeTypeInfo.find("java.util.Collection", tempTypeElement);
                }
                aux = ((DeclaredType)this.typeMirror).getTypeArguments();
                this.actualGenericTypeArguments = new ArrayList<String>();
                for (TypeMirror typeMirror : aux) {
                    this.actualGenericTypeArguments.add(typeMirror.toString());
                }
                logger.finest("aux (type args): " + aux);
                if (aux.isEmpty()) {
                    if (map || collection) {
                        aux = Arrays.asList(this.createStringTypeMirror(), this.createStringTypeMirror());
                        logger.finest("fixed aux (for multi type): " + aux);
                    } else {
                        aux = Arrays.asList(this.typeMirror);
                        logger.finest("fixed aux (for single type): " + aux);
                    }
                }
            } else if (this.typeMirror.getKind() == TypeKind.ARRAY) {
                aux = Arrays.asList(((ArrayType)this.typeMirror).getComponentType());
                this.actualGenericTypeArguments = Arrays.asList(aux.get(0).toString());
            } else {
                this.actualGenericTypeArguments = Collections.emptyList();
            }
            this.auxTypeMirrors = aux;
            this.typeElement = tempTypeElement;
            this.isCollection = collection;
            this.isMap = map;
        }

        private TypeMirror createStringTypeMirror() {
            TypeElement element = this.typeElement;
            while (element.getSuperclass().getKind() != TypeKind.NONE) {
                logger.finest("finding toString in " + element);
                element = (TypeElement)((DeclaredType)element.getSuperclass()).asElement();
            }
            for (Element element2 : this.typeElement.getEnclosedElements()) {
                ExecutableElement method;
                if (element2.getKind() != ElementKind.METHOD || !(method = (ExecutableElement)element2).getSimpleName().contentEquals("toString")) continue;
                return method.getReturnType();
            }
            throw new IllegalStateException("Cannot find toString method in Object");
        }

        private static boolean find(String interfaceName, TypeElement typeElement) {
            return CompileTimeTypeInfo.find(interfaceName, typeElement, new HashSet<Element>());
        }

        private static boolean find(String interfaceName, TypeElement typeElement, Set<Element> visited) {
            if (visited.contains(typeElement)) {
                return false;
            }
            visited.add(typeElement);
            if (typeElement.getQualifiedName().contentEquals(interfaceName)) {
                return true;
            }
            for (TypeMirror typeMirror : typeElement.getInterfaces()) {
                if (!CompileTimeTypeInfo.find(interfaceName, (TypeElement)((DeclaredType)typeMirror).asElement())) continue;
                return true;
            }
            while (typeElement.getSuperclass().getKind() != TypeKind.NONE) {
                if (!CompileTimeTypeInfo.find(interfaceName, typeElement = (TypeElement)((DeclaredType)typeElement.getSuperclass()).asElement())) continue;
                return true;
            }
            return false;
        }

        public List<CommandLine.Model.ITypeInfo> getAuxiliaryTypeInfos() {
            if (!this.isMultiValue()) {
                logger.fine("getAuxiliaryTypeInfos (non-multi) returning new list with this");
                return Arrays.asList(this);
            }
            ArrayList<CommandLine.Model.ITypeInfo> result = new ArrayList<CommandLine.Model.ITypeInfo>();
            for (TypeMirror typeMirror : this.auxTypeMirrors) {
                result.add(new CompileTimeTypeInfo(typeMirror));
            }
            logger.fine("getAuxiliaryTypeInfos (multi) returning list " + result);
            return result;
        }

        public List<String> getActualGenericTypeArguments() {
            return this.actualGenericTypeArguments;
        }

        public boolean isBoolean() {
            TypeMirror type = this.auxTypeMirrors.get(0);
            return type.getKind() == TypeKind.BOOLEAN || "java.lang.Boolean".equals(type.toString());
        }

        public boolean isMultiValue() {
            return this.isArray() || this.isCollection() || this.isMap();
        }

        public boolean isArray() {
            return this.typeMirror.getKind() == TypeKind.ARRAY;
        }

        public boolean isCollection() {
            return this.isCollection;
        }

        public boolean isMap() {
            return this.isMap;
        }

        public boolean isEnum() {
            TypeMirror type = this.auxTypeMirrors.get(0);
            return type.getKind() == TypeKind.DECLARED && ((DeclaredType)type).asElement().getKind() == ElementKind.ENUM;
        }

        public List<String> getEnumConstantNames() {
            if (!this.isEnum()) {
                return Collections.emptyList();
            }
            ArrayList<String> result = new ArrayList<String>();
            TypeMirror type = this.auxTypeMirrors.get(0);
            List<? extends Element> enclosed = ((DeclaredType)type).asElement().getEnclosedElements();
            for (Element element : enclosed) {
                if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
                result.add(element.toString());
            }
            return result;
        }

        public String getClassName() {
            return this.typeElement == null ? this.typeMirror.toString() : this.typeElement.getQualifiedName().toString();
        }

        public String getClassSimpleName() {
            return this.typeElement == null ? this.typeMirror.toString() : this.typeElement.getSimpleName().toString();
        }

        public Class<?> getType() {
            return null;
        }

        public Class<?>[] getAuxiliaryTypes() {
            return new Class[0];
        }

        public String toString() {
            return String.format("CompileTimeTypeInfo(%s, aux=%s, collection=%s, map=%s)", this.typeMirror, Arrays.toString(this.auxTypeMirrors.toArray()), this.isCollection, this.isMap);
        }
    }

    private static class MixinInfo {
        private final CommandLine.Model.CommandSpec mixee;
        private final String name;
        private final CommandLine.Model.CommandSpec mixin;

        MixinInfo(CommandLine.Model.CommandSpec mixee, String name, CommandLine.Model.CommandSpec mixin) {
            this.mixee = mixee;
            this.name = name;
            this.mixin = mixin;
        }

        void addMixin() {
            logger.fine(String.format("Adding mixin %s to %s", this.mixin.name(), this.mixee.name()));
            this.mixee.addMixin(this.name, this.mixin);
        }
    }
}

