/*
 * Decompiled with CFR 0.152.
 */
package info.rvin.flexmojos.utilities;

import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileConfigurationLoader {
    public static String getCompilerPluginSetting(MavenProject project, String optionName) {
        Xpp3Dom value = CompileConfigurationLoader.getCompilerPluginConfiguration(project, optionName);
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public static Xpp3Dom getCompilerPluginConfiguration(MavenProject project, String optionName) {
        Xpp3Dom value = CompileConfigurationLoader.findCompilerPluginSettingInPlugins(project.getModel().getBuild().getPlugins(), optionName);
        if (value == null && project.getModel().getBuild().getPluginManagement() != null) {
            value = CompileConfigurationLoader.findCompilerPluginSettingInPlugins(project.getModel().getBuild().getPluginManagement().getPlugins(), optionName);
        }
        return value;
    }

    private static Xpp3Dom findCompilerPluginSettingInPlugins(List<Plugin> plugins, String optionName) {
        for (Plugin plugin : plugins) {
            if (!plugin.getArtifactId().equals("flex-compiler-mojo")) continue;
            Xpp3Dom o = (Xpp3Dom)plugin.getConfiguration();
            Xpp3Dom value = null;
            if (o != null && o.getChild(optionName) != null) {
                value = o.getChild(optionName);
            }
            List executions = plugin.getExecutions();
            for (PluginExecution execution : executions) {
                o = (Xpp3Dom)execution.getConfiguration();
                if (o == null || o.getChild(optionName) == null) continue;
                value = o.getChild(optionName);
            }
            return value;
        }
        return null;
    }

    public static String[] getCompilerPluginSettings(MavenProject project, String optionName) {
        Xpp3Dom value = CompileConfigurationLoader.getCompilerPluginConfiguration(project, optionName);
        if (value == null) {
            return null;
        }
        Xpp3Dom[] children = value.getChildren();
        String[] values = new String[children.length];
        for (int i = 0; i < children.length; ++i) {
            Xpp3Dom child = children[i];
            values[i] = child.getValue();
        }
        return values;
    }
}

