/*
 * Decompiled with CFR 0.152.
 */
package info.flexmojos.optimizer;

import eu.cedarsoft.utils.ZipExtractor;
import flex2.compiler.swc.Digest;
import flex2.compiler.swc.Swc;
import flex2.compiler.swc.SwcCache;
import flex2.compiler.swc.SwcGroup;
import flex2.tools.API;
import info.rvin.flexmojos.utilities.MavenUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

public class OptimizerMojo
extends AbstractMojo {
    protected MavenProject project;
    protected Build build;
    protected MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Flex-mojos " + MavenUtils.getFlexMojosVersion() + " - GNU GPL License (NO WARRANTY) - See COPYRIGHT file"));
        if (!"swc".equals(this.project.getPackaging())) {
            this.getLog().warn((CharSequence)"Optimizer mojo can only be used on SWC projects.");
            return;
        }
        File library = this.project.getArtifact().getFile();
        if (library == null || !library.exists()) {
            throw new MojoExecutionException("Library file not found.");
        }
        File librarySWF = this.extractLibrarySWF(library);
        File optimizedSWF = this.optimizeLibrarySWF(librarySWF);
        Digest digest = this.computeDigest(optimizedSWF);
        this.updateDigest(digest, library);
        this.projectHelper.attachArtifact(this.project, "swf", optimizedSWF);
    }

    private void updateDigest(Digest digest, File library) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Updating digest on " + this.project.getArtifact().getFile().getName()));
        SwcCache swcCache = new SwcCache();
        String[] paths = new String[]{library.getAbsolutePath()};
        SwcGroup group = swcCache.getSwcGroup(paths);
        Collection swcs = group.getSwcs().values();
        Swc swc = (Swc)swcs.iterator().next();
        swc.setDigest(Swc.LIBRARY_SWF, digest);
        try {
            swcCache.export(swc);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to update digest information.", (Exception)e);
        }
    }

    private Digest computeDigest(File swf) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Computing optimized swf digest");
        try {
            FileInputStream input = new FileInputStream(swf);
            byte[] bytes = new byte[(int)swf.length()];
            input.read(bytes);
            Digest d = new Digest();
            this.getLog().debug((CharSequence)d.computeDigest(bytes));
            return d;
        }
        catch (IOException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }

    private File optimizeLibrarySWF(File librarySWF) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Optimizing library.swc");
        File optimizedSWF = new File(this.build.getDirectory(), this.build.getFinalName() + ".swf");
        try {
            FileInputStream input = new FileInputStream(librarySWF);
            FileOutputStream output = new FileOutputStream(optimizedSWF);
            API.optimize((InputStream)input, (OutputStream)output);
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error happen while trying to optimize SWC.", (Exception)e);
        }
        return optimizedSWF;
    }

    private File extractLibrarySWF(File library) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Extracting library.swf");
        File outputDir = new File(this.build.getOutputDirectory());
        try {
            ZipExtractor ze = new ZipExtractor(library);
            ze.extract(outputDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error happens when trying to extract library.swf from your SWC.", (Exception)e);
        }
        File libraryFile = new File(outputDir, "library.swf");
        return libraryFile;
    }
}

