/*
 * Decompiled with CFR 0.152.
 */
package info.flexmojos.htmlwrapper;

import eu.cedarsoft.utils.ZipExtractor;
import info.rvin.flexmojos.utilities.CompileConfigurationLoader;
import info.rvin.flexmojos.utilities.MavenUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class HtmlWrapperMojo
extends AbstractMojo {
    protected MavenProject project;
    protected Build build;
    private String templateURI;
    private Map<String, String> parameters;
    private File outputDirectory;
    private String htmlName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Flex-mojos " + MavenUtils.getFlexMojosVersion() + " - GNU GPL License (NO WARRANTY) - See COPYRIGHT file"));
        this.init();
        File templateFolder = this.extractTemplate();
        this.copyTemplates(templateFolder);
        this.copyIndex(templateFolder);
    }

    private void copyIndex(File templateFolder) throws MojoExecutionException {
        String template;
        File indexTemplate = new File(templateFolder, "index.template.html");
        try {
            template = FileUtils.readFileToString((File)indexTemplate);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read " + indexTemplate, (Exception)e);
        }
        for (String key : this.parameters.keySet()) {
            String value = this.parameters.get(key);
            template = template.replace("${" + key + "}", value);
        }
        File index = new File(this.outputDirectory, this.htmlName + ".html");
        try {
            FileUtils.writeStringToFile((File)index, (String)template);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write " + index, (Exception)e);
        }
    }

    private void copyTemplates(File templateFolder) throws MojoExecutionException {
        try {
            FileUtils.copyDirectory((File)templateFolder, (File)this.outputDirectory, (FileFilter)new FileFilter(){

                public boolean accept(File pathname) {
                    return !"index.template.html".equals(pathname.getName());
                }
            });
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create templates.", (Exception)e);
        }
    }

    private File extractTemplate() throws MojoExecutionException {
        URI uri;
        this.getLog().info((CharSequence)"Extracting template");
        File outputDir = new File(this.build.getOutputDirectory(), "html-template");
        outputDir.mkdirs();
        try {
            if (MavenUtils.isWindows()) {
                this.templateURI = this.templateURI.replace('\\', '/');
            }
            this.templateURI = URIUtil.encodePath((String)this.templateURI);
            uri = new URI(this.templateURI);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Invalid template URI.", e);
        }
        String scheme = uri.getScheme();
        if ("embed".equals(scheme)) {
            this.copyEmbedTemplate(uri.getSchemeSpecificPart(), outputDir);
        } else if ("zip".equals(scheme)) {
            this.copyZipTemplate(uri.getSchemeSpecificPart(), outputDir);
        } else if ("folder".equals(scheme)) {
            this.copyFolderTemplate(uri.getSchemeSpecificPart(), outputDir);
        } else {
            throw new MojoExecutionException("Invalid URI scheme: " + scheme);
        }
        return outputDir;
    }

    private void copyFolderTemplate(String path, File outputDir) throws MojoExecutionException {
        File source = new File(path);
        if (!source.exists() || !source.isDirectory()) {
            throw new MojoExecutionException("Template folder doesn't exists. " + source);
        }
        try {
            FileUtils.copyDirectory((File)source, (File)outputDir, (FileFilter)FileFilterUtils.makeSVNAware((IOFileFilter)FileFilterUtils.makeCVSAware(null)));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy template to: " + outputDir, (Exception)e);
        }
    }

    private void copyZipTemplate(String path, File outputDir) throws MojoExecutionException {
        File source = new File(path);
        if (!source.exists() || !source.isFile()) {
            throw new MojoExecutionException("Zip template doesn't exists. " + source);
        }
        this.extractZipTemplate(outputDir, source);
    }

    private void copyEmbedTemplate(String path, File outputDir) throws MojoExecutionException {
        URL url = ((Object)((Object)this)).getClass().getResource("/" + path + ".zip");
        File template = new File(this.build.getOutputDirectory(), "template.zip");
        try {
            FileUtils.copyURLToFile((URL)url, (File)template);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy template to: " + template, (Exception)e);
        }
        this.extractZipTemplate(outputDir, template);
    }

    private void extractZipTemplate(File outputDir, File template) throws MojoExecutionException {
        try {
            ZipExtractor ze = new ZipExtractor(template);
            ze.extract(outputDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error happens when trying to extract html-template.", (Exception)e);
        }
    }

    private void init() {
        String[] stringArray;
        String targetPlayer;
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        if (!this.parameters.containsKey("title")) {
            this.parameters.put("title", this.project.getName());
        }
        if ((targetPlayer = CompileConfigurationLoader.getCompilerPluginSetting((MavenProject)this.project, (String)"targetPlayer")) != null) {
            stringArray = targetPlayer.split("\\.");
        } else {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "9";
            stringArray2[1] = "0";
            stringArray = stringArray2;
            stringArray2[2] = "0";
        }
        String[] nodes = stringArray;
        if (!this.parameters.containsKey("version_major")) {
            this.parameters.put("version_major", nodes[0]);
        }
        if (!this.parameters.containsKey("version_minor")) {
            this.parameters.put("version_minor", nodes[1]);
        }
        if (!this.parameters.containsKey("version_revision")) {
            this.parameters.put("version_revision", nodes[2]);
        }
        if (!this.parameters.containsKey("swf")) {
            this.parameters.put("swf", this.project.getBuild().getFinalName());
        }
        if (!this.parameters.containsKey("width")) {
            this.parameters.put("width", "100%");
        }
        if (!this.parameters.containsKey("height")) {
            this.parameters.put("height", "100%");
        }
        if (!this.parameters.containsKey("application")) {
            this.parameters.put("application", this.project.getArtifactId());
        }
        if (!this.parameters.containsKey("bgcolor")) {
            this.parameters.put("bgcolor", "#869ca7");
        }
    }
}

