/*
 * Decompiled with CFR 0.152.
 */
package info.flexmojos.generator;

import info.flexmojos.generator.Gas3GroovyTransformer;
import info.flexmojos.generator.Gas3Listener;
import info.rvin.flexmojos.utilities.MavenUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.classworlds.DuplicateRealmException;
import org.granite.generator.Configuration;
import org.granite.generator.Generator;
import org.granite.generator.Input;
import org.granite.generator.Output;
import org.granite.generator.TemplateUri;
import org.granite.generator.Transformer;
import org.granite.generator.as3.As3TypeFactory;
import org.granite.generator.as3.DefaultAs3TypeFactory;
import org.granite.generator.as3.JavaAs3GroovyConfiguration;
import org.granite.generator.as3.JavaAs3Input;
import org.granite.generator.as3.PackageTranslator;
import org.granite.generator.as3.reflect.JavaEntityBean;
import org.granite.generator.as3.reflect.JavaEnum;
import org.granite.generator.as3.reflect.JavaInterface;
import org.granite.generator.as3.reflect.JavaType;
import org.granite.generator.gsp.GroovyTemplateFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorMojo
extends AbstractMojo
implements JavaAs3GroovyConfiguration {
    protected MavenProject project;
    private String[] includeClasses;
    private String[] excludeClasses;
    private String[] outputClasses;
    protected Build build;
    private File outputDirectory;
    private File baseOutputDirectory;
    private String uid = "uid";
    private String[] entityTemplate;
    private String[] interfaceTemplate;
    private String[] beanTemplate;
    private String[] enumTemplate;
    private boolean useTransitiveDependencies;
    private boolean outputEnumToBaseOutputDirectory;
    private Gas3Listener listener;
    private As3TypeFactory as3TypeFactoryImpl;
    private List<PackageTranslator> translators = new ArrayList<PackageTranslator>();
    private Map<String, File> classes;
    private ClassLoader loader;
    private GroovyTemplateFactory groovyTemplateFactory = null;
    private TemplateUri[] entityTemplateUris = null;
    private TemplateUri[] interfaceTemplateUris = null;
    private TemplateUri[] beanTemplateUris = null;
    private TemplateUri[] enumTemplateUris = null;
    protected ArtifactResolver resolver;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected MavenProjectBuilder mavenProjectBuilder;
    protected ArtifactRepository localRepository;
    protected List remoteRepositories;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Flex-mojos " + MavenUtils.getFlexMojosVersion() + " - GNU GPL License (NO WARRANTY) - See COPYRIGHT file"));
        this.setUp();
        List<File> jarDependencies = this.getJarDependencies();
        if (jarDependencies.isEmpty()) {
            this.getLog().warn((CharSequence)"No jar dependencies found.");
            return;
        }
        try {
            this.classes = this.getClasses(jarDependencies);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error on classes resolve", (Exception)e);
        }
        try {
            ClassWorld world = new ClassWorld();
            ClassRealm realm = world.newRealm("plugin.flex-mojos.generator", Thread.currentThread().getContextClassLoader());
            ClassRealm gas3GeneratorRealm = realm.createChildRealm("gas3Generator");
            for (URL url : this.getUrls(jarDependencies)) {
                gas3GeneratorRealm.addConstituent(url);
            }
            this.loader = gas3GeneratorRealm.getClassLoader();
            Thread.currentThread().setContextClassLoader(gas3GeneratorRealm.getClassLoader());
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Unable to get dependency URL", (Exception)e);
        }
        catch (DuplicateRealmException e) {
            throw new MojoExecutionException("Unable to create new class loading realm", (Exception)((Object)e));
        }
        this.setupTemplateUris();
        Generator generator = this.getGenerator(this.loader);
        this.as3TypeFactoryImpl = new DefaultAs3TypeFactory();
        int count = 0;
        for (Map.Entry<String, File> classEntry : this.classes.entrySet()) {
            Class<?> clazz = null;
            try {
                clazz = this.loader.loadClass(classEntry.getKey());
                JavaAs3Input input = new JavaAs3Input(clazz, classEntry.getValue());
                for (Output output : generator.generate((Input)input)) {
                    if (!output.isOutdated()) continue;
                    ++count;
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Could not generate AS3 beans for: '" + clazz + "'"), (Throwable)e);
            }
        }
        this.getLog().info((CharSequence)(count + " files generated."));
    }

    private URL[] getUrls(List<File> jarDependencies) throws MalformedURLException {
        URL[] urls = new URL[jarDependencies.size()];
        for (int i = 0; i < jarDependencies.size(); ++i) {
            urls[i] = jarDependencies.get(i).toURL();
        }
        return urls;
    }

    private List<File> getJarDependencies() {
        ArrayList<File> jarDependencies = new ArrayList<File>();
        Set artifacts = this.useTransitiveDependencies ? this.project.getArtifacts() : this.project.getDependencyArtifacts();
        for (Artifact artifact : artifacts) {
            if (!"jar".equals(artifact.getType())) continue;
            try {
                this.resolver.resolveAlways(artifact, this.remoteRepositories, this.localRepository);
            }
            catch (AbstractArtifactResolutionException e) {
                this.getLog().warn((CharSequence)("Dependency file not found: " + artifact));
                this.getLog().debug((Throwable)e);
                continue;
            }
            File file = artifact.getFile();
            if (file == null || !file.exists()) continue;
            jarDependencies.add(file);
        }
        return jarDependencies;
    }

    private void setupTemplateUris() {
        String baseTemplateUri = null;
        String templateUri = "class:org/granite/generator/template/enum.gsp";
        if (this.get0(this.enumTemplate) != null) {
            templateUri = this.get0(this.enumTemplate);
        }
        this.enumTemplateUris = this.createTemplateUris(baseTemplateUri, templateUri);
        baseTemplateUri = "class:org/granite/generator/template/interfaceBase.gsp";
        templateUri = "class:org/granite/generator/template/interface.gsp";
        if (this.get1(this.interfaceTemplate) != null) {
            templateUri = this.get1(this.interfaceTemplate);
        }
        if (this.get0(this.interfaceTemplate) != null) {
            baseTemplateUri = this.get0(this.interfaceTemplate);
        }
        this.interfaceTemplateUris = this.createTemplateUris(baseTemplateUri, templateUri);
        baseTemplateUri = "class:org/granite/generator/template/entityBase.gsp";
        templateUri = "class:org/granite/generator/template/entity.gsp";
        if (this.get1(this.entityTemplate) != null) {
            templateUri = this.get1(this.entityTemplate);
        }
        if (this.get0(this.entityTemplate) != null) {
            baseTemplateUri = this.get0(this.entityTemplate);
        }
        this.entityTemplateUris = this.createTemplateUris(baseTemplateUri, templateUri);
        baseTemplateUri = "class:org/granite/generator/template/beanBase.gsp";
        templateUri = "class:org/granite/generator/template/bean.gsp";
        if (this.get1(this.beanTemplate) != null) {
            templateUri = this.get1(this.beanTemplate);
        }
        if (this.get0(this.beanTemplate) != null) {
            baseTemplateUri = this.get0(this.beanTemplate);
        }
        this.beanTemplateUris = this.createTemplateUris(baseTemplateUri, templateUri);
    }

    private Generator getGenerator(ClassLoader loader) throws MojoExecutionException {
        this.listener = new Gas3Listener(this.getLog());
        Generator generator = new Generator((Configuration)this);
        generator.add((Transformer)new Gas3GroovyTransformer(this, this.listener, this.outputClasses));
        return generator;
    }

    private Map<String, File> getClasses(List<File> jarDependencies) throws IOException {
        HashMap<String, File> classes = new HashMap<String, File>();
        for (File file : jarDependencies) {
            JarEntry jarEntry;
            JarInputStream jar = new JarInputStream(new FileInputStream(file));
            while ((jarEntry = jar.getNextJarEntry()) != null) {
                String className = jarEntry.getName();
                if (jarEntry.isDirectory() || !className.endsWith(".class")) continue;
                className = className.replace('/', '.');
                if (!this.matchWildCard(className = className.substring(0, className.length() - 6), this.includeClasses) || this.matchWildCard(className, this.excludeClasses)) continue;
                classes.put(className, file);
            }
        }
        return classes;
    }

    private boolean matchWildCard(String className, String[] wildCards) {
        if (wildCards == null) {
            return false;
        }
        for (String wildCard : wildCards) {
            if (!FilenameUtils.wildcardMatch((String)className, (String)wildCard)) continue;
            return true;
        }
        return false;
    }

    private void setUp() throws MojoExecutionException {
        if (this.includeClasses == null) {
            this.includeClasses = new String[]{"*"};
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        String outputPath = this.outputDirectory.getAbsolutePath();
        if (!this.project.getCompileSourceRoots().contains(outputPath)) {
            this.project.addCompileSourceRoot(outputPath);
        }
        if (!this.baseOutputDirectory.exists()) {
            this.baseOutputDirectory.mkdirs();
        }
        String baseOutputPath = this.baseOutputDirectory.getAbsolutePath();
        if (!this.project.getCompileSourceRoots().contains(baseOutputPath)) {
            this.project.addCompileSourceRoot(baseOutputPath);
        }
    }

    private String get0(String[] a) {
        return this.get0Or1(a, 0);
    }

    private String get1(String[] a) {
        return this.get0Or1(a, 1);
    }

    private String get0Or1(String[] a, int index) {
        String s = a == null ? null : (a.length < index + 1 ? null : a[index]);
        return s == null ? null : new File(s).toURI().toString();
    }

    public As3TypeFactory getAs3TypeFactory() {
        return this.as3TypeFactoryImpl;
    }

    public File getBaseOutputDir(JavaAs3Input javaas3input) {
        return this.baseOutputDirectory;
    }

    public File getOutputDir(JavaAs3Input javaas3input) {
        if (this.outputEnumToBaseOutputDirectory && javaas3input.getType().isEnum()) {
            return this.baseOutputDirectory;
        }
        return this.outputDirectory;
    }

    public TemplateUri[] getTemplateUris(JavaType javaType) {
        if (javaType instanceof JavaEnum) {
            return this.enumTemplateUris;
        }
        if (javaType instanceof JavaInterface) {
            return this.interfaceTemplateUris;
        }
        if (javaType instanceof JavaEntityBean) {
            return this.entityTemplateUris;
        }
        return this.beanTemplateUris;
    }

    public List<PackageTranslator> getTranslators() {
        return this.translators;
    }

    public String getUid() {
        return this.uid;
    }

    public boolean isGenerated(Class<?> clazz) {
        return this.classes.containsKey(clazz.getName());
    }

    public GroovyTemplateFactory getGroovyTemplateFactory() {
        if (this.groovyTemplateFactory == null) {
            this.groovyTemplateFactory = new GroovyTemplateFactory();
        }
        return this.groovyTemplateFactory;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    private TemplateUri[] createTemplateUris(String baseUri, String uri) {
        TemplateUri[] templateUris = new TemplateUri[baseUri == null ? 1 : 2];
        int i = 0;
        if (baseUri != null) {
            templateUris[i++] = new TemplateUri(baseUri, true);
        }
        templateUris[i] = new TemplateUri(uri, false);
        return templateUris;
    }
}

