/*
 * Decompiled with CFR 0.152.
 */
package info.flexmojos.generator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.granite.generator.as3.As3Type;
import org.granite.generator.as3.DefaultAs3TypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gas3TypeFactory
extends DefaultAs3TypeFactory {
    private String[] typeMappings;
    private Log log;
    private final Pattern PATTERN = Pattern.compile("\\s*([^\\s]+)\\s+([^\\s]+)+\\s*");

    public Gas3TypeFactory(ClassLoader loader, String[] typeMappings, Log log) throws MojoExecutionException {
        this.typeMappings = typeMappings;
        this.log = log;
        this.populateCacheWithMappings(loader);
    }

    private void populateCacheWithMappings(ClassLoader loader) {
        if (this.typeMappings == null) {
            return;
        }
        for (String typeMapping : this.typeMappings) {
            Matcher matcher = this.PATTERN.matcher(typeMapping);
            if (!matcher.matches()) continue;
            Class<?> javaType = this.getJavaType(loader, matcher.group(1));
            As3Type as3Type = this.newAs3Type(matcher.group(2));
            if (as3Type == null || javaType == null) continue;
            this.putInCache(javaType, as3Type);
        }
    }

    private Class<?> getJavaType(ClassLoader loader, String typeName) {
        Class<?> javaType = null;
        try {
            javaType = loader.loadClass(typeName);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (javaType == null) {
            try {
                javaType = ((Object)((Object)this)).getClass().getClassLoader().loadClass(typeName);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (javaType == null) {
            this.log.warn((CharSequence)("Cannot load Java class for name '" + typeName + "' This mapping will be ignored."));
        }
        return javaType;
    }

    private As3Type newAs3Type(String typeName) {
        int i = typeName.lastIndexOf(46);
        if (i > 0) {
            String simpleName;
            String packageName = typeName.substring(0, i);
            if (packageName.trim().length() > 0 && (simpleName = typeName.substring(i + 1)).trim().length() > 0) {
                return new As3Type(packageName, simpleName);
            }
        } else {
            return new As3Type("", typeName);
        }
        this.log.warn((CharSequence)("Invalid AS3 type name '" + typeName + "'. Type name needs to be a fully qualified AS3 class name. This mapping will be ignored."));
        return null;
    }
}

