/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.terminology;

import java.util.ArrayList;
import java.util.List;
import org.opencds.cqf.cql.engine.runtime.CodeSystem;
import org.opencds.cqf.cql.engine.runtime.ValueSet;
import org.opencds.cqf.cql.engine.terminology.CodeSystemInfo;

public class ValueSetInfo {
    private String id;
    private String version;
    private List<CodeSystemInfo> codeSystems;

    public static ValueSetInfo fromValueSet(ValueSet vs) {
        ValueSetInfo vsi = new ValueSetInfo().withId(vs.getId()).withVersion(vs.getVersion());
        for (CodeSystem cs : vs.getCodeSystems()) {
            vsi.withCodeSystem(CodeSystemInfo.fromCodeSystem(cs));
        }
        return vsi;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ValueSetInfo withId(String id) {
        this.setId(id);
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ValueSetInfo withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public List<CodeSystemInfo> getCodeSystems() {
        if (this.codeSystems == null) {
            this.codeSystems = new ArrayList<CodeSystemInfo>();
        }
        return this.codeSystems;
    }

    public ValueSetInfo withCodeSystem(CodeSystemInfo codeSystem) {
        this.getCodeSystems().add(codeSystem);
        return this;
    }
}

