/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Precision;
import org.opencds.cqf.cql.engine.runtime.Time;

public class LowBoundaryEvaluator {
    public static Object lowBoundary(Object input, Object precision) {
        if (input == null) {
            return null;
        }
        if (input instanceof BigDecimal) {
            if (precision == null) {
                precision = 8;
            }
            if ((Integer)precision > 8) {
                return null;
            }
            return ((BigDecimal)input).setScale((int)((Integer)precision), RoundingMode.DOWN);
        }
        if (input instanceof Date) {
            if (precision == null) {
                precision = 8;
            }
            if ((Integer)precision > 8) {
                return null;
            }
            if ((Integer)precision <= 4) {
                return ((Date)input).setPrecision(Precision.YEAR);
            }
            if ((Integer)precision <= 6) {
                return ((Date)input).setPrecision(Precision.MONTH);
            }
            if ((Integer)precision <= 8) {
                return ((Date)input).setPrecision(Precision.DAY);
            }
        } else if (input instanceof DateTime) {
            if (precision == null) {
                precision = 17;
            }
            if ((Integer)precision > 17) {
                return null;
            }
            if ((Integer)precision <= 4) {
                return ((DateTime)input).setPrecision(Precision.YEAR);
            }
            if ((Integer)precision <= 6) {
                return ((DateTime)input).setPrecision(Precision.MONTH);
            }
            if ((Integer)precision <= 8) {
                return ((DateTime)input).setPrecision(Precision.DAY);
            }
            if ((Integer)precision <= 10) {
                return ((DateTime)input).setPrecision(Precision.HOUR);
            }
            if ((Integer)precision <= 12) {
                return ((DateTime)input).setPrecision(Precision.MINUTE);
            }
            if ((Integer)precision <= 14) {
                return ((DateTime)input).setPrecision(Precision.SECOND);
            }
            if ((Integer)precision <= 17) {
                return ((DateTime)input).setPrecision(Precision.MILLISECOND);
            }
        } else if (input instanceof Time) {
            if (precision == null) {
                precision = 9;
            }
            if ((Integer)precision > 9) {
                return null;
            }
            if ((Integer)precision <= 2) {
                return ((Time)input).setPrecision(Precision.HOUR);
            }
            if ((Integer)precision <= 4) {
                return ((Time)input).setPrecision(Precision.MINUTE);
            }
            if ((Integer)precision <= 6) {
                return ((Time)input).setPrecision(Precision.SECOND);
            }
            if ((Integer)precision <= 9) {
                return ((Time)input).setPrecision(Precision.MILLISECOND);
            }
        }
        throw new InvalidOperatorArgument("LowBoundary(Decimal, Integer) or LowBoundary(Date, Integer) or LowBoundary(DateTime, Integer) or LowBoundary(Time, Integer)", String.format("LowBoundary(%s, %s)", input.getClass().getName(), precision.getClass().getName()));
    }
}

