/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import org.opencds.cqf.cql.engine.elm.executing.AndEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.EqualEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.GreaterOrEqualEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SameAsEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SameOrAfterEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;

public class EndsEvaluator {
    public static Boolean ends(Object left, Object right, String precision, State state) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Interval && right instanceof Interval) {
            Object leftStart = ((Interval)left).getStart();
            Object leftEnd = ((Interval)left).getEnd();
            Object rightStart = ((Interval)right).getStart();
            Object rightEnd = ((Interval)right).getEnd();
            if (leftStart instanceof BaseTemporal && rightStart instanceof BaseTemporal) {
                return AndEvaluator.and(SameOrAfterEvaluator.sameOrAfter(leftStart, rightStart, precision, state), SameAsEvaluator.sameAs(leftEnd, rightEnd, precision, state));
            }
            return AndEvaluator.and(GreaterOrEqualEvaluator.greaterOrEqual(leftStart, rightStart, state), EqualEvaluator.equal(leftEnd, rightEnd, state));
        }
        throw new InvalidOperatorArgument("Ends(Interval<T>, Interval<T>)", String.format("Ends(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }
}

