/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.debug;

import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.Library;
import org.opencds.cqf.cql.engine.debug.Location;

public class SourceLocator {
    private String librarySystemId;
    private String libraryName;
    private String libraryVersion;
    private String nodeId;
    private String nodeType;
    private Location sourceLocation;

    public SourceLocator(String librarySystemId, String libraryName, String libraryVersion, String nodeId, String nodeType, Location sourceLocation) {
        this.librarySystemId = librarySystemId;
        this.libraryName = libraryName;
        this.libraryVersion = libraryVersion;
        this.nodeId = nodeId;
        this.nodeType = nodeType;
        this.sourceLocation = sourceLocation;
    }

    public static SourceLocator fromNode(Element node, Library currentLibrary) {
        if (node instanceof Element) {
            Element element = node;
            return new SourceLocator(currentLibrary != null ? currentLibrary.getIdentifier().getSystem() : "http://cql.hl7.org/Library/unknown", currentLibrary != null ? currentLibrary.getIdentifier().getId() : "?", currentLibrary != null ? currentLibrary.getIdentifier().getVersion() : null, element.getLocalId(), SourceLocator.stripEvaluator(element.getClass().getSimpleName()), element.getLocator() != null ? Location.fromLocator(element.getLocator()) : null);
        }
        return new SourceLocator(currentLibrary.getIdentifier().getSystem(), currentLibrary.getIdentifier().getId(), currentLibrary.getIdentifier().getVersion(), null, SourceLocator.stripEvaluator(node.getClass().getSimpleName()), null);
    }

    public static String stripEvaluator(String nodeType) {
        if (nodeType == null) {
            return nodeType;
        }
        if (nodeType.endsWith("Evaluator")) {
            return nodeType.substring(0, nodeType.lastIndexOf("Evaluator"));
        }
        return nodeType;
    }

    public String getLibrarySystemId() {
        return this.librarySystemId;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public String getLibraryVersion() {
        return this.libraryVersion;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public Location getSourceLocation() {
        return this.sourceLocation;
    }

    private String getLocation() {
        Object[] objectArray = new Object[2];
        Object object = objectArray[0] = this.sourceLocation != null ? this.sourceLocation.toLocator() : "?";
        objectArray[1] = this.nodeId != null || this.nodeType != null ? "(" + (this.nodeId != null ? this.nodeId : this.nodeType) + ")" : "(?)";
        return String.format("%s%s", objectArray);
    }

    public String toString() {
        String location = this.getLocation();
        return String.format("%s%s", this.libraryName == null ? "?" : this.libraryName, location != null ? "." + location : "");
    }
}

