/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.utils;

import java.io.File;

public final class JNIMethods {
    public static final ARCHType ARCH = JNIMethods.calculateArch();
    public static final OSType OS = JNIMethods.calculateOS();

    public static String getPortableLibraryName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.length() == 0 || name.contains(File.separator) || name.contains("/")) {
            throw new IllegalArgumentException("Directory separator should not appear in library name: " + name);
        }
        return name.toLowerCase() + JNIMethods.getSuffix();
    }

    public static void main(String[] args) {
        System.out.println((Object)((Object)OS) + ", " + (Object)((Object)ARCH) + ", " + JNIMethods.getPortableLibraryName("NAME"));
    }

    private static ARCHType calculateArch() {
        String osArch = System.getProperty("os.arch").toLowerCase();
        assert (osArch != null);
        if (osArch.equals("i386")) {
            return ARCHType.X86;
        }
        if (osArch.startsWith("amd64") || osArch.startsWith("x86_64")) {
            return ARCHType.X86_64;
        }
        if (osArch.equals("ppc")) {
            return ARCHType.PPC;
        }
        if (osArch.startsWith("ppc")) {
            return ARCHType.PPC_64;
        }
        if (osArch.startsWith("sparc")) {
            return ARCHType.SPARC;
        }
        return ARCHType.UNKNOWN;
    }

    private static OSType calculateOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        assert (osName != null);
        if (osName.startsWith("mac os x")) {
            return OSType.APPLE;
        }
        if (osName.startsWith("windows")) {
            return OSType.WINDOWS;
        }
        if (osName.startsWith("linux")) {
            return OSType.LINUX;
        }
        if (osName.startsWith("sun")) {
            return OSType.SUN;
        }
        return OSType.UNKNOWN;
    }

    private static String getSuffix() {
        String prefix = "-" + OS.toString().toLowerCase() + "-" + ARCH.toString().toLowerCase();
        return prefix;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OSType {
        APPLE,
        LINUX,
        SUN,
        UNKNOWN,
        WINDOWS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ARCHType {
        PPC,
        PPC_64,
        SPARC,
        UNKNOWN,
        X86,
        X86_64;

    }
}

