/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax;

import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import jlibs.core.lang.StringUtil;
import jlibs.xml.sax.SAXDelegate;
import jlibs.xml.sax.SAXProducer;
import jlibs.xml.sax.SAXUtil;
import jlibs.xml.sax.helpers.MyNamespaceSupport;
import jlibs.xml.xsl.TransformerUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class XMLDocument {
    private SAXDelegate xml;
    private MyNamespaceSupport nsSupport = new MyNamespaceSupport();
    private boolean needsNewContext = true;
    private Stack<QName> elemStack = new Stack();
    private QName elem;
    int depth = 0;
    private int marks = -1;
    private AttributesImpl attrs = new AttributesImpl();

    public XMLDocument(SAXDelegate xml) {
        this.xml = xml;
    }

    public XMLDocument(Result result, boolean omitXMLDeclaration, int indentAmount, String encoding) throws TransformerConfigurationException {
        TransformerHandler handler = TransformerUtil.newTransformerHandler(null, omitXMLDeclaration, indentAmount, encoding);
        handler.setResult(result);
        this.xml = new SAXDelegate(handler);
    }

    public XMLDocument startDocument() throws SAXException {
        this.nsSupport.reset();
        this.attrs.clear();
        this.elemStack.clear();
        this.elem = null;
        this.depth = 0;
        this.nsSupport.pushContext();
        this.xml.startDocument();
        this.mark();
        return this;
    }

    public XMLDocument endDocument() throws SAXException {
        this.release(0);
        this.xml.endDocument();
        return this;
    }

    public MyNamespaceSupport getNamespaceSupport() {
        return this.nsSupport;
    }

    public void suggestPrefix(String prefix, String uri) {
        this.nsSupport.suggestPrefix(prefix, uri);
    }

    public String declarePrefix(String uri) {
        String prefix;
        if (uri == null) {
            uri = "";
        }
        if ((prefix = this.nsSupport.findPrefix(uri)) == null) {
            if (this.needsNewContext) {
                this.nsSupport.pushContext();
                this.needsNewContext = false;
            }
            prefix = this.nsSupport.declarePrefix(uri);
        }
        return prefix;
    }

    public boolean declarePrefix(String prefix, String uri) {
        if (this.needsNewContext) {
            this.nsSupport.pushContext();
            this.needsNewContext = false;
        }
        return this.nsSupport.declarePrefix(prefix, uri);
    }

    private QName declareQName(String uri, String localPart) {
        if (uri == null) {
            uri = "";
        }
        return new QName(uri, localPart, this.declarePrefix(uri));
    }

    public String toQName(String uri, String localPart) {
        String prefix;
        if (uri == null) {
            uri = "";
        }
        return (prefix = this.declarePrefix(uri)).length() == 0 ? localPart : prefix + ':' + localPart;
    }

    public String toAttrQName(String uri, String localPart) {
        return uri.equals("") ? localPart : this.toQName(uri, localPart);
    }

    private void startPrefixMappings() throws SAXException {
        Enumeration<String> enumer = this.nsSupport.getDeclaredPrefixes();
        while (enumer.hasMoreElements()) {
            String prefix = enumer.nextElement();
            this.xml.startPrefixMapping(prefix, this.nsSupport.findURI(prefix));
        }
    }

    private void endPrefixMappings() throws SAXException {
        Enumeration<String> enumer = this.nsSupport.getDeclaredPrefixes();
        while (enumer.hasMoreElements()) {
            this.xml.endPrefixMapping(enumer.nextElement());
        }
    }

    public int getDepth() {
        return this.depth;
    }

    public int mark() throws SAXException {
        this.finishStartElement();
        this.elemStack.push(null);
        return ++this.marks;
    }

    public int release() throws SAXException {
        if (this.marks == -1 || this.elemStack.empty()) {
            throw new SAXException("no mark found to be released");
        }
        this.endElements();
        if (this.elemStack.peek() != null) {
            throw new SAXException("expected </" + this.toString(this.elemStack.peek()) + '>');
        }
        this.elemStack.pop();
        return --this.marks;
    }

    public void release(int mark) throws SAXException {
        while (this.marks >= mark) {
            this.release();
        }
    }

    private String toString(QName qname) {
        return qname.getPrefix().length() == 0 ? qname.getLocalPart() : qname.getPrefix() + ':' + qname.getLocalPart();
    }

    private void finishStartElement() throws SAXException {
        if (this.elem != null) {
            if (this.needsNewContext) {
                this.nsSupport.pushContext();
            } else {
                this.needsNewContext = true;
            }
            this.startPrefixMappings();
            this.elemStack.push(this.elem);
            this.xml.startElement(this.elem.getNamespaceURI(), this.elem.getLocalPart(), this.toString(this.elem), this.attrs);
            this.elem = null;
            this.attrs.clear();
        }
    }

    public XMLDocument startElement(String name) throws SAXException {
        return this.startElement("", name);
    }

    public XMLDocument startElement(String uri, String name) throws SAXException {
        if (uri == null) {
            uri = "";
        }
        this.finishStartElement();
        this.elem = this.declareQName(uri, name);
        ++this.depth;
        return this;
    }

    public XMLDocument addElement(String name, String text, boolean cdata) throws SAXException {
        return this.addElement("", name, text, cdata);
    }

    public XMLDocument addElement(String uri, String name, String text, boolean cdata) throws SAXException {
        if (text != null) {
            this.startElement(uri, name);
            if (cdata) {
                this.addCDATA(text);
            } else {
                this.addText(text);
            }
            this.endElement();
        }
        return this;
    }

    public XMLDocument addElement(String name, String text) throws SAXException {
        return this.addElement("", name, text, false);
    }

    public XMLDocument addElement(String uri, String name, String text) throws SAXException {
        return this.addElement(uri, name, text, false);
    }

    public XMLDocument addCDATAElement(String name, String text) throws SAXException {
        return this.addElement("", name, text, true);
    }

    public XMLDocument addCDATAElement(String uri, String name, String text) throws SAXException {
        return this.addElement(uri, name, text, true);
    }

    public XMLDocument addAttribute(String name, String value) throws SAXException {
        return this.addAttribute("", name, value);
    }

    public XMLDocument addAttribute(String uri, String name, String value) throws SAXException {
        if (this.elem == null) {
            throw new SAXException("no start element found to associate this attribute");
        }
        if (value != null) {
            if (uri == null) {
                uri = "";
            }
            this.attrs.addAttribute(uri, name, this.toAttrQName(uri, name), "CDATA", value);
        }
        return this;
    }

    public XMLDocument addText(String text) throws SAXException {
        if (!StringUtil.isEmpty((CharSequence)text)) {
            this.finishStartElement();
            this.xml.characters(text.toCharArray(), 0, text.length());
        }
        return this;
    }

    public XMLDocument addCDATA(String text) throws SAXException {
        if (!StringUtil.isEmpty((CharSequence)text)) {
            this.finishStartElement();
            this.xml.startCDATA();
            this.xml.characters(text.toCharArray(), 0, text.length());
            this.xml.endCDATA();
        }
        return this;
    }

    private QName findEndElement() throws SAXException {
        this.finishStartElement();
        if (this.elemStack.empty() || this.elemStack.peek() == null) {
            throw new SAXException("can't find matching start element");
        }
        return this.elemStack.pop();
    }

    private XMLDocument endElement(QName qname) throws SAXException {
        this.xml.endElement(qname.getNamespaceURI(), qname.getLocalPart(), this.toString(qname));
        --this.depth;
        this.endPrefixMappings();
        this.nsSupport.popContext();
        this.needsNewContext = true;
        return this;
    }

    public XMLDocument endElement(String uri, String name) throws SAXException {
        QName qname = this.findEndElement();
        if (!qname.getNamespaceURI().equals(uri) || !qname.getLocalPart().equals(name)) {
            throw new SAXException("expected </" + this.toString(qname) + '>');
        }
        return this.endElement(qname);
    }

    public XMLDocument endElement(String name) throws SAXException {
        return this.endElement("", name);
    }

    public XMLDocument endElement() throws SAXException {
        return this.endElement(this.findEndElement());
    }

    public XMLDocument endElements(String uri, String name) throws SAXException {
        QName qname = this.findEndElement();
        do {
            this.endElement(qname);
        } while (!qname.getNamespaceURI().equals(uri) || !qname.getLocalPart().equals(name));
        return this;
    }

    public XMLDocument endElements(String name) throws SAXException {
        return this.endElements("", name);
    }

    public XMLDocument endElements() throws SAXException {
        this.finishStartElement();
        while (!this.elemStack.empty() && this.elemStack.peek() != null) {
            this.endElement();
        }
        return this;
    }

    public void warning(String msg, Exception ex) throws SAXException {
        this.xml.warning(new SAXParseException(msg, null, ex));
    }

    public void error(String msg, Exception ex) throws SAXException {
        this.xml.error(new SAXParseException(msg, null, ex));
    }

    public void fatalError(String msg, Exception ex) throws SAXException {
        SAXParseException saxException = new SAXParseException(msg, null, ex);
        this.xml.fatalError(saxException);
        throw saxException;
    }

    public XMLDocument addXML(String xmlString, boolean excludeRoot) throws SAXException {
        if (!StringUtil.isWhitespace((CharSequence)xmlString)) {
            this.addXML(new InputSource(new StringReader(xmlString)), excludeRoot);
        }
        return this;
    }

    public XMLDocument addXML(InputSource is, boolean excludeRoot) throws SAXException {
        this.finishStartElement();
        try {
            SAXDelegate delegate = excludeRoot ? new SAXDelegate(this.xml){
                private int depth;
                private NamespaceSupport nsSupport;
                {
                    this.depth = 0;
                    this.nsSupport = new NamespaceSupport();
                }

                @Override
                public void startDocument() {
                }

                @Override
                public void endDocument() {
                }

                @Override
                public void setDocumentLocator(Locator locator) {
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.depth != 1) {
                        super.characters(ch, start, length);
                    }
                }

                @Override
                public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
                    if (this.depth != 1) {
                        super.ignorableWhitespace(ch, start, length);
                    }
                }

                @Override
                public void startPrefixMapping(String prefix, String uri) throws SAXException {
                    if (this.depth == 0) {
                        this.nsSupport.declarePrefix(prefix, uri);
                    } else {
                        super.startPrefixMapping(prefix, uri);
                    }
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                    ++this.depth;
                    if (this.depth > 1) {
                        if (this.depth == 2) {
                            XMLDocument.this.startPrefixMappings();
                        }
                        super.startElement(uri, localName, qName, atts);
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (this.depth > 1) {
                        super.endElement(uri, localName, qName);
                        if (this.depth == 2) {
                            XMLDocument.this.endPrefixMappings();
                        }
                    }
                    --this.depth;
                }

                @Override
                public void endPrefixMapping(String prefix) throws SAXException {
                    if (this.depth > 0) {
                        super.endPrefixMapping(prefix);
                    }
                }
            } : new SAXDelegate(this.xml){

                @Override
                public void startDocument() {
                }

                @Override
                public void endDocument() {
                }

                @Override
                public void setDocumentLocator(Locator locator) {
                }
            };
            XMLReader reader = SAXUtil.newSAXParser(true, false, false).getXMLReader();
            SAXUtil.setHandler(reader, delegate);
            reader.parse(is);
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException(ex);
        }
        catch (IOException ex) {
            throw new SAXException(ex);
        }
        return this;
    }

    public XMLDocument addProcessingInstruction(String target, String data) throws SAXException {
        this.xml.processingInstruction(target, data);
        return this;
    }

    public XMLDocument addComment(String text) throws SAXException {
        if (!StringUtil.isEmpty((CharSequence)text)) {
            this.finishStartElement();
            this.xml.comment(text.toCharArray(), 0, text.length());
        }
        return this;
    }

    public XMLDocument add(SAXProducer saxProducer) throws SAXException {
        return this.add(saxProducer, (QName)null);
    }

    public XMLDocument add(SAXProducer saxProducer, String name) throws SAXException {
        return this.add(saxProducer, "", name);
    }

    public XMLDocument add(SAXProducer saxProducer, String uri, String name) throws SAXException {
        return this.add(saxProducer, new QName(uri, name));
    }

    public XMLDocument add(SAXProducer saxProducer, QName qname) throws SAXException {
        if (saxProducer != null) {
            this.mark();
            saxProducer.serializeTo(qname, this);
            this.endElements();
            this.release();
        }
        return this;
    }

    public XMLDocument addPublicDTD(String name, String publicId, String systemID) throws SAXException {
        this.xml.startDTD(name, publicId, systemID);
        this.xml.endDTD();
        return this;
    }

    public XMLDocument addSystemDTD(String name, String systemId) throws SAXException {
        this.xml.startDTD(name, null, systemId);
        this.xml.endDTD();
        return this;
    }

    public static void main(String[] args) throws Exception {
        String google = "http://google.com";
        String yahoo = "http://yahoo.com";
        XMLDocument xml = new XMLDocument(new StreamResult(System.out), false, 4, null);
        xml.startDocument();
        xml.addProcessingInstruction("san", "test='1.2'");
        xml.declarePrefix("google", google);
        xml.declarePrefix("yahoo", yahoo);
        xml.declarePrefix("http://msn.com");
        xml.startElement(google, "hello");
        xml.addAttribute("name", "value");
        xml.addElement("xyz", "helloworld");
        xml.addElement(google, "hai", "test");
        xml.addXML(new InputSource("xml/xsds/note.xsd"), true);
        xml.addComment("this is comment");
        xml.addCDATA("this is sample cdata");
        xml.endDocument();
    }
}

