package im.zego.zegoexpress.utils;

class ZegoDeviceUtil {
    /**
     * 获取当前手机系统版本号
     *
     * @return  系统版本号
     */
    public static String getSystemVersion() {
        return android.os.Build.VERSION.RELEASE;
    }

    /**
     * 获取手机型号
     *
     * @return  手机型号
     */
    public static String getSystemModel() {
        return android.os.Build.MODEL;
    }

    /**
     * 获取手机厂商
     *
     * @return  手机厂商
     */
    public static String getDeviceBrand() {
        return android.os.Build.BRAND;
    }
    /**
     * 获取操作系统的版本号
     *
     * @return  操作系统的版本号，比如Android P = 28;
     */
    public static String getSystemSDKVersion(){
        return android.os.Build.VERSION.SDK_INT+"";
    }
    /**
     * 获取硬件制造商
     *
     * @return  硬件制造商;
     */
    public static String getManuFacturer(){
        return android.os.Build.MANUFACTURER;
    }
    public static String getAndroidDeviceInfo(){
        return "model: "+getSystemModel()+"  system version:"+getSystemVersion()+"  brand:"+getDeviceBrand()+"  system sdk version:"+getSystemSDKVersion()+"  ManuFacturer:"+getManuFacturer();
    }
}
