package im.zego.zegoexpress.internal;

import android.content.Context;
import android.graphics.SurfaceTexture;

import java.nio.ByteBuffer;

import im.zego.zegoexpress.constants.ZegoMediaPlayerAudioChannel;
import im.zego.zegoexpress.entity.ZegoAccurateSeekConfig;
import im.zego.zegoexpress.entity.ZegoAudioConfig;
import im.zego.zegoexpress.entity.ZegoBeautifyOption;
import im.zego.zegoexpress.entity.ZegoCDNConfig;
import im.zego.zegoexpress.entity.ZegoCustomVideoCaptureConfig;
import im.zego.zegoexpress.entity.ZegoCustomVideoRenderConfig;
import im.zego.zegoexpress.entity.ZegoEngineConfig;
import im.zego.zegoexpress.entity.ZegoMixerTask;
import im.zego.zegoexpress.entity.ZegoRoomConfig;
import im.zego.zegoexpress.entity.ZegoUser;
import im.zego.zegoexpress.entity.ZegoVideoConfig;
import im.zego.zegoexpress.entity.ZegoVoiceChangerParam;
import im.zego.zegoexpress.entity.ZegoWatermark;

public class ZegoMediaPlayerJniAPI {

    public native static int getCurrentStateJni(int idx);

    public native static int destroyMediaPlayerJni(int idx);

    public native static int createMediaPlayerJni();

    public native static int startJni(int idx);

    public native static int stopJni(int idx);

    public native static int pauseJni(int idx);

    public native static int resumeJni(int idx);

    public native static int enableRepeatJni(int idx, boolean enable);

    public native static int enableAuxJni(int idx, boolean enable);

    public native static int muteLocalJni(int idx, boolean mute);

    public native static int setPlayerCanvasJni(int idx, Object view, int viewMode, int backgroundColor);

    public native static int setVolumeJni(int idx, int volume);

    public native static int setProgressIntervalJni(int idx, long millisecond);

    public native static long getTotalDurationJni(int idx);

    public native static long getCurrentProgressJni(int idx);

    public native static int seekToJni(int idx, long millisecond);

    public native static int loadResourceJni(int idx, String path);

    public native static int enableAudioDataJni(boolean enable, int idx);

    public native static int enableVideoDataJni(int value, boolean enable, int idx);

    public native static int setPlayVolumeJni(int kMediaPlayerIdx, int volume);

    public native static int setPublishVolumeJni(int kMediaPlayerIdx, int volume);

    public native static int getPlayVolumeJni(int kMediaPlayerIdx);

    public native static int getPublishVolumeJni(int kMediaPlayerIdx);

    public native static int getAudioTrackCount(int kMediaPlayerIdx);

    public native static int setAudioTrackIndex(int index,int kMediaPlayerIdx);

    public native static int setVoiceChangerParam(int audioChannel, float param,int kMediaPlayerIdx);

    public native static int takeSnapshotJni(int kMediaPlayerIdx);

    public native static int enableAccurateSeek(int kMediaPlayerIdx,boolean enable, ZegoAccurateSeekConfig config);
}
