/*
 * Decompiled with CFR 0.152.
 */
package com.zego.ve;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.zego.ve.FeatureKitManager;
import com.zego.ve.IHwAudioKaraokeFeature;

class HwAudioKaraokeFeatureKit {
    private Context mContext;
    private FeatureKitManager mFeatureKitManager = null;
    private boolean mIsServiceConnected = false;
    private IHwAudioKaraokeFeature mIHwAudioKaraokeFeatureAidl;
    private IBinder mService = null;
    private ServiceConnection mConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            HwAudioKaraokeFeatureKit.this.mIHwAudioKaraokeFeatureAidl = IHwAudioKaraokeFeature.Stub.asInterface(iBinder);
            if (HwAudioKaraokeFeatureKit.this.mIHwAudioKaraokeFeatureAidl != null) {
                HwAudioKaraokeFeatureKit.this.mIsServiceConnected = true;
                HwAudioKaraokeFeatureKit.this.mFeatureKitManager.onCallBack(1000);
                HwAudioKaraokeFeatureKit.this.serviceInit(HwAudioKaraokeFeatureKit.this.mContext.getPackageName());
                HwAudioKaraokeFeatureKit.this.serviceLinkToDeath(iBinder);
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
            HwAudioKaraokeFeatureKit.this.mIsServiceConnected = false;
            if (HwAudioKaraokeFeatureKit.this.mFeatureKitManager != null) {
                HwAudioKaraokeFeatureKit.this.mFeatureKitManager.onCallBack(1001);
            }
        }
    };
    private IBinder.DeathRecipient mDeathRecipient = new IBinder.DeathRecipient(){

        public void binderDied() {
            HwAudioKaraokeFeatureKit.this.mService.unlinkToDeath(HwAudioKaraokeFeatureKit.this.mDeathRecipient, 0);
            HwAudioKaraokeFeatureKit.this.mFeatureKitManager.onCallBack(1003);
            HwAudioKaraokeFeatureKit.this.mService = null;
        }
    };

    protected HwAudioKaraokeFeatureKit(Context context) {
        this.mFeatureKitManager = FeatureKitManager.getInstance();
        this.mContext = context;
    }

    private void serviceLinkToDeath(IBinder iBinder) {
        this.mService = iBinder;
        try {
            if (iBinder != null) {
                iBinder.linkToDeath(this.mDeathRecipient, 0);
            }
        }
        catch (RemoteException remoteException) {
            this.mFeatureKitManager.onCallBack(1002);
        }
    }

    protected void initialize(Context context) {
        if (context != null) {
            if (!this.mFeatureKitManager.isMediaKitSupport(context)) {
                this.mFeatureKitManager.onCallBack(2);
            } else {
                this.bindService(context);
            }
        }
    }

    private void bindService(Context context) {
        if (this.mFeatureKitManager != null && !this.mIsServiceConnected) {
            this.mFeatureKitManager.bindService(context, this.mConnection, "com.huawei.multimedia.audioengine.HwAudioKaraokeFeatureService");
        }
    }

    public void destroy() {
        if (this.mIsServiceConnected) {
            this.mIsServiceConnected = false;
            this.mFeatureKitManager.unbindService(this.mContext, this.mConnection);
        }
    }

    public int enableKaraokeFeature(boolean bl) {
        try {
            if (this.mIHwAudioKaraokeFeatureAidl != null && this.mIsServiceConnected) {
                return this.mIHwAudioKaraokeFeatureAidl.enableKaraokeFeature(bl);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return -2;
    }

    public int setParameter(String string, int n) {
        try {
            if (this.mIHwAudioKaraokeFeatureAidl != null && this.mIsServiceConnected) {
                return this.mIHwAudioKaraokeFeatureAidl.setParameter(string, n);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return -2;
    }

    private void serviceInit(String string) {
        try {
            if (this.mIHwAudioKaraokeFeatureAidl != null && this.mIsServiceConnected) {
                this.mIHwAudioKaraokeFeatureAidl.init(string);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

