/*
 * Decompiled with CFR 0.152.
 */
package com.zego.ve;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.hardware.usb.UsbConfiguration;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioRouting;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import com.zego.ve.HwAudioKit;
import com.zego.ve.Log;
import com.zego.ve.PermissionChecker;
import com.zego.ve.RoutingChangedListener;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;

@TargetApi(value=11)
public class AudioDevice
extends BroadcastReceiver {
    private static final int CAP_SR_32000 = 0;
    private static final int CAP_SR_16000 = 1;
    private static final int CAP_SR_8000 = 2;
    private static final String TAG = "device";
    protected Context _context = null;
    protected ByteBuffer _rndBuf = null;
    protected ByteBuffer _capBuf = null;
    protected byte[] _rndBufArray = null;
    protected AudioTrack _rndDev = null;
    protected AudioRecord _capDev = null;
    protected AudioManager _audioManager = null;
    protected Object _routingChangedListener;
    protected int _mode = 3;
    protected int _stream_type = 0;
    protected int _audio_source = 7;
    protected int _NativeOutputSampleRate = 44100;
    protected final int _frameSizeMs = 20;
    protected int _capSampleRate = 32000;
    protected int _rndSampleRate;
    protected int[] _capSampleRateTable = new int[]{32000, 16000, 8000};
    protected int _framesPerBuffer = 256;
    protected int _capProfile = 0;
    protected int _deviceManufacturer = 0;
    private int _bluetoothOpSeq;
    protected volatile long _pthis = 0L;
    protected AtomicBoolean _isListening = new AtomicBoolean(false);
    protected Handler _handler = new Handler(Looper.getMainLooper());
    protected PhoneStateListener _phoneStateListener = null;
    protected AudioManager.OnAudioFocusChangeListener _audioFocusChangeListener = null;
    protected boolean _isCalling = false;
    protected HwAudioKit _hwAudioKit = null;
    protected SilentPlayer _silentPlayer = null;
    protected boolean _initVivoKtv = false;

    public AudioDevice() {
        this._rndBuf = ByteBuffer.allocateDirect(3840);
        this._rndBufArray = new byte[3840];
        this._capBuf = ByteBuffer.allocateDirect(1920);
        if (Build.VERSION.SDK_INT >= 11) {
            this._mode = 3;
            this._audio_source = 7;
            this._stream_type = 0;
        } else {
            this._mode = 2;
            this._audio_source = 0;
            this._stream_type = 0;
        }
    }

    public int SetMode(int n) {
        this._mode = n;
        this._audioManager.setMode(this._mode);
        return 0;
    }

    public int GetApiLevel() {
        return Build.VERSION.SDK_INT;
    }

    @TargetApi(value=23)
    public int SetRenderDevId(int n) {
        if (Build.VERSION.SDK_INT < 23) {
            return 100;
        }
        int n2 = 0;
        int n3 = 0;
        AudioDeviceInfo[] audioDeviceInfoArray = this._audioManager.getDevices(2);
        int n4 = -1;
        for (int i = 0; i < audioDeviceInfoArray.length; ++i) {
            if (n != audioDeviceInfoArray[i].getId()) continue;
            n4 = i;
            break;
        }
        if (-1 != n4) {
            n2 = audioDeviceInfoArray[n4].getType();
            if (n2 == 7) {
                if (this._audioManager.isBluetoothScoOn()) {
                    this._rndDev.stop();
                    this._rndDev.setPreferredDevice(audioDeviceInfoArray[n4]);
                    this._rndDev.play();
                } else {
                    n3 = 2;
                }
            } else if (n2 == 8) {
                if (!this._audioManager.isBluetoothScoOn()) {
                    this._rndDev.stop();
                    this._rndDev.setPreferredDevice(audioDeviceInfoArray[n4]);
                    this._rndDev.play();
                } else {
                    n3 = 3;
                }
            } else {
                this._rndDev.stop();
                this._rndDev.setPreferredDevice(audioDeviceInfoArray[n4]);
                this._rndDev.play();
            }
        } else {
            this._rndDev.stop();
            this._rndDev.setPreferredDevice(null);
            this._rndDev.play();
            n3 = 1;
        }
        return n3 |= n2 << 16;
    }

    @TargetApi(value=23)
    public int SetCaptureDevId(int n) {
        if (Build.VERSION.SDK_INT < 23) {
            return 100;
        }
        int n2 = 0;
        int n3 = 0;
        AudioDeviceInfo[] audioDeviceInfoArray = this._audioManager.getDevices(1);
        int n4 = -1;
        for (int i = 0; i < audioDeviceInfoArray.length; ++i) {
            if (n != audioDeviceInfoArray[i].getId()) continue;
            n4 = i;
            break;
        }
        if (-1 != n4) {
            n2 = audioDeviceInfoArray[n4].getType();
            if (n2 == 7) {
                if (this._audioManager.isBluetoothScoOn()) {
                    this._capDev.stop();
                    this._capDev.setPreferredDevice(audioDeviceInfoArray[n4]);
                    this._capDev.startRecording();
                } else {
                    n3 = 2;
                }
            } else {
                this._capDev.stop();
                this._capDev.setPreferredDevice(audioDeviceInfoArray[n4]);
                this._capDev.startRecording();
            }
        } else {
            this._capDev.stop();
            this._capDev.setPreferredDevice(null);
            this._capDev.startRecording();
            n3 = 1;
        }
        return n3 |= n2 << 16;
    }

    @TargetApi(value=23)
    public boolean IsHeadSetOn() {
        if (Build.VERSION.SDK_INT < 23) {
            return this._audioManager.isWiredHeadsetOn();
        }
        boolean bl = false;
        AudioDeviceInfo[] audioDeviceInfoArray = this._audioManager.getDevices(2);
        for (int i = 0; i < audioDeviceInfoArray.length; ++i) {
            int n = audioDeviceInfoArray[i].getType();
            if (n != 3 && n != 4 && n != 22) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public int SetAudioSource(int n) {
        this._audio_source = n;
        return 0;
    }

    public int SetStreamType(int n) {
        this._stream_type = n;
        return 0;
    }

    public int GetStreamVolume() {
        return this._audioManager.getStreamVolume(this._stream_type);
    }

    private int CheckPhoneState() {
        this._handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                try {
                    TelephonyManager telephonyManager = (TelephonyManager)AudioDevice.this._context.getSystemService("phone");
                    int n = telephonyManager.getCallState();
                    if (n == 0 && AudioDevice.this._isCalling) {
                        Log.w(AudioDevice.TAG, "trace interruption check call state idle, resume");
                        AudioDevice.this._isCalling = false;
                        if (AudioDevice.this._pthis != 0L && AudioDevice.this._isListening.get()) {
                            AudioDevice.OnInterruptionEnd(AudioDevice.this._pthis);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Log.e(AudioDevice.TAG, "CheckPhoneState failed, " + throwable);
                }
            }
        }, 500L);
        return 0;
    }

    private void InitPhoneStateListener() {
        this._handler.post(new Runnable(){

            @Override
            public void run() {
                AudioDevice.this._isCalling = false;
                AudioDevice.this._phoneStateListener = new PhoneStateListener(){

                    public void onCallStateChanged(int n, String string) {
                        super.onCallStateChanged(n, string);
                        Log.i(AudioDevice.TAG, "trace interruption on call state changed: " + n + ", num: " + (string != null ? string : "null"));
                        if (AudioDevice.this._pthis != 0L && AudioDevice.this._isListening.get()) {
                            switch (n) {
                                case 0: {
                                    if (!AudioDevice.this._isCalling) break;
                                    AudioDevice.this._isCalling = false;
                                    AudioDevice.OnInterruptionEnd(AudioDevice.this._pthis);
                                    break;
                                }
                                case 1: {
                                    AudioDevice.this._isCalling = true;
                                    AudioDevice.OnInterruptionBegin(AudioDevice.this._pthis);
                                    break;
                                }
                                case 2: {
                                    AudioDevice.this._isCalling = true;
                                    AudioDevice.OnInterruptionBegin(AudioDevice.this._pthis);
                                }
                            }
                        }
                    }
                };
                try {
                    TelephonyManager telephonyManager = (TelephonyManager)AudioDevice.this._context.getSystemService("phone");
                    int n = telephonyManager.getCallState();
                    telephonyManager.listen(AudioDevice.this._phoneStateListener, 32);
                    Log.i(AudioDevice.TAG, "trace interruption init call state: " + n);
                }
                catch (Throwable throwable) {
                    Log.e(AudioDevice.TAG, "InitPhoneStateListener failed, " + throwable);
                    AudioDevice.this._phoneStateListener = null;
                }
            }
        });
    }

    private void UninitPhoneStateListener() {
        this._handler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (AudioDevice.this._phoneStateListener != null) {
                        Log.i(AudioDevice.TAG, "trace interruption stop call state listen");
                        TelephonyManager telephonyManager = (TelephonyManager)AudioDevice.this._context.getSystemService("phone");
                        telephonyManager.listen(AudioDevice.this._phoneStateListener, 0);
                        AudioDevice.this._phoneStateListener = null;
                    }
                }
                catch (Throwable throwable) {
                    Log.e(AudioDevice.TAG, "UninitPhoneStateListener failed, " + throwable);
                }
            }
        });
    }

    private void InitAudioFocusChangeListener() {
        this._audioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

            public void onAudioFocusChange(int n) {
                if (AudioDevice.this._pthis != 0L && AudioDevice.this._isListening.get()) {
                    AudioDevice.OnAudioFocusChange(AudioDevice.this._pthis, n);
                }
            }
        };
        try {
            int n = this._audioManager.requestAudioFocus(this._audioFocusChangeListener, 0, 1);
            String string = "";
            switch (n) {
                case 0: {
                    string = "FAILED";
                    break;
                }
                case 1: {
                    string = "GRANTED";
                    break;
                }
                case 2: {
                    string = "DELAYED";
                    break;
                }
                default: {
                    string = "UNKNOWN";
                }
            }
            Log.i(TAG, "trace interruption request audio focus status: " + n + "(" + string + ")");
        }
        catch (Throwable throwable) {
            Log.e(TAG, "trace interruption request audio focus failed, " + throwable.getMessage());
            this._audioManager.abandonAudioFocus(this._audioFocusChangeListener);
            this._audioFocusChangeListener = null;
        }
    }

    private void UninitAudioFocusChangeListener() {
        try {
            if (this._audioFocusChangeListener != null) {
                this._audioManager.abandonAudioFocus(this._audioFocusChangeListener);
                this._audioFocusChangeListener = null;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @TargetApi(value=21)
    private boolean DetectUsbDeviceState(Context context) {
        boolean bl = false;
        try {
            UsbManager usbManager = (UsbManager)context.getSystemService("usb");
            HashMap hashMap = usbManager.getDeviceList();
            for (Map.Entry entry : hashMap.entrySet()) {
                UsbDevice usbDevice = (UsbDevice)entry.getValue();
                if (null == usbDevice) continue;
                block3: for (int i = 0; !bl && i < usbDevice.getConfigurationCount(); ++i) {
                    UsbConfiguration usbConfiguration = usbDevice.getConfiguration(i);
                    if (null == usbConfiguration) continue;
                    for (int j = 0; j < usbConfiguration.getInterfaceCount(); ++j) {
                        UsbInterface usbInterface = usbConfiguration.getInterface(j);
                        if (null == usbInterface || 1 != usbInterface.getInterfaceClass()) continue;
                        bl = true;
                        continue block3;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return bl;
    }

    @TargetApi(value=21)
    private boolean HasUsbAudioDevice(Intent intent) {
        boolean bl = false;
        UsbDevice usbDevice = (UsbDevice)intent.getParcelableExtra(TAG);
        if (usbDevice != null) {
            int n = usbDevice.getConfigurationCount();
            block0: for (int i = 0; !bl && i < n; ++i) {
                UsbConfiguration usbConfiguration = usbDevice.getConfiguration(i);
                if (null == usbConfiguration) continue;
                int n2 = usbConfiguration.getInterfaceCount();
                for (int j = 0; j < n2; ++j) {
                    UsbInterface usbInterface = usbConfiguration.getInterface(j);
                    if (null == usbInterface || usbInterface.getInterfaceClass() != 1) continue;
                    bl = true;
                    continue block0;
                }
            }
        }
        return bl;
    }

    private static native void OnDeviceStateInited(long var0, boolean var2, boolean var3, boolean var4);

    private static native void OnDeviceStateChanged(long var0, int var2, boolean var3);

    private static native void OnInterruptionBegin(long var0);

    private static native void OnInterruptionEnd(long var0);

    private static native void OnAudioFocusChange(long var0, int var2);

    public void onReceive(Context context, Intent intent) {
        boolean bl;
        if (this._pthis == 0L) {
            return;
        }
        String string = intent.getAction();
        Bundle bundle = intent.getExtras();
        String string2 = "action: " + string + (bundle != null && bundle.size() > 0 ? ", " + bundle.toString() : "");
        Log.i(TAG, "onReceive " + string2);
        if ("android.intent.action.HEADSET_PLUG".equals(string)) {
            if (intent.hasExtra("state")) {
                int n = intent.getIntExtra("state", 0);
                AudioDevice.OnDeviceStateChanged(this._pthis, 1, n == 1);
            }
        } else if ("android.bluetooth.adapter.action.STATE_CHANGED".equals(string)) {
            int n = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
            if (n == 10) {
                ++this._bluetoothOpSeq;
                AudioDevice.OnDeviceStateChanged(this._pthis, 2, false);
            }
        } else if ("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED".equals(string)) {
            int n = intent.getIntExtra("android.bluetooth.profile.extra.STATE", Integer.MIN_VALUE);
            if (n == 2) {
                ++this._bluetoothOpSeq;
                final int n2 = this._bluetoothOpSeq;
                new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (AudioDevice.this._pthis == 0L) {
                            return;
                        }
                        if (AudioDevice.this._bluetoothOpSeq == n2) {
                            AudioDevice.OnDeviceStateChanged(AudioDevice.this._pthis, 2, true);
                        }
                    }
                }, 1500L);
            } else if (n == 0) {
                ++this._bluetoothOpSeq;
                AudioDevice.OnDeviceStateChanged(this._pthis, 2, false);
            }
        } else if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(string)) {
            boolean bl2 = this.HasUsbAudioDevice(intent);
            if (bl2) {
                AudioDevice.OnDeviceStateChanged(this._pthis, 3, true);
            }
        } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(string) && (bl = this.HasUsbAudioDevice(intent))) {
            AudioDevice.OnDeviceStateChanged(this._pthis, 3, false);
        }
    }

    private boolean IsSupportRoutingChangedListener() {
        return Build.VERSION.SDK_INT > 23;
    }

    public int Init(long l, boolean bl) {
        BluetoothAdapter bluetoothAdapter;
        if (this._context == null) {
            return -1;
        }
        this._pthis = l;
        try {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        catch (Throwable throwable) {
            Log.e(TAG, "getSystemService failed, " + throwable.getMessage());
            return -1;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            bl2 = this.IsHeadSetOn();
            if (Build.VERSION.SDK_INT >= 21) {
                bl4 = this.DetectUsbDeviceState(this._context);
            }
            if (null != (bluetoothAdapter = BluetoothAdapter.getDefaultAdapter())) {
                int n = bluetoothAdapter.getProfileConnectionState(1);
                bl3 = n == 2;
            }
        }
        catch (Throwable throwable) {
            Log.w(TAG, "init device state, " + throwable.getMessage(), throwable);
        }
        AudioDevice.OnDeviceStateInited(this._pthis, bl2, bl3, bl4);
        bluetoothAdapter = new IntentFilter();
        bluetoothAdapter.addAction("android.intent.action.HEADSET_PLUG");
        bluetoothAdapter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        bluetoothAdapter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        if (Build.VERSION.SDK_INT >= 21) {
            bluetoothAdapter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
            bluetoothAdapter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        }
        this._context.registerReceiver((BroadcastReceiver)this, (IntentFilter)bluetoothAdapter);
        if (Build.VERSION.SDK_INT >= 17) {
            String string;
            String string2 = this._audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
            if (string2 != null) {
                this._NativeOutputSampleRate = Integer.parseInt(string2);
            }
            if ((string = this._audioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER")) != null) {
                this._framesPerBuffer = Integer.parseInt(string);
            }
        }
        this._capSampleRate = 32000;
        this._rndSampleRate = this._NativeOutputSampleRate;
        String string = Build.MANUFACTURER;
        if ("HUAWEI".equals(string)) {
            this._deviceManufacturer = 1;
        } else if (string.trim().contains("vivo")) {
            this._deviceManufacturer = 2;
        } else if (string.trim().contains("OPPO")) {
            this._deviceManufacturer = 3;
        } else if (string.equals("Xiaomi") && Build.MODEL.equals("Redmi Note 5")) {
            this._deviceManufacturer = -1;
        }
        if (this.IsSupportRoutingChangedListener()) {
            this._routingChangedListener = new RoutingChangedListener();
        }
        this._isListening.set(true);
        this.InitPhoneStateListener();
        if (bl) {
            this.InitAudioFocusChangeListener();
        }
        return 0;
    }

    public int Uninit() {
        this._context.unregisterReceiver((BroadcastReceiver)this);
        this.UninitAudioFocusChangeListener();
        this.UninitPhoneStateListener();
        if (this._audioManager != null) {
            try {
                this._audioManager.setMode(0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this._isListening.set(false);
        this._pthis = 0L;
        return 0;
    }

    public int InitRndDev(int n) {
        if (this._rndDev != null) {
            return 0;
        }
        int n2 = AudioTrack.getMinBufferSize((int)this._rndSampleRate, (int)n, (int)2);
        this._rndDev = this.createAudioTrack(2 * n2, n);
        if (this._rndDev == null) {
            this._rndDev = this.createAudioTrack(2 * n2, n);
        }
        if (this._rndDev != null) {
            if (this.IsSupportRoutingChangedListener()) {
                this._rndDev.addOnRoutingChangedListener((AudioRouting.OnRoutingChangedListener)((RoutingChangedListener)this._routingChangedListener), null);
            }
            return 0;
        }
        return -1;
    }

    public int InitRndDevMono() {
        return this.InitRndDev(4);
    }

    public int InitRndDevStereo() {
        return this.InitRndDev(12);
    }

    public int StartRndDev() {
        if (this._rndDev == null) {
            return -1;
        }
        try {
            this._rndDev.play();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
        return 0;
    }

    public int DoRnd(int n) {
        int n2 = 0;
        try {
            this._rndBuf.rewind();
            this._rndBuf.get(this._rndBufArray, 0, this._rndBuf.capacity());
            if (null != this._rndDev) {
                n2 = this._rndDev.write(this._rndBufArray, 0, n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
        return n2;
    }

    public int StopRndDev() {
        try {
            this._rndDev.stop();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 0;
    }

    public int UninitRndDev() {
        if (this._rndDev != null) {
            try {
                if (this.IsSupportRoutingChangedListener()) {
                    this._rndDev.removeOnRoutingChangedListener((AudioRouting.OnRoutingChangedListener)((RoutingChangedListener)this._routingChangedListener));
                }
                this._rndDev.release();
                this._rndDev = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return 0;
    }

    public int InitCapDev(int n) {
        if (this._capDev != null) {
            return 0;
        }
        int n2 = -1;
        int n3 = 0;
        if (this._capProfile == 0) {
            if (this._audio_source == 7) {
                n3 = 1;
            }
        } else {
            n3 = this._capProfile;
        }
        int n4 = 16;
        if (n == 2) {
            n4 = 12;
        }
        for (int i = n3; i < this._capSampleRateTable.length; ++i) {
            this._capSampleRate = this._capSampleRateTable[i];
            int n5 = AudioRecord.getMinBufferSize((int)this._capSampleRate, (int)n4, (int)2);
            if (n5 < this._capSampleRate * n) {
                n5 = this._capSampleRate * n;
            }
            try {
                this._capDev = new AudioRecord(this._audio_source, this._capSampleRate, n4, 2, n5);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            if (this._capDev == null) continue;
            if (this._capDev.getState() == 1) {
                if (this.IsSupportRoutingChangedListener()) {
                    this._capDev.addOnRoutingChangedListener((AudioRouting.OnRoutingChangedListener)((RoutingChangedListener)this._routingChangedListener), null);
                }
                n2 = 0;
                break;
            }
            Log.w(TAG, "AudioRecord state is not AudioRecord.STATE_INITIALIZED\n");
            this._capDev.release();
            this._capDev = null;
            n2 = 1;
            break;
        }
        return n2;
    }

    public int StartCapDev() {
        if (this._capDev == null) {
            return -1;
        }
        try {
            this._capDev.startRecording();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -2;
        }
        if (this._capDev.getRecordingState() != 3) {
            return -3;
        }
        return 0;
    }

    public int DoCap(int n) {
        int n2 = -1;
        try {
            n2 = this._capDev.read(this._capBuf, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
        return n2;
    }

    public int StopCapDev() {
        try {
            this._capDev.stop();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 0;
    }

    public int UninitCapDev() {
        if (this._capDev != null) {
            try {
                if (this.IsSupportRoutingChangedListener()) {
                    this._capDev.removeOnRoutingChangedListener((AudioRouting.OnRoutingChangedListener)((RoutingChangedListener)this._routingChangedListener));
                }
                this._capDev.release();
                this._capDev = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return 0;
    }

    public int SetSpeakerphoneOn(int n) {
        try {
            this._audioManager.setSpeakerphoneOn(n != 0);
        }
        catch (Exception exception) {
            Log.e(TAG, "setSpeakerphoneOn failed, " + exception.getMessage());
            return -1;
        }
        return 0;
    }

    AudioTrack createAudioTrack(int n, int n2) {
        AudioTrack audioTrack;
        block3: {
            audioTrack = null;
            try {
                audioTrack = new AudioTrack(this._stream_type, this._rndSampleRate, n2, 2, n, 1);
                if (audioTrack.getState() != 1) {
                    audioTrack.release();
                    audioTrack = null;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (audioTrack == null) break block3;
                audioTrack.release();
                audioTrack = null;
            }
        }
        return audioTrack;
    }

    public int SetThreadUrgentPriority() {
        try {
            Process.setThreadPriority((int)-19);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
        return 0;
    }

    public int SetBluetoothScoOn(boolean bl) {
        if (this._audioManager == null) {
            return 0;
        }
        try {
            if (bl) {
                this._audioManager.startBluetoothSco();
                this._audioManager.setBluetoothScoOn(bl);
            } else {
                this._audioManager.setBluetoothScoOn(bl);
                this._audioManager.stopBluetoothSco();
            }
        }
        catch (Exception exception) {
            Log.e(TAG, "setBluetoothScoOn failed, " + exception.getMessage());
            return -1;
        }
        return 0;
    }

    public int GetPlayoutSampleRate() {
        return this._rndSampleRate;
    }

    public int GetRecordingSampleRate() {
        return this._capSampleRate;
    }

    public int GetOutputFramePerBuffer() {
        return this._framesPerBuffer;
    }

    public int SetCapProfile(int n) {
        this._capProfile = n;
        return 0;
    }

    public int CheckPermission() {
        return PermissionChecker.checkSelfPermission(this._context, "android.permission.RECORD_AUDIO") ? 1 : 0;
    }

    public int GetDeviceManufacturer() {
        return this._deviceManufacturer;
    }

    @TargetApi(value=17)
    public int SupportHWKaraokeLowlatency() {
        PackageManager packageManager;
        boolean bl;
        if (Build.VERSION.SDK_INT < 17) {
            return -1;
        }
        if (Build.VERSION.SDK_INT >= 29) {
            this._hwAudioKit = new HwAudioKit(this._context);
            if (!this._hwAudioKit.initialize()) {
                this._hwAudioKit.destroy();
                this._hwAudioKit = null;
                return -1;
            }
            this._hwAudioKit.createFeatureKaraoke();
        }
        if (this._hwAudioKit != null && this._hwAudioKit.isFeatureKaraokeOn()) {
            return 1;
        }
        String string = this._audioManager.getProperty("android.media.property.SUPPORT_HWKARAOKE_EFFECT");
        if ("true".equals(string) && (bl = (packageManager = this._context.getPackageManager()).hasSystemFeature("android.hardware.audio.low_latency"))) {
            return 0;
        }
        return -1;
    }

    public int EnableHWKaraoke(int n) {
        Log.i(TAG, "EnableHWKaraoke " + n);
        if (this._hwAudioKit != null) {
            if (!this._hwAudioKit.isFeatureKaraokeOn()) {
                this._hwAudioKit.destroy();
                this._hwAudioKit = null;
                this._hwAudioKit = new HwAudioKit(this._context);
                this._hwAudioKit.initialize();
                this._hwAudioKit.createFeatureKaraoke();
            }
            this._hwAudioKit.enableKaraokeFeature(n == 1);
            if (n == 1) {
                this._hwAudioKit.setKaraokeVolume(50);
            }
        }
        return 0;
    }

    public int UninitHWKtvEnv() {
        if (this._deviceManufacturer == 1 && this._hwAudioKit != null) {
            this._hwAudioKit.destroy();
            this._hwAudioKit = null;
        }
        return 0;
    }

    public int InitVivoKtvEnv() {
        this._audioManager.setParameters("vivo_ktv_play_source=1");
        this._audioManager.setParameters("vivo_ktv_mode=1");
        if (this._silentPlayer == null) {
            this._silentPlayer = new SilentPlayer(this._rndSampleRate);
        }
        if (this._silentPlayer != null && !this._silentPlayer.isPlaying()) {
            this._silentPlayer.play();
        }
        this._initVivoKtv = true;
        return 0;
    }

    public int UninitVivoKtvEnv() {
        if (this._initVivoKtv) {
            if (this._silentPlayer != null) {
                this._silentPlayer.stop();
                this._silentPlayer = null;
            }
            this._initVivoKtv = false;
            this._audioManager.setParameters("vivo_ktv_mode=0");
        }
        return 0;
    }

    public int SupportVivoKaraokeLowlatency() {
        String string;
        int n;
        String string2 = this._audioManager.getParameters("vivo_ktv_mic_type");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "=");
        int n2 = stringTokenizer.countTokens();
        if (n2 != 2) {
            stringTokenizer = null;
            return -1;
        }
        String string3 = stringTokenizer.nextToken();
        if (string3.equals("vivo_ktv_mic_type") && ((n = Integer.parseInt(string = stringTokenizer.nextToken())) == 1 || n == 0)) {
            if (Build.VERSION.SDK_INT >= 27) {
                stringTokenizer = null;
                return 0;
            }
            return 1;
        }
        stringTokenizer = null;
        return -1;
    }

    public class SilentPlayer {
        private int mSampleRate;
        private int mChannelConfig = 12;
        private int mAudioFormat = 2;
        private PlaybackThread mPlaybackThread;
        private boolean mIsPlaying = false;

        public SilentPlayer(int n) {
            this.mSampleRate = n;
        }

        public boolean isPlaying() {
            return this.mIsPlaying;
        }

        public void play() {
            if (this.mIsPlaying) {
                return;
            }
            if (this.mPlaybackThread == null) {
                this.mIsPlaying = true;
                this.mPlaybackThread = new PlaybackThread();
                this.mPlaybackThread.start();
            }
        }

        public void stop() {
            if (this.mPlaybackThread != null) {
                this.mIsPlaying = false;
                this.mPlaybackThread.closeThread();
                try {
                    this.mPlaybackThread.join(200L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.mPlaybackThread = null;
            }
        }

        class PlaybackThread
        extends Thread {
            private boolean isStop = false;

            PlaybackThread() {
            }

            public synchronized void closeThread() {
                this.isStop = true;
            }

            @Override
            public void run() {
                int n = AudioTrack.getMinBufferSize((int)SilentPlayer.this.mSampleRate, (int)SilentPlayer.this.mChannelConfig, (int)SilentPlayer.this.mAudioFormat);
                AudioTrack audioTrack = new AudioTrack(3, SilentPlayer.this.mSampleRate, SilentPlayer.this.mChannelConfig, SilentPlayer.this.mAudioFormat, n, 1);
                if (audioTrack != null) {
                    audioTrack.play();
                    byte[] byArray = new byte[n];
                    for (int i = 0; i < byArray.length; ++i) {
                        byArray[i] = 0;
                    }
                    while (!this.isStop && !this.isInterrupted()) {
                        try {
                            audioTrack.write(byArray, 0, byArray.length);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            break;
                        }
                    }
                    audioTrack.stop();
                    audioTrack.flush();
                    audioTrack.release();
                    audioTrack = null;
                }
            }
        }
    }
}

