/*
 * Decompiled with CFR 0.152.
 */
package im.zego.zegoexpress.internal;

import im.zego.zegoexpress.ZegoMediaPlayer;
import im.zego.zegoexpress.callback.IZegoMediaPlayerAudioHandler;
import im.zego.zegoexpress.callback.IZegoMediaPlayerEventHandler;
import im.zego.zegoexpress.callback.IZegoMediaPlayerLoadResourceCallback;
import im.zego.zegoexpress.callback.IZegoMediaPlayerSeekToCallback;
import im.zego.zegoexpress.constants.ZegoAudioChannel;
import im.zego.zegoexpress.constants.ZegoAudioSampleRate;
import im.zego.zegoexpress.constants.ZegoMediaPlayerNetworkEvent;
import im.zego.zegoexpress.constants.ZegoMediaPlayerState;
import im.zego.zegoexpress.constants.ZegoVideoFrameFormat;
import im.zego.zegoexpress.entity.ZegoAudioFrameParam;
import im.zego.zegoexpress.entity.ZegoVideoFrameParam;
import im.zego.zegoexpress.internal.ZegoMediaPlayerInternalImpl;
import im.zego.zegoexpress.utils.ZegoCallbackHelpers;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

class ZegoMediaPlayerJniCallback {
    ZegoMediaPlayerJniCallback() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onMediaPlayerVideoHandlerCallback(int idx, ByteBuffer[] buffer, int[] datalength, int[] strides, int format, int width, int height) {
        ZegoVideoFrameParam videoFrameParam = new ZegoVideoFrameParam();
        videoFrameParam.height = height;
        for (int i = 0; i < strides.length; ++i) {
            videoFrameParam.strides[i] = strides[i];
        }
        videoFrameParam.width = width;
        videoFrameParam.format = ZegoVideoFrameFormat.values()[format];
        Class<ZegoMediaPlayerInternalImpl> clazz = ZegoMediaPlayerInternalImpl.class;
        synchronized (ZegoMediaPlayerInternalImpl.class) {
            HashMap<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> mMediaplayerToIdxAndEventhandler = ZegoMediaPlayerInternalImpl.mediaplayerToIdxAndEventhandler;
            for (Map.Entry<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> item : mMediaplayerToIdxAndEventhandler.entrySet()) {
                if (item.getValue().kMediaPlayerIdx != idx) continue;
                Object mediaPlayerVideoHandler = item.getValue().videoHandler;
                if (mediaPlayerVideoHandler == null) {
                    // ** MonitorExit[var8_9] (shouldn't be in output)
                    return;
                }
                ZegoCallbackHelpers.callMediaVideoFrameMethod(mediaPlayerVideoHandler, item.getKey(), buffer, datalength, videoFrameParam);
            }
            // ** MonitorExit[var8_9] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onMediaPlayerAudioHandlerCallback(int idx, ByteBuffer buffer, int bufferLength, int channel, int samplesRate) {
        ZegoAudioFrameParam audioFrame = new ZegoAudioFrameParam();
        audioFrame.channel = ZegoAudioChannel.values()[channel];
        audioFrame.sampleRate = ZegoAudioSampleRate.getZegoAudioSampleRate(samplesRate);
        Class<ZegoMediaPlayerInternalImpl> clazz = ZegoMediaPlayerInternalImpl.class;
        synchronized (ZegoMediaPlayerInternalImpl.class) {
            HashMap<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> mMediaplayerToIdxAndEventhandler = ZegoMediaPlayerInternalImpl.mediaplayerToIdxAndEventhandler;
            for (Map.Entry<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> item : mMediaplayerToIdxAndEventhandler.entrySet()) {
                if (item.getValue().kMediaPlayerIdx != idx) continue;
                IZegoMediaPlayerAudioHandler mediaPlayerAudioHandler = item.getValue().audioHandler;
                if (mediaPlayerAudioHandler == null) {
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    return;
                }
                mediaPlayerAudioHandler.onAudioFrame(item.getKey(), buffer, bufferLength, audioFrame);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onLoadResourceCallback(int idx, final int errorcode) {
        Class<ZegoMediaPlayerInternalImpl> clazz = ZegoMediaPlayerInternalImpl.class;
        synchronized (ZegoMediaPlayerInternalImpl.class) {
            HashMap<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> mMediaplayerToIdxAndEventhandler = ZegoMediaPlayerInternalImpl.mediaplayerToIdxAndEventhandler;
            for (Map.Entry<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> item : mMediaplayerToIdxAndEventhandler.entrySet()) {
                if (item.getValue().kMediaPlayerIdx != idx) continue;
                final IZegoMediaPlayerLoadResourceCallback iZegoMediaPlayerLoadResourceCallback = item.getValue().loadResourceCallback;
                if (iZegoMediaPlayerLoadResourceCallback == null) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                ZegoMediaPlayerInternalImpl.mUIHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        iZegoMediaPlayerLoadResourceCallback.onLoadResourceCallback(errorcode);
                    }
                });
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onSeekToTimeCallback(final int seq, int idx, final int errorcode) {
        Class<ZegoMediaPlayerInternalImpl> clazz = ZegoMediaPlayerInternalImpl.class;
        synchronized (ZegoMediaPlayerInternalImpl.class) {
            HashMap<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> mMediaplayerToIdxAndEventhandler = ZegoMediaPlayerInternalImpl.mediaplayerToIdxAndEventhandler;
            for (final Map.Entry<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> item : mMediaplayerToIdxAndEventhandler.entrySet()) {
                if (item.getValue().kMediaPlayerIdx != idx) continue;
                final IZegoMediaPlayerSeekToCallback seekToTimeCallback = item.getValue().seekToTimeCallbackHashMap.get(seq);
                if (seekToTimeCallback == null) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                ZegoMediaPlayerInternalImpl.mUIHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        seekToTimeCallback.onSeekToTimeCallback(errorcode);
                        ((ZegoMediaPlayerInternalImpl.IdxAndHandler)item.getValue()).seekToTimeCallbackHashMap.remove(seq);
                    }
                });
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onMediaPlayerStateUpdateCallback(int state, final int errorcode, int idx) {
        final ZegoMediaPlayerState zegoMediaPlayerState = ZegoMediaPlayerState.values()[state];
        Class<ZegoMediaPlayerInternalImpl> clazz = ZegoMediaPlayerInternalImpl.class;
        synchronized (ZegoMediaPlayerInternalImpl.class) {
            HashMap<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> mMediaplayerToIdxAndEventhandler = ZegoMediaPlayerInternalImpl.mediaplayerToIdxAndEventhandler;
            for (final Map.Entry<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> item : mMediaplayerToIdxAndEventhandler.entrySet()) {
                if (item.getValue().kMediaPlayerIdx != idx) continue;
                final IZegoMediaPlayerEventHandler iZegoMediaPlayerEventHandler = item.getValue().eventHandler;
                if (iZegoMediaPlayerEventHandler == null) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                ZegoMediaPlayerInternalImpl.mUIHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        iZegoMediaPlayerEventHandler.onMediaPlayerStateUpdate((ZegoMediaPlayer)item.getKey(), zegoMediaPlayerState, errorcode);
                    }
                });
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onMediaPlayerNetWorkEventCallback(int event, int idx) {
        final ZegoMediaPlayerNetworkEvent zegoMediaPlayerNetworkEvent = ZegoMediaPlayerNetworkEvent.values()[event];
        Class<ZegoMediaPlayerInternalImpl> clazz = ZegoMediaPlayerInternalImpl.class;
        synchronized (ZegoMediaPlayerInternalImpl.class) {
            HashMap<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> mMediaplayerToIdxAndEventhandler = ZegoMediaPlayerInternalImpl.mediaplayerToIdxAndEventhandler;
            for (final Map.Entry<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> item : mMediaplayerToIdxAndEventhandler.entrySet()) {
                if (item.getValue().kMediaPlayerIdx != idx) continue;
                final IZegoMediaPlayerEventHandler iZegoMediaPlayerEventHandler = item.getValue().eventHandler;
                if (iZegoMediaPlayerEventHandler == null) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                ZegoMediaPlayerInternalImpl.mUIHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        iZegoMediaPlayerEventHandler.onMediaPlayerNetworkEvent((ZegoMediaPlayer)item.getKey(), zegoMediaPlayerNetworkEvent);
                    }
                });
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onMediaPlayerPlayingProgressCallback(int idx, final long millisecond) {
        Class<ZegoMediaPlayerInternalImpl> clazz = ZegoMediaPlayerInternalImpl.class;
        synchronized (ZegoMediaPlayerInternalImpl.class) {
            HashMap<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> mMediaplayerToIdxAndEventhandler = ZegoMediaPlayerInternalImpl.mediaplayerToIdxAndEventhandler;
            for (final Map.Entry<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> item : mMediaplayerToIdxAndEventhandler.entrySet()) {
                if (item.getValue().kMediaPlayerIdx != idx) continue;
                final IZegoMediaPlayerEventHandler iZegoMediaPlayerEventHandler = item.getValue().eventHandler;
                if (iZegoMediaPlayerEventHandler == null) {
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return;
                }
                ZegoMediaPlayerInternalImpl.mUIHandler.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Class<ZegoMediaPlayerInternalImpl> clazz = ZegoMediaPlayerInternalImpl.class;
                        synchronized (ZegoMediaPlayerInternalImpl.class) {
                            iZegoMediaPlayerEventHandler.onMediaPlayerPlayingProgress((ZegoMediaPlayer)item.getKey(), millisecond);
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                });
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }
}

