package im.zego.zegoexpress.callback;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import im.zego.zegoexpress.internal.*;
import android.app.Application;
import android.graphics.*;

public abstract class IZegoAudioEffectPlayerEventHandler {

    /**
     * Audio effect playback state callback.
     *
     * This callback is triggered when the playback state of a audio effect of the audio effect player changes.
     *
     * @param audioEffectPlayer Audio effect player instance that triggers this callback
     * @param audioEffectID The ID of the audio effect resource that triggered this callback
     * @param state The playback state of the audio effect
     * @param errorCode Error code, please refer to the Error Codes https://doc-en.zego.im/en/308.html for details
     */
    public void onAudioEffectPlayStateUpdate(ZegoAudioEffectPlayer audioEffectPlayer, int audioEffectID, ZegoAudioEffectPlayState state, int errorCode){

    }

}

