package im.zego.zegoexpress.constants;

/** Voice changer preset value. */
public enum ZegoVoiceChangerPreset {
    /** No Voice changer */
    NONE(0),
    /** Male to child voice (loli voice effect) */
    MEN_TO_CHILD(1),
    /** Male to female voice (kindergarten voice effect) */
    MEN_TO_WOMEN(2),
    /** Female to child voice */
    WOMEN_TO_CHILD(3),
    /** Female to male voice */
    WOMEN_TO_MEN(4),
    /** Foreigner voice effect */
    FOREIGNER(5),
    /** Autobot Optimus Prime voice effect */
    OPTIMUS_PRIME(6),
    /** Android robot voice effect */
    ANDROID(7),
    /** Ethereal voice effect */
    ETHEREAL(8);

    private int value;

    private ZegoVoiceChangerPreset(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ZegoVoiceChangerPreset getZegoVoiceChangerPreset(int value) {
        try {

            if (NONE.value == value) {
                return NONE;
            }

            if (MEN_TO_CHILD.value == value) {
                return MEN_TO_CHILD;
            }

            if (MEN_TO_WOMEN.value == value) {
                return MEN_TO_WOMEN;
            }

            if (WOMEN_TO_CHILD.value == value) {
                return WOMEN_TO_CHILD;
            }

            if (WOMEN_TO_MEN.value == value) {
                return WOMEN_TO_MEN;
            }

            if (FOREIGNER.value == value) {
                return FOREIGNER;
            }

            if (OPTIMUS_PRIME.value == value) {
                return OPTIMUS_PRIME;
            }

            if (ANDROID.value == value) {
                return ANDROID;
            }

            if (ETHEREAL.value == value) {
                return ETHEREAL;
            }

        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
        return null;
    }
}