/*
 * Decompiled with CFR 0.152.
 */
package im.zego.zegoexpress.internal;

import android.os.Handler;
import android.os.Looper;
import im.zego.zegoexpress.ZegoMediaPlayer;
import im.zego.zegoexpress.callback.IZegoMediaPlayerAudioHandler;
import im.zego.zegoexpress.callback.IZegoMediaPlayerEventHandler;
import im.zego.zegoexpress.callback.IZegoMediaPlayerLoadResourceCallback;
import im.zego.zegoexpress.callback.IZegoMediaPlayerSeekToCallback;
import im.zego.zegoexpress.callback.IZegoMediaPlayerVideoHandler;
import im.zego.zegoexpress.constants.ZegoMediaPlayerState;
import im.zego.zegoexpress.constants.ZegoVideoFrameFormat;
import im.zego.zegoexpress.entity.ZegoCanvas;
import im.zego.zegoexpress.internal.ZegoMediaPlayerJniAPI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class ZegoMediaPlayerInternalImpl
extends ZegoMediaPlayer {
    public static Handler mUIHandler = new Handler(Looper.getMainLooper());
    public static HashMap<ZegoMediaPlayer, IdxAndHandler> mediaplayerToIdxAndEventhandler = new HashMap();

    @Override
    public void setEventHandler(IZegoMediaPlayerEventHandler handler) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            idxAndHandler.eventHandler = handler;
        }
    }

    @Override
    public void setVideoHandler(IZegoMediaPlayerVideoHandler handler, ZegoVideoFrameFormat frameFormat) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            idxAndHandler.videoHandler = handler;
            if (handler == null) {
                ZegoMediaPlayerJniAPI.enableVideoDataJni(frameFormat.value(), false, idxAndHandler.kMediaPlayerIdx);
            } else {
                ZegoMediaPlayerJniAPI.enableVideoDataJni(frameFormat.value(), true, idxAndHandler.kMediaPlayerIdx);
            }
        }
    }

    @Override
    public void setAudioHandler(IZegoMediaPlayerAudioHandler handler) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            idxAndHandler.audioHandler = handler;
            if (handler == null) {
                ZegoMediaPlayerJniAPI.enableAudioDataJni(false, idxAndHandler.kMediaPlayerIdx);
            } else {
                ZegoMediaPlayerJniAPI.enableAudioDataJni(true, idxAndHandler.kMediaPlayerIdx);
            }
        }
    }

    @Override
    public void loadResource(String path, IZegoMediaPlayerLoadResourceCallback callback) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJniAPI.loadResourceJni(idxAndHandler.kMediaPlayerIdx, path);
            idxAndHandler.loadResourceCallback = callback;
        }
    }

    @Override
    public int getIndex() {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            return idxAndHandler.kMediaPlayerIdx;
        }
        return 0;
    }

    @Override
    public void start() {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJniAPI.startJni(idxAndHandler.kMediaPlayerIdx);
        }
    }

    @Override
    public void stop() {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJniAPI.stopJni(idxAndHandler.kMediaPlayerIdx);
        }
    }

    @Override
    public void pause() {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJniAPI.pauseJni(idxAndHandler.kMediaPlayerIdx);
        }
    }

    @Override
    public void resume() {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJniAPI.resumeJni(idxAndHandler.kMediaPlayerIdx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void seekTo(long millisecond, IZegoMediaPlayerSeekToCallback callback) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler == null) return;
        int seq = ZegoMediaPlayerJniAPI.seekToJni(idxAndHandler.kMediaPlayerIdx, millisecond);
        Class<ZegoMediaPlayerInternalImpl> clazz = ZegoMediaPlayerInternalImpl.class;
        synchronized (ZegoMediaPlayerInternalImpl.class) {
            idxAndHandler.seekToTimeCallbackHashMap.put(seq, callback);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void enableRepeat(boolean enable) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJniAPI.enableRepeatJni(idxAndHandler.kMediaPlayerIdx, enable);
        }
    }

    @Override
    public void enableAux(boolean enable) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJniAPI.enableAuxJni(idxAndHandler.kMediaPlayerIdx, enable);
        }
    }

    @Override
    public void muteLocal(boolean mute) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJniAPI.muteLocalJni(idxAndHandler.kMediaPlayerIdx, mute);
        }
    }

    @Override
    public void setPlayerCanvas(ZegoCanvas canvas) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            if (canvas != null) {
                ZegoMediaPlayerJniAPI.setPlayerCanvasJni(idxAndHandler.kMediaPlayerIdx, canvas.view, canvas.viewMode.value(), canvas.backgroundColor);
            } else {
                ZegoMediaPlayerJniAPI.setPlayerCanvasJni(idxAndHandler.kMediaPlayerIdx, null, 0, 0);
            }
        }
    }

    @Override
    public void setVolume(int volume) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJniAPI.setVolumeJni(idxAndHandler.kMediaPlayerIdx, volume);
        }
    }

    @Override
    public int getVolume() {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            return ZegoMediaPlayerJniAPI.getVolumeJni(idxAndHandler.kMediaPlayerIdx);
        }
        return -1;
    }

    @Override
    public void setProgressInterval(long millisecond) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJniAPI.setProgressIntervalJni(idxAndHandler.kMediaPlayerIdx, millisecond);
        }
    }

    @Override
    public void setPlayVolume(int volume) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJniAPI.setPlayVolumeJni(idxAndHandler.kMediaPlayerIdx, volume);
        }
    }

    @Override
    public void setPublishVolume(int volume) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJniAPI.setPublishVolumeJni(idxAndHandler.kMediaPlayerIdx, volume);
        }
    }

    @Override
    public int getPlayVolume() {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            return ZegoMediaPlayerJniAPI.getPlayVolumeJni(idxAndHandler.kMediaPlayerIdx);
        }
        return 0;
    }

    @Override
    public int getPublishVolume() {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            return ZegoMediaPlayerJniAPI.getPublishVolumeJni(idxAndHandler.kMediaPlayerIdx);
        }
        return 0;
    }

    @Override
    public long getTotalDuration() {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            return ZegoMediaPlayerJniAPI.getTotalDurationJni(idxAndHandler.kMediaPlayerIdx);
        }
        return -1L;
    }

    @Override
    public long getCurrentProgress() {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            return ZegoMediaPlayerJniAPI.getCurrentProgressJni(idxAndHandler.kMediaPlayerIdx);
        }
        return -1L;
    }

    public static ZegoMediaPlayer createMediaPlayer() {
        int index = ZegoMediaPlayerJniAPI.createMediaPlayerJni();
        if (index >= 0) {
            ZegoMediaPlayerInternalImpl zegoMediaPlayer = new ZegoMediaPlayerInternalImpl();
            IdxAndHandler idxAndHandler = new IdxAndHandler(index);
            idxAndHandler.seekToTimeCallbackHashMap = new HashMap();
            mediaplayerToIdxAndEventhandler.put(zegoMediaPlayer, idxAndHandler);
            return zegoMediaPlayer;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyMediaPlayer(ZegoMediaPlayer mediaplayer) {
        Class<ZegoMediaPlayerInternalImpl> clazz = ZegoMediaPlayerInternalImpl.class;
        synchronized (ZegoMediaPlayerInternalImpl.class) {
            Iterator<Map.Entry<ZegoMediaPlayer, IdxAndHandler>> it = mediaplayerToIdxAndEventhandler.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ZegoMediaPlayer, IdxAndHandler> item = it.next();
                if (item.getKey() != mediaplayer) continue;
                item.getValue().videoHandler = null;
                item.getValue().audioHandler = null;
                item.getValue().eventHandler = null;
                item.getValue().loadResourceCallback = null;
                Iterator<Map.Entry<Integer, IZegoMediaPlayerSeekToCallback>> itSeekToTimeCallbackHashMap = item.getValue().seekToTimeCallbackHashMap.entrySet().iterator();
                while (itSeekToTimeCallbackHashMap.hasNext()) {
                    itSeekToTimeCallbackHashMap.remove();
                }
                item.getValue().seekToTimeCallbackHashMap = null;
                int idx = item.getValue().kMediaPlayerIdx;
                ZegoMediaPlayerJniAPI.destroyMediaPlayerJni(idx);
                it.remove();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyAllMediaPlayer() {
        Class<ZegoMediaPlayerInternalImpl> clazz = ZegoMediaPlayerInternalImpl.class;
        synchronized (ZegoMediaPlayerInternalImpl.class) {
            Iterator<Map.Entry<ZegoMediaPlayer, IdxAndHandler>> it = mediaplayerToIdxAndEventhandler.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ZegoMediaPlayer, IdxAndHandler> item = it.next();
                item.getValue().videoHandler = null;
                item.getValue().audioHandler = null;
                item.getValue().eventHandler = null;
                item.getValue().loadResourceCallback = null;
                Iterator<Map.Entry<Integer, IZegoMediaPlayerSeekToCallback>> itSeekToTimeCallbackHashMap = item.getValue().seekToTimeCallbackHashMap.entrySet().iterator();
                while (itSeekToTimeCallbackHashMap.hasNext()) {
                    itSeekToTimeCallbackHashMap.remove();
                }
                item.getValue().seekToTimeCallbackHashMap = null;
                int idx = item.getValue().kMediaPlayerIdx;
                ZegoMediaPlayerJniAPI.destroyMediaPlayerJni(idx);
                it.remove();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public ZegoMediaPlayerState getCurrentState() {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int state = ZegoMediaPlayerJniAPI.getCurrentStateJni(idxAndHandler.kMediaPlayerIdx);
            ZegoMediaPlayerState zegoMediaPlayerState = state == ZegoMediaPlayerState.NO_PLAY.value() ? ZegoMediaPlayerState.NO_PLAY : (state == ZegoMediaPlayerState.PLAYING.value() ? ZegoMediaPlayerState.PLAYING : (state == ZegoMediaPlayerState.PAUSING.value() ? ZegoMediaPlayerState.PAUSING : (state == ZegoMediaPlayerState.PLAY_ENDED.value() ? ZegoMediaPlayerState.PLAY_ENDED : ZegoMediaPlayerState.NO_PLAY)));
            return zegoMediaPlayerState;
        }
        return ZegoMediaPlayerState.NO_PLAY;
    }

    static class IdxAndHandler {
        int kMediaPlayerIdx;
        HashMap<Integer, IZegoMediaPlayerSeekToCallback> seekToTimeCallbackHashMap;
        IZegoMediaPlayerLoadResourceCallback loadResourceCallback;
        IZegoMediaPlayerEventHandler eventHandler;
        IZegoMediaPlayerAudioHandler audioHandler;
        Object videoHandler;

        IdxAndHandler(int idx) {
            this.kMediaPlayerIdx = idx;
        }
    }
}

