/*
 * Decompiled with CFR 0.152.
 */
package im.zego.zegoexpress.internal;

import android.os.Handler;
import im.zego.zegoexpress.callback.IZegoAudioDataHandler;
import im.zego.zegoexpress.callback.IZegoAudioMixingHandler;
import im.zego.zegoexpress.callback.IZegoCustomAudioProcessHandler;
import im.zego.zegoexpress.callback.IZegoDataRecordEventHandler;
import im.zego.zegoexpress.callback.IZegoDestroyCompletionCallback;
import im.zego.zegoexpress.callback.IZegoEventHandler;
import im.zego.zegoexpress.callback.IZegoIMSendBarrageMessageCallback;
import im.zego.zegoexpress.callback.IZegoIMSendBroadcastMessageCallback;
import im.zego.zegoexpress.callback.IZegoIMSendCustomCommandCallback;
import im.zego.zegoexpress.callback.IZegoMixerStartCallback;
import im.zego.zegoexpress.callback.IZegoMixerStopCallback;
import im.zego.zegoexpress.callback.IZegoPublisherSetStreamExtraInfoCallback;
import im.zego.zegoexpress.callback.IZegoPublisherUpdateCdnUrlCallback;
import im.zego.zegoexpress.callback.IZegoRoomGetReliableMessageCallback;
import im.zego.zegoexpress.callback.IZegoRoomSendReliableMessageCallback;
import im.zego.zegoexpress.callback.IZegoRoomSetRoomExtraInfoCallback;
import im.zego.zegoexpress.constants.ZegoAudioChannel;
import im.zego.zegoexpress.constants.ZegoAudioSampleRate;
import im.zego.zegoexpress.constants.ZegoDataRecordState;
import im.zego.zegoexpress.constants.ZegoDataRecordType;
import im.zego.zegoexpress.constants.ZegoEngineState;
import im.zego.zegoexpress.constants.ZegoPlayerMediaEvent;
import im.zego.zegoexpress.constants.ZegoPlayerState;
import im.zego.zegoexpress.constants.ZegoPublishChannel;
import im.zego.zegoexpress.constants.ZegoPublisherState;
import im.zego.zegoexpress.constants.ZegoRemoteDeviceState;
import im.zego.zegoexpress.constants.ZegoRoomState;
import im.zego.zegoexpress.constants.ZegoUpdateType;
import im.zego.zegoexpress.constants.ZegoVideoEncodedFrameFormat;
import im.zego.zegoexpress.constants.ZegoVideoFlipMode;
import im.zego.zegoexpress.constants.ZegoVideoFrameFormat;
import im.zego.zegoexpress.entity.ZegoAudioFrameParam;
import im.zego.zegoexpress.entity.ZegoAudioMixingData;
import im.zego.zegoexpress.entity.ZegoBarrageMessageInfo;
import im.zego.zegoexpress.entity.ZegoBroadcastMessageInfo;
import im.zego.zegoexpress.entity.ZegoDataRecordConfig;
import im.zego.zegoexpress.entity.ZegoDataRecordProgress;
import im.zego.zegoexpress.entity.ZegoPlayStreamQuality;
import im.zego.zegoexpress.entity.ZegoPublishStreamQuality;
import im.zego.zegoexpress.entity.ZegoReliableMessage;
import im.zego.zegoexpress.entity.ZegoRoomExtraInfo;
import im.zego.zegoexpress.entity.ZegoStream;
import im.zego.zegoexpress.entity.ZegoStreamRelayCDNInfo;
import im.zego.zegoexpress.entity.ZegoUser;
import im.zego.zegoexpress.entity.ZegoVideoEncodedFrameParam;
import im.zego.zegoexpress.entity.ZegoVideoFrameParam;
import im.zego.zegoexpress.internal.ZegoExpressEngineInternalImpl;
import im.zego.zegoexpress.utils.ZegoCallbackHelpers;
import im.zego.zegoexpress.utils.ZegoDebugLevel;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

class ZegoExpressEngineJniCallback {
    static ZegoAudioFrameParam zegoCaptureAudioFrameParam = new ZegoAudioFrameParam();
    static ZegoAudioFrameParam zegoRemoteAudioFrameParam = new ZegoAudioFrameParam();
    static ZegoAudioFrameParam zegoPlaybackAudioFrameParam = new ZegoAudioFrameParam();
    static ZegoAudioFrameParam zegoMixedAudioFrameParam = new ZegoAudioFrameParam();

    ZegoExpressEngineJniCallback() {
    }

    static void onCustomVideoCaptureWillStart(final int channel) {
        Handler handler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (handler == null) {
            return;
        }
        handler.post(new Runnable(){

            @Override
            public void run() {
                Object customVideoCaptureHandler = ZegoExpressEngineInternalImpl.mCustomVideoCaptureHandler;
                if (customVideoCaptureHandler != null) {
                    ZegoCallbackHelpers.callCustomVideoCaptureOnStartMethod(customVideoCaptureHandler, ZegoPublishChannel.getZegoPublishChannel(channel));
                    ZegoExpressEngineInternalImpl.isCustomVideoCapturing = true;
                }
            }
        });
    }

    public static void onCustomVideoCaptureWillStop(final int channel) {
        Handler handler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (handler == null) {
            return;
        }
        handler.post(new Runnable(){

            @Override
            public void run() {
                Object customVideoCaptureHandler = ZegoExpressEngineInternalImpl.mCustomVideoCaptureHandler;
                if (customVideoCaptureHandler != null && ZegoExpressEngineInternalImpl.isCustomVideoCapturing) {
                    ZegoCallbackHelpers.callCustomVideoCaptureOnStopMethod(customVideoCaptureHandler, ZegoPublishChannel.values()[channel]);
                    ZegoExpressEngineInternalImpl.isCustomVideoCapturing = false;
                }
            }
        });
    }

    public static void onRoomStreamUpdate(final String roomID, final int updateType, ZegoStream[] streamList) {
        final ArrayList<ZegoStream> streamArrayList = new ArrayList<ZegoStream>();
        for (int i = 0; i < streamList.length; ++i) {
            streamArrayList.add(streamList[i]);
        }
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onRoomStreamUpdate(roomID, ZegoUpdateType.values()[updateType], streamArrayList);
                }
            }
        });
    }

    public static ZegoAudioMixingData onAudioMixingCopyData(int dataLength) {
        IZegoAudioMixingHandler mZegoAudioMixingHandle = ZegoExpressEngineInternalImpl.iZegoAudioMixingHandler;
        if (mZegoAudioMixingHandle != null) {
            return mZegoAudioMixingHandle.onAudioMixingCopyData(dataLength);
        }
        return null;
    }

    public static void onRoomStateUpdate(final String roomID, final int state, final int errorCode, final String extendedData) {
        Handler uiHandler;
        if (state == ZegoRoomState.DISCONNECTED.value() && errorCode != 0) {
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, 2, "onRoomStreamUpdate", errorCode, new Object[0]);
        }
        if ((uiHandler = ZegoExpressEngineInternalImpl.mUIHandler) == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onRoomStateUpdate(roomID, ZegoRoomState.values()[state], errorCode, ZegoExpressEngineJniCallback.getJsonObject(extendedData));
                }
            }
        });
    }

    public static void onRoomExtraInfoUpdate(final String roomID, ZegoRoomExtraInfo[] roomExtraInfoList) {
        final ArrayList<ZegoRoomExtraInfo> infoArrayList = new ArrayList<ZegoRoomExtraInfo>();
        for (int i = 0; i < roomExtraInfoList.length; ++i) {
            infoArrayList.add(roomExtraInfoList[i]);
        }
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onRoomExtraInfoUpdate(roomID, infoArrayList);
                }
            }
        });
    }

    public static void onRoomSetRoomExtraInfoResult(String roomID, String key, final int errorCode, final int seq) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<ZegoExpressEngineInternalImpl> clazz = ZegoExpressEngineInternalImpl.class;
                synchronized (ZegoExpressEngineInternalImpl.class) {
                    IZegoRoomSetRoomExtraInfoCallback callback = ZegoExpressEngineInternalImpl.sRoomSetExtraInfoHandler.get(seq);
                    if (callback != null) {
                        callback.onRoomSetRoomExtraInfoResult(errorCode);
                    }
                    ZegoExpressEngineInternalImpl.sRoomSetExtraInfoHandler.remove(seq);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    public static void onStreamExtraInfoUpdate(ZegoStream[] streamList, int streamInfoCount, String roomID) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<ZegoExpressEngineInternalImpl> clazz = ZegoExpressEngineInternalImpl.class;
                synchronized (ZegoExpressEngineInternalImpl.class) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    public static void onProcessRemoteAudioData(ByteBuffer data, int dataLength, ZegoAudioFrameParam param, String streamID) {
        IZegoCustomAudioProcessHandler zegoCustomAudioProcessHandler = ZegoExpressEngineInternalImpl.iZegoCustomAudioProcessHandler;
        if (zegoCustomAudioProcessHandler != null) {
            zegoCustomAudioProcessHandler.onProcessRemoteAudioData(data, dataLength, param, streamID);
        }
    }

    public static void onProcessCapturedAudioData(ByteBuffer data, int dataLength, ZegoAudioFrameParam param) {
        IZegoCustomAudioProcessHandler zegoCustomAudioProcessHandler = ZegoExpressEngineInternalImpl.iZegoCustomAudioProcessHandler;
        if (zegoCustomAudioProcessHandler != null) {
            zegoCustomAudioProcessHandler.onProcessCapturedAudioData(data, dataLength, param);
        }
    }

    public static void onRoomUserUpdate(final String roomID, final int updateType, ZegoUser[] userList) {
        final ArrayList<ZegoUser> userArrayList = new ArrayList<ZegoUser>();
        for (int i = 0; i < userList.length; ++i) {
            userArrayList.add(userList[i]);
        }
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onRoomUserUpdate(roomID, ZegoUpdateType.values()[updateType], userArrayList);
                }
            }
        });
    }

    public static void onPublisherStateUpdate(final String streamID, final int state, final int errorCode, final String extendedData) {
        Handler uiHandler;
        if (state == ZegoPublisherState.NO_PUBLISH.value() && errorCode != 0) {
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, 3, "onPublisherStateUpdate", errorCode, new Object[0]);
        }
        if ((uiHandler = ZegoExpressEngineInternalImpl.mUIHandler) == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onPublisherStateUpdate(streamID, ZegoPublisherState.values()[state], errorCode, ZegoExpressEngineJniCallback.getJsonObject(extendedData));
                }
            }
        });
    }

    private static JSONObject getJsonObject(String extendedData) {
        try {
            return new JSONObject(extendedData);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new JSONObject();
        }
    }

    public static void onPublisherUpdateCdnUrlResult(String streamID, final int errorCode, final int seq) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoPublisherUpdateCdnUrlCallback handler = ZegoExpressEngineInternalImpl.sPublisherUpdateCDNURLHandler.get(seq);
                if (handler != null) {
                    handler.onPublisherUpdateCdnUrlResult(errorCode);
                    ZegoExpressEngineInternalImpl.sPublisherUpdateCDNURLHandler.remove(seq);
                }
            }
        });
    }

    public static void onPlayerRecvSEI(final String streamID, final byte[] data, int dataLength) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onPlayerRecvSEI(streamID, data);
                }
            }
        });
    }

    public static void onPublisherUpdateStreamExtraInfoResult(final int errorCode, final int seq) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoPublisherSetStreamExtraInfoCallback handler = ZegoExpressEngineInternalImpl.sPublisherUpdateStreamExtraInfoHandler.get(seq);
                if (handler != null) {
                    handler.onPublisherSetStreamExtraInfoResult(errorCode);
                    ZegoExpressEngineInternalImpl.sPublisherUpdateStreamExtraInfoHandler.remove(seq);
                }
            }
        });
    }

    public static void onPublisherQualityUpdate(final String streamID, final ZegoPublishStreamQuality quality) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onPublisherQualityUpdate(streamID, quality);
                }
            }
        });
    }

    public static void onPublisherMediaEvent(int media_event, int reason, String streamID) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    // empty if block
                }
            }
        });
    }

    public static void onPublisherRecvAudioFirstFrame() {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onPublisherCapturedAudioFirstFrame();
                }
            }
        });
    }

    public static void onPublisherRecvVideoFirstFrame(final int zegoPublishChannel) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    ZegoCallbackHelpers.callOnPublisherCapturedVideoFirstFrameMethod(mEventHandler, ZegoPublishChannel.values()[zegoPublishChannel]);
                }
            }
        });
    }

    public static void onPublisherVideoSizeChanged(final int width, final int height, final int channel) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    ZegoCallbackHelpers.callOnPublisherVideoSizeChangedMethod(mEventHandler, width, height, ZegoPublishChannel.values()[channel]);
                }
            }
        });
    }

    public static void onPublisherRelayCDNStateUpdate(final String streamID, ZegoStreamRelayCDNInfo[] infoList) {
        final ArrayList<ZegoStreamRelayCDNInfo> infoArrayList = new ArrayList<ZegoStreamRelayCDNInfo>();
        for (int i = 0; i < infoList.length; ++i) {
            infoArrayList.add(infoList[i]);
        }
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onPublisherRelayCDNStateUpdate(streamID, infoArrayList);
                }
            }
        });
    }

    public static void onPlayerStateUpdate(final String streamID, final int state, final int errorCode, final String extendedData) {
        Handler uiHandler;
        if (state == ZegoPlayerState.NO_PLAY.value() && errorCode != 0) {
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, 4, "onPlayerStateUpdate", errorCode, new Object[0]);
        }
        if ((uiHandler = ZegoExpressEngineInternalImpl.mUIHandler) == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    ZegoExpressEngineInternalImpl.eventHandler.onPlayerStateUpdate(streamID, ZegoPlayerState.values()[state], errorCode, ZegoExpressEngineJniCallback.getJsonObject(extendedData));
                }
            }
        });
    }

    public static void onPlayerQualityUpdate(final String streamID, final ZegoPlayStreamQuality quality) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onPlayerQualityUpdate(streamID, quality);
                }
            }
        });
    }

    public static void onPlayerMediaEvent(final String streamID, final int mediaEvent) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onPlayerMediaEvent(streamID, ZegoPlayerMediaEvent.values()[mediaEvent]);
                }
            }
        });
    }

    public static void onPlayerRecvAudioFirstFrame(final String streamID) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onPlayerRecvAudioFirstFrame(streamID);
                }
            }
        });
    }

    public static void onPlayerRecvVideoFirstFrame(final String streamID) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    ZegoCallbackHelpers.callOnPlayerRecvVideoFirstFrameMethod(mEventHandler, streamID);
                }
            }
        });
    }

    public static void onPlayerRenderVideoFirstFrame(final String streamID) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    ZegoCallbackHelpers.callOnPlayerRenderVideoFirstFrameMethod(mEventHandler, streamID);
                }
            }
        });
    }

    public static void onPlayerVideoSizeChanged(final String streamID, final int width, final int height) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    ZegoCallbackHelpers.callOnPlayerVideoSizeChangedMethod(mEventHandler, streamID, width, height);
                }
            }
        });
    }

    public static void onRoomStreamExtraInfoUpdate(final String roomID, ZegoStream[] streamList) {
        final ArrayList<ZegoStream> streamArrayList = new ArrayList<ZegoStream>();
        for (int i = 0; i < streamList.length; ++i) {
            streamArrayList.add(streamList[i]);
        }
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onRoomStreamExtraInfoUpdate(roomID, streamArrayList);
                }
            }
        });
    }

    public static void onIMRecvBroadcastMessage(final String roomID, ZegoBroadcastMessageInfo[] messageList) {
        final ArrayList<ZegoBroadcastMessageInfo> messageArrayList = new ArrayList<ZegoBroadcastMessageInfo>();
        for (int i = 0; i < messageList.length; ++i) {
            messageArrayList.add(messageList[i]);
        }
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onIMRecvBroadcastMessage(roomID, messageArrayList);
                }
            }
        });
    }

    public static void onIMRecvCustomCommand(final String roomID, final ZegoUser fromUser, final String command) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onIMRecvCustomCommand(roomID, fromUser, command);
                }
            }
        });
    }

    public static void onIMSendBroadcastMessageResult(String roomID, final int errorCode, final int seq, final long messageID) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<ZegoExpressEngineInternalImpl> clazz = ZegoExpressEngineInternalImpl.class;
                synchronized (ZegoExpressEngineInternalImpl.class) {
                    IZegoIMSendBroadcastMessageCallback callback = ZegoExpressEngineInternalImpl.sIMSendBoradcastMssageHandler.get(seq);
                    if (callback != null) {
                        callback.onIMSendBroadcastMessageResult(errorCode, messageID);
                    }
                    ZegoExpressEngineInternalImpl.sIMSendBoradcastMssageHandler.remove(seq);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    public static void onIMRecvBarrageMessage(final String roomID, ZegoBarrageMessageInfo[] messageList) {
        final ArrayList<ZegoBarrageMessageInfo> messageArrayList = new ArrayList<ZegoBarrageMessageInfo>();
        messageArrayList.addAll(Arrays.asList(messageList));
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onIMRecvBarrageMessage(roomID, messageArrayList);
                }
            }
        });
    }

    public static void onIMSendBarrageMessageResult(final int seq, final int errorCode, final String messageID) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoIMSendBarrageMessageCallback callback = ZegoExpressEngineInternalImpl.sIMSendBarragetMssageHandler.get(seq);
                if (callback != null) {
                    callback.onIMSendBarrageMessageResult(errorCode, messageID);
                }
                ZegoExpressEngineInternalImpl.sIMSendBarragetMssageHandler.remove(seq);
            }
        });
    }

    public static void onIMSendCustomCommandResult(String roomID, final int errorCode, final int seq) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoIMSendCustomCommandCallback callback = ZegoExpressEngineInternalImpl.sIMSendCustomCommandHandler.get(seq);
                if (callback != null) {
                    callback.onIMSendCustomCommandResult(errorCode);
                }
                ZegoExpressEngineInternalImpl.sIMSendCustomCommandHandler.remove(seq);
            }
        });
    }

    public static void onRoomSendReliableMessageResult(final int errorCode, final String roomID, final String msgType, final int sendSeq, final int latestSeq) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<ZegoExpressEngineInternalImpl> clazz = ZegoExpressEngineInternalImpl.class;
                synchronized (ZegoExpressEngineInternalImpl.class) {
                    IZegoRoomSendReliableMessageCallback callback = ZegoExpressEngineInternalImpl.sRoomSendReliableMessageResultHandler.get(sendSeq);
                    if (callback != null) {
                        callback.onRoomSendReliableMessageResult(errorCode, roomID, msgType, latestSeq);
                    }
                    ZegoExpressEngineInternalImpl.sRoomSendReliableMessageResultHandler.remove(sendSeq);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    public static void onRoomGetReliableMessageResult(final int errorCode, final String roomID, final ZegoReliableMessage message, final int sendSeq) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<ZegoExpressEngineInternalImpl> clazz = ZegoExpressEngineInternalImpl.class;
                synchronized (ZegoExpressEngineInternalImpl.class) {
                    IZegoRoomGetReliableMessageCallback callback = ZegoExpressEngineInternalImpl.sRoomGetReliableMessageResultHandler.get(sendSeq);
                    if (callback != null) {
                        callback.onRoomGetReliableMessageResult(errorCode, roomID, message);
                    }
                    ZegoExpressEngineInternalImpl.sRoomGetReliableMessageResultHandler.remove(sendSeq);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    public static void onRoomRecvReliableMessage(final String roomID, final ZegoReliableMessage message) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onRoomRecvReliableMessage(roomID, message);
                }
            }
        });
    }

    public static void onRoomUpdateReliableMessageInfo(final String roomID, final String msgType, final int latestSeq) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onRoomUpdateReliableMessageInfo(roomID, msgType, latestSeq);
                }
            }
        });
    }

    public static void onRemoteCameraStateUpdate(final String streamID, final int state) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    ZegoCallbackHelpers.callOnRemoteCameraStateUpdateMethod(mEventHandler, streamID, ZegoRemoteDeviceState.values()[state]);
                }
            }
        });
    }

    public static void onRemoteMICStateUpdate(final String streamID, final int state) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    ZegoExpressEngineInternalImpl.eventHandler.onRemoteMicStateUpdate(streamID, ZegoRemoteDeviceState.values()[state]);
                }
            }
        });
    }

    public static void onEngineStateUpdate(final int zegoEngineState) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    ZegoExpressEngineInternalImpl.eventHandler.onEngineStateUpdate(ZegoEngineState.getZegoEngineState(zegoEngineState));
                }
            }
        });
    }

    public static void onEngineUninitUpdate() {
        IZegoDestroyCompletionCallback mIZegoDestroyCompletionCallback = ZegoExpressEngineInternalImpl.iZegoDestroyCompletionCallback;
        if (mIZegoDestroyCompletionCallback != null) {
            mIZegoDestroyCompletionCallback.onDestroyCompletion();
            ZegoExpressEngineInternalImpl.iZegoDestroyCompletionCallback = null;
        }
    }

    public static void onDeviceError(final int errorCode, final String deviceName) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onDeviceError(errorCode, deviceName);
                }
            }
        });
    }

    public static void onMixerSoundLevelUpdate(final HashMap<Integer, Float> soundLevelHashMap) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onMixerSoundLevelUpdate(soundLevelHashMap);
                }
            }
        });
    }

    public static void onPlayerSoundLevelUpdate(final HashMap<String, Float> soundLevelHashMap) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onRemoteSoundLevelUpdate(soundLevelHashMap);
                }
            }
        });
    }

    public static void onCapturedSoundLevelUpdate(final float soundLevel) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onCapturedSoundLevelUpdate(soundLevel);
                }
            }
        });
    }

    public static void onCapturedFrequencySpectrumUpdate(final float[] frequencySpectrum) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onCapturedAudioSpectrumUpdate(frequencySpectrum);
                }
            }
        });
    }

    public static void onPlayerFrequencySpectrumUpdate(final HashMap<String, float[]> frequencySpectrums) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onRemoteAudioSpectrumUpdate(frequencySpectrums);
                }
            }
        });
    }

    public static void onMixerStartResult(final int seq, final int errorCode, final String extendedData) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoMixerStartCallback callback = ZegoExpressEngineInternalImpl.sMixerStartResultHandler.get(seq);
                if (callback != null) {
                    callback.onMixerStartResult(errorCode, ZegoExpressEngineJniCallback.getJsonObject(extendedData));
                }
                ZegoExpressEngineInternalImpl.sMixerStartResultHandler.remove(seq);
            }
        });
    }

    public static void onMixerStopResult(final int seq, final int errorCode) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoMixerStopCallback callback = ZegoExpressEngineInternalImpl.sMixerStopResultHandler.get(seq);
                if (callback != null) {
                    callback.onMixerStopResult(errorCode);
                }
                ZegoExpressEngineInternalImpl.sMixerStartResultHandler.remove(seq);
            }
        });
    }

    public static void onRoomOnlineUserCountUpdate(final String roomID, final int count) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onRoomOnlineUserCountUpdate(roomID, count);
                }
            }
        });
    }

    public static void onMixerRelayCDNStateUpdate(ZegoStreamRelayCDNInfo[] infoList, final String taskID) {
        final ArrayList<ZegoStreamRelayCDNInfo> infoArrayList = new ArrayList<ZegoStreamRelayCDNInfo>();
        for (int i = 0; i < infoList.length; ++i) {
            infoArrayList.add(infoList[i]);
        }
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = ZegoExpressEngineInternalImpl.eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onMixerRelayCDNStateUpdate(taskID, infoArrayList);
                }
            }
        });
    }

    public static void onCapturedAudioData(ByteBuffer data, int dataLength, int sampleRate, int channel) {
        IZegoAudioDataHandler handler = ZegoExpressEngineInternalImpl.iZegoAudioDataHandler;
        if (handler != null) {
            ZegoExpressEngineJniCallback.zegoCaptureAudioFrameParam.sampleRate = ZegoAudioSampleRate.getZegoAudioSampleRate(sampleRate);
            ZegoExpressEngineJniCallback.zegoCaptureAudioFrameParam.channel = ZegoAudioChannel.getZegoAudioChannel(channel);
            handler.onCapturedAudioData(data, dataLength, zegoCaptureAudioFrameParam);
        }
    }

    public static void onRemoteAudioData(ByteBuffer data, int dataLength, int sampleRate, int channel) {
        IZegoAudioDataHandler handler = ZegoExpressEngineInternalImpl.iZegoAudioDataHandler;
        if (handler != null) {
            ZegoExpressEngineJniCallback.zegoRemoteAudioFrameParam.sampleRate = ZegoAudioSampleRate.getZegoAudioSampleRate(sampleRate);
            ZegoExpressEngineJniCallback.zegoRemoteAudioFrameParam.channel = ZegoAudioChannel.getZegoAudioChannel(channel);
            handler.onRemoteAudioData(data, dataLength, zegoRemoteAudioFrameParam);
        }
    }

    public static void onPlaybackAudioData(ByteBuffer data, int dataLength, int sampleRate, int channel) {
        IZegoAudioDataHandler handler = ZegoExpressEngineInternalImpl.iZegoAudioDataHandler;
        if (handler != null) {
            ZegoExpressEngineJniCallback.zegoPlaybackAudioFrameParam.sampleRate = ZegoAudioSampleRate.getZegoAudioSampleRate(sampleRate);
            ZegoExpressEngineJniCallback.zegoPlaybackAudioFrameParam.channel = ZegoAudioChannel.getZegoAudioChannel(channel);
            handler.onPlaybackAudioData(data, dataLength, zegoPlaybackAudioFrameParam);
        }
    }

    public static void onMixedAudioData(ByteBuffer data, int dataLength, int sampleRate, int channel) {
        IZegoAudioDataHandler handler = ZegoExpressEngineInternalImpl.iZegoAudioDataHandler;
        if (handler != null) {
            ZegoExpressEngineJniCallback.zegoMixedAudioFrameParam.sampleRate = ZegoAudioSampleRate.getZegoAudioSampleRate(sampleRate);
            ZegoExpressEngineJniCallback.zegoMixedAudioFrameParam.channel = ZegoAudioChannel.getZegoAudioChannel(channel);
            handler.onMixedAudioData(data, dataLength, zegoMixedAudioFrameParam);
        }
    }

    public static void onRemoteVideoFrameEncodedData(ByteBuffer buffers, int dataLen, int format, boolean isKeyFrame, int width, int height, ByteBuffer SEIData, int SEIDataLength, long referenceTimeMillisecond, String streamID) {
        Object iZegoCustomVideoRenderHandler = ZegoExpressEngineInternalImpl.mCustomVideoRenderHandler;
        if (iZegoCustomVideoRenderHandler != null) {
            ZegoVideoEncodedFrameParam param = new ZegoVideoEncodedFrameParam();
            param.isKeyFrame = isKeyFrame;
            param.format = ZegoVideoEncodedFrameFormat.getZegoVideoEncodedFrameFormat(format);
            param.width = width;
            param.height = height;
            param.SEIData = SEIData;
            param.SEIDataLength = SEIDataLength;
            ZegoCallbackHelpers.callCustomVideoRenderOnRemoteVideoFrameEncodedDataMethod(iZegoCustomVideoRenderHandler, buffers, dataLen, param, referenceTimeMillisecond, streamID);
        }
    }

    public static void onCapturedDataRecordStateUpdate(final int state, final int errorCode, final String filePath, final int recordType, final int channel) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoDataRecordEventHandler handler = ZegoExpressEngineInternalImpl.iZegoDataRecordEventHandler;
                if (handler != null) {
                    ZegoDataRecordConfig zegoDataRecordConfig = new ZegoDataRecordConfig();
                    zegoDataRecordConfig.filePath = filePath;
                    zegoDataRecordConfig.recordType = ZegoDataRecordType.getZegoDataRecordType(recordType);
                    handler.onCapturedDataRecordStateUpdate(ZegoDataRecordState.getZegoDataRecordState(state), errorCode, zegoDataRecordConfig, ZegoPublishChannel.getZegoPublishChannel(channel));
                }
            }
        });
    }

    public static void onCapturedDataRecordProgressUpdate(final long duration, final long currentFileSize, final String filePath, final int recordType, final int channel) {
        Handler uiHandler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoDataRecordEventHandler handler = ZegoExpressEngineInternalImpl.iZegoDataRecordEventHandler;
                if (handler != null) {
                    ZegoDataRecordProgress zegoDataRecordProgress = new ZegoDataRecordProgress();
                    zegoDataRecordProgress.currentFileSize = currentFileSize;
                    zegoDataRecordProgress.duration = duration;
                    ZegoDataRecordConfig zegoDataRecordConfig = new ZegoDataRecordConfig();
                    zegoDataRecordConfig.filePath = filePath;
                    zegoDataRecordConfig.recordType = ZegoDataRecordType.getZegoDataRecordType(recordType);
                    handler.onCapturedDataRecordProgressUpdate(zegoDataRecordProgress, zegoDataRecordConfig, ZegoPublishChannel.getZegoPublishChannel(channel));
                }
            }
        });
    }

    public static void onCustomVideoRenderCapturedFrameData(ByteBuffer[] buffers, int[] dataLen, int[] strides, int width, int height, int videoPixelFormat, int videoFlipMode, int channel) {
        Object iZegoCustomVideoRenderHandler = ZegoExpressEngineInternalImpl.mCustomVideoRenderHandler;
        if (iZegoCustomVideoRenderHandler != null) {
            ZegoVideoFrameParam zegoVideoFrameParam = new ZegoVideoFrameParam();
            for (int i = 0; i < strides.length; ++i) {
                zegoVideoFrameParam.strides[i] = strides[i];
            }
            zegoVideoFrameParam.format = ZegoVideoFrameFormat.values()[videoPixelFormat];
            zegoVideoFrameParam.width = width;
            zegoVideoFrameParam.height = height;
            ZegoCallbackHelpers.callCustomVideoRenderOnCapturedVideoFrameRawDataMethod(iZegoCustomVideoRenderHandler, buffers, dataLen, zegoVideoFrameParam, ZegoVideoFlipMode.values()[videoFlipMode], ZegoPublishChannel.values()[channel]);
        }
    }

    public static void onCustomVideoRenderRemoteFrameData(ByteBuffer[] buffers, int[] dataLen, int[] strides, int width, int height, int videoPixelFormat, String streamID) {
        Object iZegoCustomVideoRenderHandler = ZegoExpressEngineInternalImpl.mCustomVideoRenderHandler;
        if (iZegoCustomVideoRenderHandler != null) {
            ZegoVideoFrameParam zegoVideoFrameParam = new ZegoVideoFrameParam();
            for (int i = 0; i < strides.length; ++i) {
                zegoVideoFrameParam.strides[i] = strides[i];
            }
            zegoVideoFrameParam.format = ZegoVideoFrameFormat.values()[videoPixelFormat];
            zegoVideoFrameParam.width = width;
            zegoVideoFrameParam.height = height;
            ZegoCallbackHelpers.callCustomVideoRenderOnCustomVideoRenderRemoteFrameDataMethod(iZegoCustomVideoRenderHandler, buffers, dataLen, zegoVideoFrameParam, streamID);
        }
    }

    public static void onEncodedDataTrafficControl(final int width, final int height, final int fps, final int bitrate, final int channel) {
        Handler handler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (handler == null) {
            return;
        }
        handler.post(new Runnable(){

            @Override
            public void run() {
                Object customVideoCaptureHandler = ZegoExpressEngineInternalImpl.mCustomVideoCaptureHandler;
                if (customVideoCaptureHandler != null) {
                    ZegoCallbackHelpers.callCustomVideoCaptureOnEncodedDataTrafficControlMethod(customVideoCaptureHandler, width, height, fps, bitrate, ZegoPublishChannel.getZegoPublishChannel(channel));
                    ZegoExpressEngineInternalImpl.isCustomVideoCapturing = true;
                }
            }
        });
    }
}

